# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LicenseArgs', 'License']

@pulumi.input_type
class LicenseArgs:
    def __init__(__self__, *,
                 license_key: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a License resource.
        :param pulumi.Input[_builtins.str] license_key: The license key value.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of labels to be applied to the license key.
               
               > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        """
        pulumi.set(__self__, "license_key", license_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> pulumi.Input[_builtins.str]:
        """
        The license key value.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_key", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of labels to be applied to the license key.

        > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class _LicenseState:
    def __init__(__self__, *,
                 edition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 total: Optional[pulumi.Input[_builtins.int]] = None,
                 used: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering License resources.
        :param pulumi.Input[_builtins.str] edition_key: The product edition of the license key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of labels to be applied to the license key.
               
               > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        :param pulumi.Input[_builtins.str] license_key: The license key value.
        :param pulumi.Input[_builtins.str] name: The display name for the license key.
        :param pulumi.Input[_builtins.int] total: The total number of units contained in the license key.
        :param pulumi.Input[_builtins.int] used: The number of units assigned to this license key.
        """
        if edition_key is not None:
            pulumi.set(__self__, "edition_key", edition_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if total is not None:
            pulumi.set(__self__, "total", total)
        if used is not None:
            pulumi.set(__self__, "used", used)

    @_builtins.property
    @pulumi.getter(name="editionKey")
    def edition_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product edition of the license key.
        """
        return pulumi.get(self, "edition_key")

    @edition_key.setter
    def edition_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition_key", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of labels to be applied to the license key.

        > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The license key value.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the license key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def total(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of units contained in the license key.
        """
        return pulumi.get(self, "total")

    @total.setter
    def total(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total", value)

    @_builtins.property
    @pulumi.getter
    def used(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of units assigned to this license key.
        """
        return pulumi.get(self, "used")

    @used.setter
    def used(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used", value)


@pulumi.type_token("vsphere:index/license:License")
class License(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VMware vSphere license resource. This can be used to add and remove license keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        license_key = vsphere.License("licenseKey",
            license_key="00000-00000-00000-00000-00000",
            labels={
                "VpxClientLicenseLabel": "example",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of labels to be applied to the license key.
               
               > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        :param pulumi.Input[_builtins.str] license_key: The license key value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicenseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VMware vSphere license resource. This can be used to add and remove license keys.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        license_key = vsphere.License("licenseKey",
            license_key="00000-00000-00000-00000-00000",
            labels={
                "VpxClientLicenseLabel": "example",
            })
        ```

        :param str resource_name: The name of the resource.
        :param LicenseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicenseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicenseArgs.__new__(LicenseArgs)

            __props__.__dict__["labels"] = labels
            if license_key is None and not opts.urn:
                raise TypeError("Missing required property 'license_key'")
            __props__.__dict__["license_key"] = license_key
            __props__.__dict__["edition_key"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["total"] = None
            __props__.__dict__["used"] = None
        super(License, __self__).__init__(
            'vsphere:index/license:License',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            edition_key: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            license_key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            total: Optional[pulumi.Input[_builtins.int]] = None,
            used: Optional[pulumi.Input[_builtins.int]] = None) -> 'License':
        """
        Get an existing License resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] edition_key: The product edition of the license key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of labels to be applied to the license key.
               
               > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        :param pulumi.Input[_builtins.str] license_key: The license key value.
        :param pulumi.Input[_builtins.str] name: The display name for the license key.
        :param pulumi.Input[_builtins.int] total: The total number of units contained in the license key.
        :param pulumi.Input[_builtins.int] used: The number of units assigned to this license key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicenseState.__new__(_LicenseState)

        __props__.__dict__["edition_key"] = edition_key
        __props__.__dict__["labels"] = labels
        __props__.__dict__["license_key"] = license_key
        __props__.__dict__["name"] = name
        __props__.__dict__["total"] = total
        __props__.__dict__["used"] = used
        return License(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="editionKey")
    def edition_key(self) -> pulumi.Output[_builtins.str]:
        """
        The product edition of the license key.
        """
        return pulumi.get(self, "edition_key")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of labels to be applied to the license key.

        > **NOTE:** Labels are not allowed for unmanaged ESX hosts.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> pulumi.Output[_builtins.str]:
        """
        The license key value.
        """
        return pulumi.get(self, "license_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for the license key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def total(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of units contained in the license key.
        """
        return pulumi.get(self, "total")

    @_builtins.property
    @pulumi.getter
    def used(self) -> pulumi.Output[_builtins.int]:
        """
        The number of units assigned to this license key.
        """
        return pulumi.get(self, "used")

