"""This file contains prompts for CritiqueAndRefineConvert operations."""

### CRITIQUE PROMPT AND CRITERIA ###
BASE_CRITIQUE_PROMPT = """You are a helpful assistant tasked with critiquing the output of a model based on a given prompt.
Below is the original user prompt used to generate the output:

ORIGINAL PROMPT:
<<original-prompt-placeholder>>

Here is the output generated by the model:

OUTPUT:
{original_output}

Your task is to critique the output based on the following:
{critique_criteria}

{finish_instruction}
"""

MAP_CRITIQUE_CRITERIA = """1. Does the JSON object adhere to the required format? Highlight any structural issues.
2. Are the values of the output fields accurate based on the provided context? If any fields are incorrect or missing, provide specific examples.
3. Are there any logical errors in reasoning used to derive the output? Provide detailed feedback on potential mistakes.
"""
FILTER_CRITIQUE_CRITERIA = """1. Does the output adhere to the required TRUE/FALSE format? Highlight any issues.
2. Is the TRUE/FALSE determination accurate based on the provided context? If there is evidence for an incorrect determination, provide specific reasons why.
3. Are there any logical errors in reasoning used to derive the TRUE/FALSE determination? Provide detailed feedback on potential mistakes.
"""

MAP_CRITIQUE_FINISH_INSTRUCTION = """Finish your critique with actionable recommendations for improving the JSON object."""
FILTER_CRITIQUE_FINISH_INSTRUCTION = """Finish your critique with actionable recommendations for improving the model's reasoning and answer."""

### REFINEMENT PROMPT AND CRITERIA ###
BASE_REFINEMENT_PROMPT = """You are a helpful assistant tasked with refining the output of a model based on a critique.
Below is the original user prompt used to generate the output:

ORIGINAL PROMPT:
<<original-prompt-placeholder>>

Here is the original output generated by the model:

OUTPUT:
{original_output}

Here is the critique of the output:

CRITIQUE:
{critique_output}

Your task is to refine the original output to address the critique. Ensure that:
{refinement_criteria}

{finish_instruction}
"""

MAP_REFINEMENT_CRITERIA = """1. The answer adheres to the required JSON format specified in the original prompt.
2. Correctly derives all values for the output fields based on the provided context.
3. Resolves any logical errors identified in the critique.
"""
FILTER_REFINEMENT_CRITERIA = """1. The answer adheres to the required TRUE/FALSE format specified in the original prompt.
2. Correctly derives the final TRUE/FALSE determination based on the provided context.
3. Resolves any logical errors identified in the critique.
"""

MAP_REFINEMENT_FINISH_INSTRUCTION = """Return the refined JSON object as your final answer."""
FILTER_REFINEMENT_FINISH_INSTRUCTION = """Return the final TRUE/FALSE answer."""
