# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Base64Image(UncheckedBaseModel):
    type: typing.Literal["base64"] = "base64"
    media_type: str = pydantic.Field()
    """
    The media type for the image.
    """

    data: str = pydantic.Field()
    """
    The base64 encoded image data.
    """

    detail: typing.Optional[str] = pydantic.Field(default=None)
    """
    What level of detail to use when processing and understanding the image (low, high, or auto to let the model decide)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
