# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .file_processing_status import FileProcessingStatus
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class FileMetadata(UncheckedBaseModel):
    """
    Representation of a single FileMetadata
    """

    source_id: str = pydantic.Field()
    """
    The unique identifier of the source associated with the document.
    """

    file_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the file.
    """

    original_file_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The original name of the file as uploaded.
    """

    file_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The path to the file.
    """

    file_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the file (MIME type).
    """

    file_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the file in bytes.
    """

    file_creation_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    The creation date of the file.
    """

    file_last_modified_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    The last modified date of the file.
    """

    processing_status: typing.Optional[FileProcessingStatus] = pydantic.Field(default=None)
    """
    The current processing status of the file (e.g. pending, parsing, embedding, completed, error).
    """

    error_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional error message if the file failed processing.
    """

    total_chunks: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of chunks for the file.
    """

    chunks_embedded: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of chunks that have been embedded.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional full-text content of the file; only populated on demand due to its size.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the File
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The creation date of the file.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The update date of the file.
    """

    is_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this file is deleted or not.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
