# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
from .letta_message_union import LettaMessageUnion
import pydantic
from .letta_stop_reason import LettaStopReason
from .letta_usage_statistics import LettaUsageStatistics
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class LettaResponse(UncheckedBaseModel):
    """
    Response object from an agent interaction, consisting of the new messages generated by the agent and usage statistics.
    The type of the returned messages can be either `Message` or `LettaMessage`, depending on what was specified in the request.

    Attributes:
        messages (List[Union[Message, LettaMessage]]): The messages returned by the agent.
        usage (LettaUsageStatistics): The usage statistics
    """

    messages: typing.List[LettaMessageUnion] = pydantic.Field()
    """
    The messages returned by the agent.
    """

    stop_reason: LettaStopReason
    usage: LettaUsageStatistics = pydantic.Field()
    """
    The usage statistics of the agent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
