# cloudqueue/queues/aws_queue.py
import boto3
from botocore.exceptions import BotoCoreError, ClientError
from cloudqueue.exceptions import CloudQueueError, MessageProcessingError
from cloudqueue.base import QueueClient

class AWSQueueClient(QueueClient):
    def __init__(self, queue_name, region_name="us-east-1"):
        try:
            self.sqs = boto3.resource("sqs", region_name=region_name)
            self.queue = self.sqs.get_queue_by_name(QueueName=queue_name)
        except (BotoCoreError, ClientError) as e:
            raise CloudQueueError(f"Failed to connect to AWS SQS: {e}") from e

    def receive_messages(self, messages_per_page=1, visibility_timeout=30, wait_time=10):
        try:
            return self.queue.receive_messages(
                MaxNumberOfMessages=messages_per_page,
                VisibilityTimeout=visibility_timeout,
                WaitTimeSeconds=wait_time
            )
        except (BotoCoreError, ClientError) as e:
            raise CloudQueueError(f"Failed to receive messages from AWS SQS: {e}") from e

    def delete_message(self, message):
        try:
            message.delete()
        except Exception as e:
            raise MessageProcessingError(f"Failed to delete message: {e}") from e