from .aws_queue import AWSQueueClient
from .azure_queue import AzureQueueClient
# from .queues.gcp_queue import GCPQueueClient  # add later if needed

def get_queue_client(provider: str, **kwargs):
    provider = provider.lower()
    if provider == "aws":
        return AWSQueueClient(**kwargs)
    elif provider == "azure":
        return AzureQueueClient(**kwargs)
    else:
        raise ValueError(f"Unsupported provider: {provider}")