
class SampleInputs:
    """
    SampleInputs class
    """

    def __init__(self):
        self.wind_farm = {
            "name": "IEA Wind Task 37 740-10-MW Reference Offshore Wind Plant (regular layout)",
            "layouts":
                {
                    "coordinates":
                        {
                            "x": [
                                500968.1461, 499748.6565, 501245.7744, 500026.2848,
                                498527.8286,497308.339, 501523.4027, 500303.9131,
                                498805.4569, 497585.9673, 496087.5111, 494868.0215,
                                501801.031, 500581.5414, 499083.0852, 497863.5956,
                                496365.1394, 495145.6498, 493647.1936, 492427.704,
                                502078.6593, 500859.1697, 499360.7135, 498141.2239,
                                496642.7677, 495423.2781, 493924.8219, 492705.3323,
                                491206.8762, 489987.3865, 502356.2876, 501136.798,
                                499638.3418, 498418.8522, 496920.396, 495700.9064,
                                494202.4502, 492982.9606, 491484.5045, 490265.0148,
                                488766.5587, 487547.069, 502633.9159, 501414.4263,
                                499915.9701, 498696.4805, 497198.0243, 495978.5347,
                                494480.0786, 493260.5889, 491762.1328, 490542.6431,
                                489044.187, 487824.6973, 486326.2412, 485106.7515,
                                497475.6526, 496256.163, 494757.7069, 493538.2172,
                                492039.7611, 490820.2714, 489321.8153, 488102.3256,
                                486603.8695, 497753.2809, 496533.7913, 495035.3352,
                                493815.8455, 492317.3894, 489599.4436, 498030.9093,
                                496811.4196, 495312.9635
                            ],
                            "y": [
                                5716452.784, 5717635.848, 5718427.22, 5719610.283,
                                5718809.394, 5719992.458, 5720401.656, 5721584.719,
                                5720783.83, 5721966.894, 5721166.004, 5722349.068,
                                5722376.092, 5723559.155, 5722758.266, 5723941.33, 
                                5723140.44, 5724323.504, 5723522.615, 5724705.678,
                                5724350.528, 5725533.591, 5724732.702, 5725915.765,
                                5725114.876, 5726297.94, 5725497.051, 5726680.114,
                                5725879.225, 5727062.288, 5726324.963, 5727508.027,
                                5726707.138, 5727890.201, 5727089.312, 5728272.376,
                                5727471.486, 5728654.55, 5727853.661, 5729036.724,
                                5728235.835, 5729418.899, 5728299.399, 5729482.463,
                                5728681.574, 5729864.637, 5729063.748, 5730246.812,
                                5729445.922, 5730628.986, 5729828.097, 5731011.16,
                                5730210.271, 5731393.335, 5730592.445, 5731775.509,
                                5731038.184, 5732221.248, 5731420.358, 5732603.422,
                                5731802.533, 5732985.596, 5732184.707, 5733367.77,
                                5732566.881, 5733012.62, 5734195.683, 5733394.794,
                                5734577.858, 5733776.968, 5734159.143, 5734987.056,
                                5736170.119, 5735369.23
                            ]
                        }
                },
            "electrical_substations":
                [
                    {
                        "electrical_substation":
                            {
                                "coordinates":
                                    {
                                        "x": [497620.7],
                                        "y": [5730622.0]
                                    },
                                "capacity": 740.0
                            }
                    }
                ],
            "electrical_collection_array":
                {
                    "edges": [
                        [0, 2, 0], [1, 4, 0], [2, 6, 0], [3, 8, 0], [4, 5, 0], [5, 10, 0],
                        [6, 7, 0], [7, 14, 1], [8, 9, 0], [9, 15, 0], [10, 16, 1], [11, 18, 0],
                        [12, 13, 0], [13, 20, 0], [14, 22, 1], [15, 24, 1], [16, 17, 1],
                        [17, 25, 2], [18, 19, 0], [19, 26, 0], [20, 21, 0], [21, 32, 1],
                        [21, 30, 0], [22, 23, 2], [23, -1, 2], [24, 34, 1], [25, -1, 2],
                        [26, 27, 1], [27, 36, 1], [28, 29, 0], [29, 38, 0], [29, 40, 0],
                        [31, 44, 0], [31, 42, 0], [32, 33, 2], [33, -1, 2], [34, 46, 2],
                        [35, -1, 2], [35, 36, 2], [37, 48, 1], [37, 38, 1], [39, 50, 1],
                        [39, 52, 1], [41, 52, 0], [41, 54, 0], [43, 44, 0], [44, 45, 1],
                        [45, -1, 1], [46, -1, 2], [47, -1, 2], [47, 48, 2], [49, -1, 2],
                        [49, 50, 2], [51, 60, 1], [51, 62, 0], [53, 62, 0], [53, 64, 0],
                        [54, 55, 0], [56, -1, 2], [56, 65, 1], [57, -1, 2], [57, 67, 2],
                        [58, -1, 2], [58, 59, 2], [59, 60, 1], [61, 69, 0], [61, 70, 0],
                        [63, 70, 0], [65, 66, 1], [66, 71, 0], [66, 73, 0], [67, 68, 1],
                        [68, 69, 1], [71, 72, 0]
                        ],
                    "cables":
                        {
                            "cable_type": [0, 1, 2],
                            "cross_section": [95, 240, 500],
                            "capacity": [3, 5, 7],
                            "cost": [206.0, 287.0, 406.0]
                        },
                },
            "turbines":
                {
                    "name": "IEA Wind Task 37 10MW Offshore Reference Turbine",
                    "performance":
                        {
                            "rated_power": 10000000,
                            "rated_wind_speed": 11.0,
                            "cutin_wind_speed": 4.0,
                            "cutout_wind_speed": 25.0,
                            "Ct_curve":
                                {
                                    "Ct_values": [
                                        0.770113776, 0.776301765, 0.782430404, 0.781982993,
                                        0.780246928, 0.777153006, 0.771853687, 0.776845963,
                                        0.776845963, 0.776845963, 0.776845963, 0.776845963,
                                        0.776845963, 0.776845963, 0.776845963, 0.776845963,
                                        0.776845963, 0.776845963, 0.776845963, 0.776845963,
                                        0.776845963, 0.776845963, 0.776845963, 0.776845963,
                                        0.776845963, 0.776845963, 0.767521911, 0.765104347,
                                        0.758675026, 0.505649564, 0.431035612, 0.370827539,
                                        0.320855929, 0.278805531, 0.243151019, 0.212773558,
                                        0.186803785, 0.164542221, 0.145414565, 0.128943645,
                                        0.114730283, 0.102438991, 0.091786964, 0.082535328,
                                        0.074482009, 0.067455867, 0.061311766, 0.05592648, 
                                        0.051195261, 0.047029125
                                    ],
                                    "Ct_wind_speeds": [
                                        4.0, 4.514652562, 5.000795688, 5.457350016, 5.883301884,
                                        6.277705571, 6.639685402, 6.968437691, 7.263232527,
                                        7.523415391, 7.748408611, 7.937712648, 8.090907197,
                                        8.20765213, 8.287688244, 8.330837837, 8.337005108,
                                        8.367833853, 8.435590166, 8.540123611, 8.681202099,
                                        8.858512398, 9.071660837, 9.320174171, 9.603500641,
                                        9.921011189, 10.27200086, 10.65569038, 10.75773635,
                                        11.51769068, 11.9940876, 12.49936091, 13.03238875,
                                        13.59198769, 14.17691527, 14.7858728, 15.41750825,
                                        16.07041923, 16.74315611, 17.43422525, 18.1420923,
                                        18.86518562, 19.60189976, 20.35059904, 21.10962115,
                                        21.87728087, 22.65187381, 23.43168018, 24.21496861,
                                        25.0
                                    ]
                                }
                        },
                    "hub_height": 119.0,
                    "rotor_diameter": 198.0
                }
        }

        self.energy_resource_gridded = {
            "name": "Parque Ficticio Energy Resource Subset",
            "wind_resource": {
                "height":[30.0, 200.0],
                "sector_probability": { # dims = [(x,y), height, wd, ws]
                    "data": [
                        [
                            [
                                [0.05178533, 0.02514381],
                                [0.05509089, 0.02517059],
                            ],
                            [
                                [0.05268032, 0.02515499],
                                [0.0555311, 0.02534156],
                            ]
                        ],
                        [
                            [
                                [0.05194768, 0.02473865],
                                [0.05485823, 0.02492476],
                            ],
                            [
                                [0.05188083, 0.02509297],
                                [0.05537025, 0.02519406],
                            ]
                        ]
                    ],
                    "dims": ["x", "height", "wind_direction", "wind_speed"],
                },
                "weibull_a": {
                    "data": [
                        [
                            [
                                [2.279956, 1.635157],
                                [5.480005, 4.408058],
                            ],
                            [
                                [2.317578, 1.657686],
                                [5.538026, 4.482135],
                            ]
                        ],
                        [
                            [
                                [2.197967, 1.636049],
                                [5.541646, 4.444934],
                            ],
                            [
                                [2.197305, 1.664085],
                                [5.595516, 4.53055],
                            ]
                        ]
                    ],
                    "dims": ["x", "height", "wind_direction", "wind_speed"],
                },
                "weibull_k": {
                    "data": [
                        [
                            [
                                [1.763672, 2.107422],
                                [2.052734, 2.423828],
                            ],
                            [
                                [1.759766, 2.126953],
                                [2.052734, 2.423828],
                            ]
                        ],
                        [
                            [
                                [1.771484, 2.072266],
                                [2.052734, 2.423828],
                            ],
                            [
                                [1.771484, 2.103516],
                                [2.052734, 2.423828],
                            ]
                        ]
                    ],
                    "dims": ["x", "height", "wind_direction", "wind_speed"],
                },
                "wind_direction": [0, 30],
                "wind_speed": [8, 10],
                "x": [262878.0, 262978.0],
                "y": [6504714.0, 6504814.0],
            },
        }

        self.energy_resource_IEA_case1 = {
            "name": "IEA Wind Task 37 Case Study 1+2 Plant Energy Resource",
            "wind_resource": {
                "wind_direction": [
                    0., 22.5, 45., 67.5,90., 112.5, 135., 157.5, 180.,
                    202.5, 225., 247.5,270., 292.5, 315., 337.5
                ],
                "wind_speed": [9.8],
                "probability": {
                    "data": [
                        .025, .024, .029, .036, .063, .065, .100, .122,
                        .063, .038, .039, .083, .213, .046, .032, .022
                    ],
                    "dims": ["wind_direction"]
                },
                "turbulence_intensity": {
                    "data": 0.075,
                    "dims": [],
                }
            }
        }

        self.energy_resource_IEA_case2 = {
            "name": "IEA Wind Task 37 Case Study 3 Plant Energy Resource",
            "wind_resource": {
                "wind_direction": [
                    0.0, 18.0, 36.0, 54.0, 72.0, 90.0, 108.0, 126.0, 144.0, 162.0, 180.0,
                    198.0, 216.0, 234.0, 252.0, 270.0, 288.0, 306.0, 324.0, 342.0
                ],
                "wind_speed": [
                    0.90, 1.98, 3.18, 4.40, 5.64, 6.87, 8.11, 9.35, 10.59,11.83, 13.07,
                    14.31, 15.56, 16.80, 18.04, 19.28, 20.52, 21.77, 23.01, 24.25
                ],
                "sector_probability": {
                    "data": [
                        0.0312, 0.0260, 0.0255, 0.0253, 0.0297, 0.0397, 0.0506, 0.0510, 0.0415,
                        0.0414, 0.0522, 0.0634, 0.0706, 0.0723, 0.0697, 0.0668, 0.0676, 0.0677,
                        0.0613, 0.0464
                    ],
                    "dims": ["wind_direction"],
                },
                "probability": {
                    "data": [
                        [
                            0.0156401750, 0.0497090909, 0.0811024638, 0.1050883329, 0.1190301631,
                            0.1222668202, 0.1159445367, 0.1025108097, 0.0850102571, 0.0663764744,
                            0.0489239316, 0.0340999223, 0.0225045684, 0.0140748572, 0.0083476946,
                            0.0046969535, 0.0025085092, 0.0012722583, 0.0006121243, 0.0002800569
                        ],
                        [
                            0.0174786954, 0.0548443199, 0.0883795728, 0.1128729487, 0.1256551886,
                            0.1264602666, 0.1171083595, 0.1007717749, 0.0810568625, 0.0611779343,
                            0.0434372134, 0.0290638192, 0.0183497799, 0.0109410613, 0.0061655981,
                            0.0032843186, 0.0016551606, 0.0007890765, 0.0003560345, 0.0001520147
                        ],
                        [
                            0.0163365064, 0.0541606790, 0.0898797863, 0.1167076179, 0.1309060581,
                            0.1316880823, 0.1209647499, 0.1024541761, 0.0804744947, 0.0588288237,
                            0.0401142435, 0.0255527921, 0.0152204718, 0.0084822630, 0.0044241371,
                            0.0021610670, 0.0009880306, 0.0004230131, 0.0001690052, 0.0000640020
                        ],
                        [
                            0.0131561184, 0.0483094348, 0.0851957668, 0.1153680383, 0.1333342000,
                            0.1368182314, 0.1269601426, 0.1075589680, 0.0836297527, 0.0598535387,
                            0.0394933554, 0.0240452164, 0.0135111216, 0.0070060631, 0.0033520302,
                            0.0014790133, 0.0006010054, 0.0002250020, 0.0000780007, 0.0000250002
                        ],
                        [
                            0.0096451543, 0.0385656170, 0.0720491528, 0.1024286389, 0.1239279828,
                            0.1330241284, 0.1291130658, 0.1144128306, 0.0930354886, 0.0696031136,
                            0.0479667675, 0.0304604874, 0.0178212851, 0.0096011536, 0.0047590761,
                            0.0021690347, 0.0009070145, 0.0003480056, 0.0001230020, 0.0000390006
                        ],
                        [
                            0.0059162662, 0.0266481992, 0.0539554280, 0.0821266957, 0.1060917741,
                            0.1216774755, 0.1264536904, 0.1202924132, 0.1052787375, 0.0849718237,
                            0.0632988484, 0.0435159582, 0.0275892415, 0.0161127251, 0.0086563895,
                            0.0042721922, 0.0019330870, 0.0008010360, 0.0003030136, 0.0001050047
                        ],
                        [
                            0.0033912442, 0.0177062749, 0.0394378395, 0.0647356610, 0.0894924435,
                            0.1095018841, 0.1212547303, 0.1228158427, 0.1143572337, 0.0980800618,
                            0.0774955797, 0.0563590579, 0.0376647119, 0.0230836620, 0.0129429319,
                            0.0066224768, 0.0030842221, 0.0013030938, 0.0004990359, 0.0001720124
                        ],
                        [
                            0.0023011680, 0.0133949778, 0.0319683337, 0.0553040372, 0.0799918394,
                            0.1020204475, 0.1174695753, 0.1234710134, 0.1190496906, 0.1054576984,
                            0.0857852623, 0.0639746702, 0.0436311851, 0.0271319806, 0.0153331193,
                            0.0078465728, 0.0036222644, 0.0015031097, 0.0005580407, 0.0001850135
                        ],
                        [
                            0.0022121748, 0.0129870260, 0.0311634619, 0.0541482777, 0.0786432128,
                            0.1007199569, 0.1164822021, 0.1230117179, 0.1192094175, 0.1061763879,
                            0.0868758632, 0.0651921502, 0.0447545356, 0.0280232138, 0.0159512601,
                            0.0082236497, 0.0038263023, 0.0016001264, 0.0005990473, 0.0002000158
                        ],
                        [
                            0.0025653617, 0.0142190049, 0.0329346438, 0.0558158700, 0.0795232128,
                            0.1003331470, 0.1147461792, 0.1202989622, 0.1162293883, 0.1037036222,
                            0.0854610500, 0.0649841628, 0.0455144175, 0.0292971309, 0.0172874375,
                            0.0093243147, 0.0045836463, 0.0020472887, 0.0008281168, 0.0003030427
                        ],
                        [
                            0.0031360035, 0.0159851152, 0.0352022647, 0.0575904289, 0.0799035691,
                            0.0988156210, 0.1114316581, 0.1158900848, 0.1118007762, 0.1003191021,
                            0.0838078185, 0.0651768566, 0.0471470871, 0.0316821383, 0.0197453185,
                            0.0113936460, 0.0060739437, 0.0029859555, 0.0013514325, 0.0005611796
                        ],
                        [
                            0.0041012892, 0.0187200135, 0.0385729355, 0.0602413135, 0.0807017228,
                            0.0971789375, 0.1075052192, 0.1105016223, 0.1061861613, 0.0957167648,
                            0.0810740214, 0.0645757898, 0.0483707934, 0.0340633188, 0.0225360739,
                            0.0139972258, 0.0081525383, 0.0044485678, 0.0022718220, 0.0010838693
                        ],
                        [
                            0.0054756790, 0.0223183746, 0.0429681044, 0.0639713947, 0.0826069320,
                            0.0966541969, 0.1046128113, 0.1059048592, 0.1009159518, 0.0908560068,
                            0.0774577706, 0.0626132420, 0.0480261214, 0.0349634170, 0.0241602941,
                            0.0158441129, 0.0098576243, 0.0058162187, 0.0032531563, 0.0017237321
                        ],
                        [
                            0.0067183022, 0.0254914731, 0.0470020641, 0.0678182802, 0.0854101120,
                            0.0978798020, 0.1041251678, 0.1039418048, 0.0979800004, 0.0875553596,
                            0.0743522174, 0.0600949881, 0.0462746238, 0.0339672552, 0.0237750746,
                            0.0158704234, 0.0101030039, 0.0061331436, 0.0035490271, 0.0019578766
                        ],
                        [
                            0.0073336894, 0.0270762337, 0.0490933339, 0.0699511121, 0.0871766148,
                            0.0989912795, 0.1044502138, 0.1035063232, 0.0969411732, 0.0861455495,
                            0.0728148481, 0.0586384528, 0.0450362075, 0.0330111213, 0.0231012718,
                            0.0154379222, 0.0098527350, 0.0060050281, 0.0034950005, 0.0019418896
                        ],
                        [
                            0.0070345567, 0.0264421993, 0.0484514859, 0.0695431345, 0.0871395441,
                            0.0993513421, 0.1051276529, 0.1043542724, 0.0977875508, 0.0868400094,
                            0.0732627741, 0.0588089740, 0.0449612558, 0.0327574721, 0.0227516116,
                            0.0150668944, 0.0095129807, 0.0057252195, 0.0032848635, 0.0017962062
                        ],
                        [
                            0.0066654512, 0.0255148345, 0.0472692085, 0.0683955035, 0.0862672071,
                            0.0989039169, 0.1051536540, 0.1048000465, 0.0985292733, 0.0877217059,
                            0.0741353646, 0.0595633298, 0.0455362312, 0.0331449430, 0.0229744701,
                            0.0151660553, 0.0095343801, 0.0057078060, 0.0032525879, 0.0017640306
                        ],
                        [
                            0.0068309869, 0.0261352097, 0.0483737224, 0.0698831692, 0.0879405691,
                            0.1005169558, 0.1064566396, 0.1056003878, 0.0987293423, 0.0873296760,
                            0.0732571019, 0.0583643286, 0.0442026242, 0.0318395494, 0.0218178978,
                            0.0142237952, 0.0088208962, 0.0052026062, 0.0029182665, 0.0015562753
                        ],
                        [
                            0.0085671154, 0.0309959797, 0.0553338752, 0.0776406096, 0.0951382271,
                            0.1059877710, 0.1094344382, 0.1058265995, 0.0964406128, 0.0831404615,
                            0.0679673172, 0.0527741517, 0.0389584518, 0.0273611122, 0.0182884589,
                            0.0116363811, 0.0070484996, 0.0040643244, 0.0022303731, 0.0011652398
                        ],
                        [
                            0.0119334560, 0.0399546154, 0.0677356450, 0.0909862235, 0.1069768745,
                            0.1143638709, 0.1132292570, 0.1048797399, 0.0914354666, 0.0753167464,
                            0.0587657923, 0.0435065370, 0.0305975533, 0.0204580678, 0.0130120395,
                            0.0078762611, 0.0045374548, 0.0024883462, 0.0012997031, 0.0006463497
                        ],
                    ],
                    "dims": ["wind_direction", "wind_speed"],
                },
                "turbulence_intensity": {
                    "data": 0.075,
                    "dims": [],
                }
            }

        }

        self.energy_resource_timeseries_vertical_variation = {
            "name": "Custom Energy Resource Case Study",
            "wind_resource": {
                "time": ['2023-07-25T00:00:00Z', '2023-07-25T01:00:00Z', '2023-07-25T02:00:00Z'],
                "height": [1, 2],
                "wind_speed":{
                    "data": [[5, 7], [2, 6], [3, 3.3]],
                    "dims": [3, 2],  # 3 time points, 2 height levels
                },
                "wind_direction": {
                    "data": [[0, 2], [333, 350], [20, 30]],
                    "dims": [3, 2],  # 3 time points, 2 height levels
                }
            }
        }

        self.energy_resource_uniform_resource = {
            "name": "IEA Wind Task 37 Plant Energy Resource",
            "wind_resource": {
                "probability": {
                    "data": [
                        0.025, 0.024, 0.029, 0.036, 0.063, 0.065, 0.1, 0.122,
                        0.063, 0.038, 0.039, 0.083, 0.213, 0.046, 0.032, 0.022,
                    ],
                    "dims": ["wind_direction"],
                },
                "turbulence_intensity": {
                    "data": 0.075,
                    "dims": [],
                },
                "wind_direction": [
                    0.0, 22.5, 45.0, 67.5, 90.0, 112.5, 135.0, 157.5, 180.0,
                    202.5, 225.0, 247.5, 270.0, 292.5, 315.0, 337.5,
                ],
                "wind_speed": 9.8,
            },
        }

        self.energy_resource_uniform_weibull_resource = {
            "name": "Hornsrev1 Energy Resource",
            "wind_resource": {
                "sector_probability": {
                    "data": [
                        0.03597152, 0.03948682, 0.051673949999999996, 0.07000154, 0.08364547,
                        0.0643485, 0.08643194, 0.1177051, 0.1515757, 0.14737920000000002,
                        0.1001205, 0.051659750000000004,                     ],
                    "dims": ["wind_direction"],
                },
                "turbulence_intensity": {
                    "data": 0.075,
                    "dims": [],
                },
                "weibull_a": {
                    "data": [
                        9.176929, 9.782334, 9.531809, 9.909545, 10.04269, 9.593921,
                        9.584007, 10.51499, 11.39895, 11.68746, 11.63732, 10.08803,
                    ],
                    "dims": ["wind_direction"],
                },
                "weibull_k": {
                    "data": [
                        2.392578, 2.447266, 2.412109, 2.591797, 2.755859, 2.595703,
                        2.583984, 2.548828, 2.470703, 2.607422, 2.626953, 2.326172,
                    ],
                    "dims": ["wind_direction"],
                },
                "wind_direction": [
                    0.0, 30.0, 60.0, 90.0, 120.0, 150.0, 180.0,
                    210.0, 240.0, 270.0, 300.0, 330.0
                ],
            },
        }

        self.energy_resource_wind_turbine_resource = {
            "name": "Parque Ficticio Energy Resource",
            "wind_resource": {
                "height": {
                    "data": [70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0],
                    "dims": ["wind_turbine"],
                },
                "sector_probability": {
                    "data": [
                        [0.05303057792347059, 0.038601308693941176],
                        [0.05209874950529458, 0.03621136735941261],
                        [0.04451039588152945, 0.032749114369529445],
                        [0.047433479849911635, 0.028918446515500056],
                        [0.04679941436875175, 0.027744187511293393],
                        [0.04536396242935305, 0.025623147325858953],
                        [0.041852408104882555, 0.026035826897411855],
                        [0.043364070673176464, 0.027760081859294117],
                    ],
                    "dims": ["wind_turbine", "wind_direction"],
                },
                "turbulence_intensity": {
                    "data": [
                        [
                            [0.16757585688354412, 0.15458017818645292],
                            [0.15245238923414708, 0.14062955088537646]
                        ],
                        [
                            [0.16524312274893924, 0.15242834996432758],
                            [0.1565417582284692, 0.1444017851413634],
                        ],
                        [
                            [0.18588207525567577, 0.17146673064401108],
                            [0.169153358642882, 0.15603534307465847],
                        ],
                        [
                            [0.1719046943025245, 0.15857330984641033],
                            [0.16488918092269178, 0.15210185668787077],
                        ],
                        [
                            [0.17672672869509296, 0.16302139055139184],
                            [0.16593217580000982, 0.1530639662481723],
                        ],
                        [
                            [0.18953070335983804, 0.17483240391560567],
                            [0.17979216337326262, 0.1658490976422749],
                        ],
                        [
                            [0.22110802111897054, 0.2039608684607646],
                            [0.2301842363289039, 0.21233321391972357],
                        ],
                        [
                            [0.21915493850085296, 0.2021592493926235],
                            [0.2326565969465294, 0.21461384044863524],
                        ],
                    ],
                    "dims": ["wind_turbine", "wind_direction", "wind_speed"],
                },
                "weibull_a": {
                    "data": [
                        [5.363296537305882, 5.427790586341176],
                        [5.606556922964743, 5.597923880341234],
                        [5.071473320588261, 5.2070666792117875],
                        [5.40839037274181, 5.234174106740044],
                        [5.036260694498878, 4.907576221491819],
                        [4.869782568762339, 4.711265568112932],
                        [4.234078508129398, 4.103968798810557],
                        [4.25995289357647, 4.079883722482353],
                    ],
                    "dims": ["wind_turbine", "wind_direction"],
                },
                "weibull_k": {
                    "data": [
                        [1.8069726642882353, 2.0348914719470588],
                        [1.8211259119058778, 2.047329429564703],
                        [1.8496090000000005, 2.0415387829411755],
                        [1.849609, 2.0764452410458807],
                        [1.849609, 2.09087601459294],
                        [1.8496089999999998, 2.1031222700635297],
                        [1.8496089999999998, 2.063286031959999],
                        [1.8496089999999996, 2.0550753344470585],
                    ],
                    "dims": ["wind_turbine", "wind_direction"],
                },
                "wind_direction": [0, 30],
                "wind_speed": [8, 10],
                "wind_turbine": [0, 1, 2, 3, 4, 5, 6, 7],
                "x": {
                    "data": [
                        263655.0, 263891.1, 264022.2, 264058.9,
                        264095.6, 264022.2, 264022.2, 263936.5,
                    ],
                    "dims": ["wind_turbine"],
                },
                "y": {
                    "data": [
                        6506601.0, 6506394.0, 6506124.0, 6505891.0,
                        6505585.0, 6505365.0, 6505145.0, 6504802.0,
                    ],
                    "dims": ["wind_turbine"],
                },
            },
        }
