# hedera-api
Repository for Active Research Datasets

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0
- Package version: 1.1.0.post1
- Generator version: 7.12.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import hedera_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import hedera_api_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import hedera_api_client
from hedera_api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080/hedera
# See configuration.py for a list of all supported configuration parameters.
configuration = hedera_api_client.Configuration(
    host = "http://localhost:8080/hedera"
)



# Enter a context with an instance of the API client
with hedera_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = hedera_api_client.AccessApi(api_client)

    try:
        api_response = api_instance.access_home()
        print("The response of AccessApi->access_home:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessApi->access_home: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080/hedera*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessApi* | [**access_home**](docs/AccessApi.md#access_home) | **GET** /access | 
*AccessIiifRefreshApi* | [**access_iiif_refresh_by_id_refresh_iiif**](docs/AccessIiifRefreshApi.md#access_iiif_refresh_by_id_refresh_iiif) | **POST** /access/iiif-refresh/{projectShortName} | 
*AccessIiifRefreshApi* | [**access_iiif_refresh_refresh_iiif_all**](docs/AccessIiifRefreshApi.md#access_iiif_refresh_refresh_iiif_all) | **POST** /access/iiif-refresh | 
*AccessProjectsApi* | [**access_projects_by_id_by_id_research_objects_execute_query_for_detail**](docs/AccessProjectsApi.md#access_projects_by_id_by_id_research_objects_execute_query_for_detail) | **POST** /access/projects/{projectShortName}/{researchObjectTypeName}/research-objects | 
*AccessProjectsApi* | [**access_projects_by_id_by_id_research_objects_execute_query_for_list**](docs/AccessProjectsApi.md#access_projects_by_id_by_id_research_objects_execute_query_for_list) | **GET** /access/projects/{projectShortName}/{researchObjectTypeName}/research-objects | 
*AccessProjectsApi* | [**access_projects_by_id_download_logo**](docs/AccessProjectsApi.md#access_projects_by_id_download_logo) | **GET** /access/projects/{projectShortName}/download-logo | 
*AccessProjectsApi* | [**access_projects_by_id_download_token_get_token_for_project**](docs/AccessProjectsApi.md#access_projects_by_id_download_token_get_token_for_project) | **GET** /access/projects/{projectShortName}/download-token | 
*AccessProjectsApi* | [**access_projects_by_id_get**](docs/AccessProjectsApi.md#access_projects_by_id_get) | **GET** /access/projects/{id} | 
*AccessProjectsApi* | [**access_projects_by_id_research_data_files_by_id_download_token_get_token_for_research_data_file**](docs/AccessProjectsApi.md#access_projects_by_id_research_data_files_by_id_download_token_get_token_for_research_data_file) | **GET** /access/projects/{projectShortName}/research-data-files/{fileName}/download-token | 
*AccessProjectsApi* | [**access_projects_by_id_research_data_files_by_id_get**](docs/AccessProjectsApi.md#access_projects_by_id_research_data_files_by_id_get) | **GET** /access/projects/{projectShortName}/research-data-files/{hederaId} | 
*AccessProjectsApi* | [**access_projects_by_id_research_data_files_download**](docs/AccessProjectsApi.md#access_projects_by_id_research_data_files_download) | **GET** /access/projects/{projectShortName}/research-data-files/** | 
*AccessProjectsApi* | [**access_projects_by_id_research_data_files_list**](docs/AccessProjectsApi.md#access_projects_by_id_research_data_files_list) | **GET** /access/projects/{projectShortName}/research-data-files | 
*AccessProjectsApi* | [**access_projects_by_id_research_objects_by_id_get**](docs/AccessProjectsApi.md#access_projects_by_id_research_objects_by_id_get) | **GET** /access/projects/{projectShortName}/research-objects/{hederaId} | 
*AccessProjectsApi* | [**access_projects_by_id_research_objects_list**](docs/AccessProjectsApi.md#access_projects_by_id_research_objects_list) | **GET** /access/projects/{projectShortName}/research-objects | 
*AccessProjectsApi* | [**access_projects_list**](docs/AccessProjectsApi.md#access_projects_list) | **GET** /access/projects | 
*AccessResearchObjectsApi* | [**access_research_objects_by_id_get**](docs/AccessResearchObjectsApi.md#access_research_objects_by_id_get) | **GET** /access/research-objects/{id} | 
*AccessResearchObjectsApi* | [**access_research_objects_list**](docs/AccessResearchObjectsApi.md#access_research_objects_list) | **GET** /access/research-objects | 
*AccessResearchObjectsApi* | [**access_research_objects_search_get**](docs/AccessResearchObjectsApi.md#access_research_objects_search_get) | **GET** /access/research-objects/search | 
*AccessResearchObjectsApi* | [**access_research_objects_search_post**](docs/AccessResearchObjectsApi.md#access_research_objects_search_post) | **POST** /access/research-objects/search | 
*AdminApi* | [**admin_home**](docs/AdminApi.md#admin_home) | **GET** /admin | 
*AdminApplicationRolesApi* | [**admin_application_roles_by_id_delete**](docs/AdminApplicationRolesApi.md#admin_application_roles_by_id_delete) | **DELETE** /admin/application-roles/{id} | 
*AdminApplicationRolesApi* | [**admin_application_roles_by_id_get**](docs/AdminApplicationRolesApi.md#admin_application_roles_by_id_get) | **GET** /admin/application-roles/{id} | 
*AdminApplicationRolesApi* | [**admin_application_roles_by_id_update**](docs/AdminApplicationRolesApi.md#admin_application_roles_by_id_update) | **PATCH** /admin/application-roles/{id} | 
*AdminApplicationRolesApi* | [**admin_application_roles_create**](docs/AdminApplicationRolesApi.md#admin_application_roles_create) | **POST** /admin/application-roles | 
*AdminApplicationRolesApi* | [**admin_application_roles_delete_list**](docs/AdminApplicationRolesApi.md#admin_application_roles_delete_list) | **DELETE** /admin/application-roles | 
*AdminApplicationRolesApi* | [**admin_application_roles_list**](docs/AdminApplicationRolesApi.md#admin_application_roles_list) | **GET** /admin/application-roles | 
*AdminApplicationRolesApi* | [**admin_application_roles_search_advanced_search_get**](docs/AdminApplicationRolesApi.md#admin_application_roles_search_advanced_search_get) | **GET** /admin/application-roles/search | 
*AdminApplicationRolesApi* | [**admin_application_roles_search_advanced_search_post**](docs/AdminApplicationRolesApi.md#admin_application_roles_search_advanced_search_post) | **POST** /admin/application-roles/search | 
*AdminAuthorizedProjectsApi* | [**admin_authorized_projects_by_id_get_authorized_project**](docs/AdminAuthorizedProjectsApi.md#admin_authorized_projects_by_id_get_authorized_project) | **GET** /admin/authorized-projects/{id} | 
*AdminAuthorizedProjectsApi* | [**admin_authorized_projects_list_all**](docs/AdminAuthorizedProjectsApi.md#admin_authorized_projects_list_all) | **GET** /admin/authorized-projects | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_delete**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_delete) | **DELETE** /admin/funding-agencies/{id} | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_delete_logo**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_delete_logo) | **DELETE** /admin/funding-agencies/{id}/delete-logo | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_download_logo**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_download_logo) | **GET** /admin/funding-agencies/{id}/download-logo | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_get**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_get) | **GET** /admin/funding-agencies/{id} | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_projects_by_id_delete**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_projects_by_id_delete) | **DELETE** /admin/funding-agencies/{parentid}/projects/{id} | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_projects_by_id_get**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_projects_by_id_get) | **GET** /admin/funding-agencies/{parentid}/projects/{id} | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_projects_by_id_update**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_projects_by_id_update) | **PATCH** /admin/funding-agencies/{parentid}/projects/{id} | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_projects_create**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_projects_create) | **POST** /admin/funding-agencies/{parentid}/projects | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_projects_delete_list**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_projects_delete_list) | **DELETE** /admin/funding-agencies/{parentid}/projects | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_projects_list**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_projects_list) | **GET** /admin/funding-agencies/{parentid}/projects | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_update**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_update) | **PATCH** /admin/funding-agencies/{id} | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_by_id_upload_logo**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_by_id_upload_logo) | **POST** /admin/funding-agencies/{id}/upload-logo | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_create**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_create) | **POST** /admin/funding-agencies | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_delete_list**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_delete_list) | **DELETE** /admin/funding-agencies | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_list**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_list) | **GET** /admin/funding-agencies | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_search_advanced_search_get**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_search_advanced_search_get) | **GET** /admin/funding-agencies/search | 
*AdminFundingAgenciesApi* | [**admin_funding_agencies_search_advanced_search_post**](docs/AdminFundingAgenciesApi.md#admin_funding_agencies_search_advanced_search_post) | **POST** /admin/funding-agencies/search | 
*AdminGlobalBannersApi* | [**admin_global_banners_by_id_delete**](docs/AdminGlobalBannersApi.md#admin_global_banners_by_id_delete) | **DELETE** /admin/global-banners/{id} | 
*AdminGlobalBannersApi* | [**admin_global_banners_by_id_get**](docs/AdminGlobalBannersApi.md#admin_global_banners_by_id_get) | **GET** /admin/global-banners/{id} | 
*AdminGlobalBannersApi* | [**admin_global_banners_by_id_update**](docs/AdminGlobalBannersApi.md#admin_global_banners_by_id_update) | **PATCH** /admin/global-banners/{id} | 
*AdminGlobalBannersApi* | [**admin_global_banners_create**](docs/AdminGlobalBannersApi.md#admin_global_banners_create) | **POST** /admin/global-banners | 
*AdminGlobalBannersApi* | [**admin_global_banners_delete_list**](docs/AdminGlobalBannersApi.md#admin_global_banners_delete_list) | **DELETE** /admin/global-banners | 
*AdminGlobalBannersApi* | [**admin_global_banners_get_active**](docs/AdminGlobalBannersApi.md#admin_global_banners_get_active) | **GET** /admin/global-banners/get-active | 
*AdminGlobalBannersApi* | [**admin_global_banners_list**](docs/AdminGlobalBannersApi.md#admin_global_banners_list) | **GET** /admin/global-banners | 
*AdminGlobalBannersApi* | [**admin_global_banners_search_advanced_search_get**](docs/AdminGlobalBannersApi.md#admin_global_banners_search_advanced_search_get) | **GET** /admin/global-banners/search | 
*AdminGlobalBannersApi* | [**admin_global_banners_search_advanced_search_post**](docs/AdminGlobalBannersApi.md#admin_global_banners_search_advanced_search_post) | **POST** /admin/global-banners/search | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_by_id_delete**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_by_id_delete) | **DELETE** /admin/iiif-collection-configs/{id} | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_by_id_get**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_by_id_get) | **GET** /admin/iiif-collection-configs/{id} | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_by_id_update**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_by_id_update) | **PATCH** /admin/iiif-collection-configs/{id} | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_create**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_create) | **POST** /admin/iiif-collection-configs | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_delete_list**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_delete_list) | **DELETE** /admin/iiif-collection-configs | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_list**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_list) | **GET** /admin/iiif-collection-configs | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_search_advanced_search_get**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_search_advanced_search_get) | **GET** /admin/iiif-collection-configs/search | 
*AdminIiifCollectionConfigsApi* | [**admin_iiif_collection_configs_search_advanced_search_post**](docs/AdminIiifCollectionConfigsApi.md#admin_iiif_collection_configs_search_advanced_search_post) | **POST** /admin/iiif-collection-configs/search | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_delete**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_delete) | **DELETE** /admin/institutions/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_delete_logo**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_delete_logo) | **DELETE** /admin/institutions/{id}/delete-logo | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_download_logo**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_download_logo) | **GET** /admin/institutions/{id}/download-logo | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_get**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_get) | **GET** /admin/institutions/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_people_by_id_delete**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_people_by_id_delete) | **DELETE** /admin/institutions/{parentid}/people/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_people_by_id_get**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_people_by_id_get) | **GET** /admin/institutions/{parentid}/people/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_people_by_id_update**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_people_by_id_update) | **PATCH** /admin/institutions/{parentid}/people/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_people_create**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_people_create) | **POST** /admin/institutions/{parentid}/people | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_people_delete_list**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_people_delete_list) | **DELETE** /admin/institutions/{parentid}/people | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_people_list**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_people_list) | **GET** /admin/institutions/{parentid}/people | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_projects_by_id_delete**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_projects_by_id_delete) | **DELETE** /admin/institutions/{parentid}/projects/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_projects_by_id_get**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_projects_by_id_get) | **GET** /admin/institutions/{parentid}/projects/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_projects_by_id_update**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_projects_by_id_update) | **PATCH** /admin/institutions/{parentid}/projects/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_projects_create**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_projects_create) | **POST** /admin/institutions/{parentid}/projects | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_projects_delete_list**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_projects_delete_list) | **DELETE** /admin/institutions/{parentid}/projects | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_projects_list**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_projects_list) | **GET** /admin/institutions/{parentid}/projects | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_update**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_update) | **PATCH** /admin/institutions/{id} | 
*AdminInstitutionsApi* | [**admin_institutions_by_id_upload_logo**](docs/AdminInstitutionsApi.md#admin_institutions_by_id_upload_logo) | **POST** /admin/institutions/{id}/upload-logo | 
*AdminInstitutionsApi* | [**admin_institutions_create**](docs/AdminInstitutionsApi.md#admin_institutions_create) | **POST** /admin/institutions | 
*AdminInstitutionsApi* | [**admin_institutions_delete_list**](docs/AdminInstitutionsApi.md#admin_institutions_delete_list) | **DELETE** /admin/institutions | 
*AdminInstitutionsApi* | [**admin_institutions_list**](docs/AdminInstitutionsApi.md#admin_institutions_list) | **GET** /admin/institutions | 
*AdminInstitutionsApi* | [**admin_institutions_search_advanced_search_get**](docs/AdminInstitutionsApi.md#admin_institutions_search_advanced_search_get) | **GET** /admin/institutions/search | 
*AdminInstitutionsApi* | [**admin_institutions_search_advanced_search_post**](docs/AdminInstitutionsApi.md#admin_institutions_search_advanced_search_post) | **POST** /admin/institutions/search | 
*AdminLanguagesApi* | [**admin_languages_by_id_delete**](docs/AdminLanguagesApi.md#admin_languages_by_id_delete) | **DELETE** /admin/languages/{id} | 
*AdminLanguagesApi* | [**admin_languages_by_id_get**](docs/AdminLanguagesApi.md#admin_languages_by_id_get) | **GET** /admin/languages/{id} | 
*AdminLanguagesApi* | [**admin_languages_by_id_update**](docs/AdminLanguagesApi.md#admin_languages_by_id_update) | **PATCH** /admin/languages/{id} | 
*AdminLanguagesApi* | [**admin_languages_create**](docs/AdminLanguagesApi.md#admin_languages_create) | **POST** /admin/languages | 
*AdminLanguagesApi* | [**admin_languages_delete_list**](docs/AdminLanguagesApi.md#admin_languages_delete_list) | **DELETE** /admin/languages | 
*AdminLanguagesApi* | [**admin_languages_list**](docs/AdminLanguagesApi.md#admin_languages_list) | **GET** /admin/languages | 
*AdminLanguagesApi* | [**admin_languages_search_advanced_search_get**](docs/AdminLanguagesApi.md#admin_languages_search_advanced_search_get) | **GET** /admin/languages/search | 
*AdminLanguagesApi* | [**admin_languages_search_advanced_search_post**](docs/AdminLanguagesApi.md#admin_languages_search_advanced_search_post) | **POST** /admin/languages/search | 
*AdminLicensesApi* | [**admin_licenses_by_id_delete**](docs/AdminLicensesApi.md#admin_licenses_by_id_delete) | **DELETE** /admin/licenses/{id} | 
*AdminLicensesApi* | [**admin_licenses_by_id_delete_logo**](docs/AdminLicensesApi.md#admin_licenses_by_id_delete_logo) | **DELETE** /admin/licenses/{id}/delete-logo | 
*AdminLicensesApi* | [**admin_licenses_by_id_download_logo**](docs/AdminLicensesApi.md#admin_licenses_by_id_download_logo) | **GET** /admin/licenses/{id}/download-logo | 
*AdminLicensesApi* | [**admin_licenses_by_id_get**](docs/AdminLicensesApi.md#admin_licenses_by_id_get) | **GET** /admin/licenses/{id} | 
*AdminLicensesApi* | [**admin_licenses_by_id_update**](docs/AdminLicensesApi.md#admin_licenses_by_id_update) | **PATCH** /admin/licenses/{id} | 
*AdminLicensesApi* | [**admin_licenses_by_id_upload_logo**](docs/AdminLicensesApi.md#admin_licenses_by_id_upload_logo) | **POST** /admin/licenses/{id}/upload-logo | 
*AdminLicensesApi* | [**admin_licenses_create**](docs/AdminLicensesApi.md#admin_licenses_create) | **POST** /admin/licenses | 
*AdminLicensesApi* | [**admin_licenses_delete_list**](docs/AdminLicensesApi.md#admin_licenses_delete_list) | **DELETE** /admin/licenses | 
*AdminLicensesApi* | [**admin_licenses_import_file_import_json**](docs/AdminLicensesApi.md#admin_licenses_import_file_import_json) | **POST** /admin/licenses/import/file | 
*AdminLicensesApi* | [**admin_licenses_import_list_create_list**](docs/AdminLicensesApi.md#admin_licenses_import_list_create_list) | **POST** /admin/licenses/import/list | 
*AdminLicensesApi* | [**admin_licenses_list**](docs/AdminLicensesApi.md#admin_licenses_list) | **GET** /admin/licenses | 
*AdminLicensesApi* | [**admin_licenses_search_advanced_search_get**](docs/AdminLicensesApi.md#admin_licenses_search_advanced_search_get) | **GET** /admin/licenses/search | 
*AdminLicensesApi* | [**admin_licenses_search_advanced_search_post**](docs/AdminLicensesApi.md#admin_licenses_search_advanced_search_post) | **POST** /admin/licenses/search | 
*AdminModulesApi* | [**admin_modules**](docs/AdminModulesApi.md#admin_modules) | **GET** /admin/modules | 
*AdminMonitorApi* | [**admin_monitor_status**](docs/AdminMonitorApi.md#admin_monitor_status) | **GET** /admin/monitor | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_delete**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_delete) | **DELETE** /admin/ontologies/{id} | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_delete_ontology**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_delete_ontology) | **DELETE** /admin/ontologies/{id}/delete-ontology | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_download_ontology**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_download_ontology) | **GET** /admin/ontologies/{id}/download-ontology | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_get**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_get) | **GET** /admin/ontologies/{id} | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_is_part_of_by_id_is_part_of**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_is_part_of_by_id_is_part_of) | **POST** /admin/ontologies/{id}/is-part-of/{rdfType} | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_rdf_classes_list_rdf_classes**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_rdf_classes_list_rdf_classes) | **GET** /admin/ontologies/{id}/rdf-classes | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_rdf_properties_list_rdf_properties**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_rdf_properties_list_rdf_properties) | **GET** /admin/ontologies/{id}/rdf-properties | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_update**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_update) | **PATCH** /admin/ontologies/{id} | 
*AdminOntologiesApi* | [**admin_ontologies_by_id_upload_file**](docs/AdminOntologiesApi.md#admin_ontologies_by_id_upload_file) | **POST** /admin/ontologies/{id}/upload-file | 
*AdminOntologiesApi* | [**admin_ontologies_create**](docs/AdminOntologiesApi.md#admin_ontologies_create) | **POST** /admin/ontologies | 
*AdminOntologiesApi* | [**admin_ontologies_delete_list**](docs/AdminOntologiesApi.md#admin_ontologies_delete_list) | **DELETE** /admin/ontologies | 
*AdminOntologiesApi* | [**admin_ontologies_list**](docs/AdminOntologiesApi.md#admin_ontologies_list) | **GET** /admin/ontologies | 
*AdminOntologiesApi* | [**admin_ontologies_list_ontology_formats**](docs/AdminOntologiesApi.md#admin_ontologies_list_ontology_formats) | **GET** /admin/ontologies/list-ontology-formats | 
*AdminOntologiesApi* | [**admin_ontologies_search_advanced_search_get**](docs/AdminOntologiesApi.md#admin_ontologies_search_advanced_search_get) | **GET** /admin/ontologies/search | 
*AdminOntologiesApi* | [**admin_ontologies_search_advanced_search_post**](docs/AdminOntologiesApi.md#admin_ontologies_search_advanced_search_post) | **POST** /admin/ontologies/search | 
*AdminOntologiesApi* | [**admin_ontologies_upload_ontology_create_item_and_upload_file**](docs/AdminOntologiesApi.md#admin_ontologies_upload_ontology_create_item_and_upload_file) | **POST** /admin/ontologies/upload-ontology | 
*AdminPeopleApi* | [**admin_people_by_id_delete**](docs/AdminPeopleApi.md#admin_people_by_id_delete) | **DELETE** /admin/people/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_delete_avatar**](docs/AdminPeopleApi.md#admin_people_by_id_delete_avatar) | **DELETE** /admin/people/{id}/delete-avatar | 
*AdminPeopleApi* | [**admin_people_by_id_download_avatar**](docs/AdminPeopleApi.md#admin_people_by_id_download_avatar) | **GET** /admin/people/{id}/download-avatar | 
*AdminPeopleApi* | [**admin_people_by_id_get**](docs/AdminPeopleApi.md#admin_people_by_id_get) | **GET** /admin/people/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_institutions_by_id_delete**](docs/AdminPeopleApi.md#admin_people_by_id_institutions_by_id_delete) | **DELETE** /admin/people/{parentid}/institutions/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_institutions_by_id_get**](docs/AdminPeopleApi.md#admin_people_by_id_institutions_by_id_get) | **GET** /admin/people/{parentid}/institutions/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_institutions_by_id_update**](docs/AdminPeopleApi.md#admin_people_by_id_institutions_by_id_update) | **PATCH** /admin/people/{parentid}/institutions/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_institutions_create**](docs/AdminPeopleApi.md#admin_people_by_id_institutions_create) | **POST** /admin/people/{parentid}/institutions | 
*AdminPeopleApi* | [**admin_people_by_id_institutions_delete_list**](docs/AdminPeopleApi.md#admin_people_by_id_institutions_delete_list) | **DELETE** /admin/people/{parentid}/institutions | 
*AdminPeopleApi* | [**admin_people_by_id_institutions_list**](docs/AdminPeopleApi.md#admin_people_by_id_institutions_list) | **GET** /admin/people/{parentid}/institutions | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_by_id_create**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_by_id_create) | **POST** /admin/people/{parentid}/projects/{id}/{grandChildId} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_by_id_get**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_by_id_get) | **GET** /admin/people/{parentid}/projects/{id}/{grandChildId} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_by_id_update**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_by_id_update) | **PATCH** /admin/people/{parentid}/projects/{id}/{grandChildId} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_create**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_create) | **POST** /admin/people/{parentid}/projects/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_delete**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_delete) | **DELETE** /admin/people/{parentid}/projects/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_get**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_get) | **GET** /admin/people/{parentid}/projects/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_by_id_update**](docs/AdminPeopleApi.md#admin_people_by_id_projects_by_id_update) | **PATCH** /admin/people/{parentid}/projects/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_projects_create**](docs/AdminPeopleApi.md#admin_people_by_id_projects_create) | **POST** /admin/people/{parentid}/projects | 
*AdminPeopleApi* | [**admin_people_by_id_projects_delete**](docs/AdminPeopleApi.md#admin_people_by_id_projects_delete) | **DELETE** /admin/people/{parentid}/projects | 
*AdminPeopleApi* | [**admin_people_by_id_projects_list**](docs/AdminPeopleApi.md#admin_people_by_id_projects_list) | **GET** /admin/people/{parentid}/projects | 
*AdminPeopleApi* | [**admin_people_by_id_update**](docs/AdminPeopleApi.md#admin_people_by_id_update) | **PATCH** /admin/people/{id} | 
*AdminPeopleApi* | [**admin_people_by_id_upload_avatar**](docs/AdminPeopleApi.md#admin_people_by_id_upload_avatar) | **POST** /admin/people/{id}/upload-avatar | 
*AdminPeopleApi* | [**admin_people_create**](docs/AdminPeopleApi.md#admin_people_create) | **POST** /admin/people | 
*AdminPeopleApi* | [**admin_people_delete_list**](docs/AdminPeopleApi.md#admin_people_delete_list) | **DELETE** /admin/people | 
*AdminPeopleApi* | [**admin_people_list**](docs/AdminPeopleApi.md#admin_people_list) | **GET** /admin/people | 
*AdminPeopleApi* | [**admin_people_search_advanced_search_get**](docs/AdminPeopleApi.md#admin_people_search_advanced_search_get) | **GET** /admin/people/search | 
*AdminPeopleApi* | [**admin_people_search_advanced_search_post**](docs/AdminPeopleApi.md#admin_people_search_advanced_search_post) | **POST** /admin/people/search | 
*AdminPeopleApi* | [**admin_people_search_with_user**](docs/AdminPeopleApi.md#admin_people_search_with_user) | **GET** /admin/people/search-with-user | 
*AdminProjectsApi* | [**admin_projects_by_id_close**](docs/AdminProjectsApi.md#admin_projects_by_id_close) | **POST** /admin/projects/{id}/close | 
*AdminProjectsApi* | [**admin_projects_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_delete) | **DELETE** /admin/projects/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_delete_logo**](docs/AdminProjectsApi.md#admin_projects_by_id_delete_logo) | **DELETE** /admin/projects/{id}/delete-logo | 
*AdminProjectsApi* | [**admin_projects_by_id_download_logo**](docs/AdminProjectsApi.md#admin_projects_by_id_download_logo) | **GET** /admin/projects/{id}/download-logo | 
*AdminProjectsApi* | [**admin_projects_by_id_funding_agencies_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_funding_agencies_by_id_delete) | **DELETE** /admin/projects/{parentid}/funding-agencies/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_funding_agencies_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_funding_agencies_by_id_get) | **GET** /admin/projects/{parentid}/funding-agencies/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_funding_agencies_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_funding_agencies_by_id_update) | **PATCH** /admin/projects/{parentid}/funding-agencies/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_funding_agencies_create**](docs/AdminProjectsApi.md#admin_projects_by_id_funding_agencies_create) | **POST** /admin/projects/{parentid}/funding-agencies | 
*AdminProjectsApi* | [**admin_projects_by_id_funding_agencies_delete_list**](docs/AdminProjectsApi.md#admin_projects_by_id_funding_agencies_delete_list) | **DELETE** /admin/projects/{parentid}/funding-agencies | 
*AdminProjectsApi* | [**admin_projects_by_id_funding_agencies_list**](docs/AdminProjectsApi.md#admin_projects_by_id_funding_agencies_list) | **GET** /admin/projects/{parentid}/funding-agencies | 
*AdminProjectsApi* | [**admin_projects_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_get) | **GET** /admin/projects/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_institutions_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_institutions_by_id_delete) | **DELETE** /admin/projects/{parentid}/institutions/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_institutions_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_institutions_by_id_get) | **GET** /admin/projects/{parentid}/institutions/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_institutions_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_institutions_by_id_update) | **PATCH** /admin/projects/{parentid}/institutions/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_institutions_create**](docs/AdminProjectsApi.md#admin_projects_by_id_institutions_create) | **POST** /admin/projects/{parentid}/institutions | 
*AdminProjectsApi* | [**admin_projects_by_id_institutions_delete_list**](docs/AdminProjectsApi.md#admin_projects_by_id_institutions_delete_list) | **DELETE** /admin/projects/{parentid}/institutions | 
*AdminProjectsApi* | [**admin_projects_by_id_institutions_list**](docs/AdminProjectsApi.md#admin_projects_by_id_institutions_list) | **GET** /admin/projects/{parentid}/institutions | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_by_id_create**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_by_id_create) | **POST** /admin/projects/{parentid}/people/{id}/{grandChildId} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_by_id_get) | **GET** /admin/projects/{parentid}/people/{id}/{grandChildId} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_by_id_update) | **PATCH** /admin/projects/{parentid}/people/{id}/{grandChildId} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_create**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_create) | **POST** /admin/projects/{parentid}/people/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_delete) | **DELETE** /admin/projects/{parentid}/people/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_get) | **GET** /admin/projects/{parentid}/people/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_set_role**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_set_role) | **POST** /admin/projects/{parentid}/people/{id}/set-role | 
*AdminProjectsApi* | [**admin_projects_by_id_people_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_people_by_id_update) | **PATCH** /admin/projects/{parentid}/people/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_people_create**](docs/AdminProjectsApi.md#admin_projects_by_id_people_create) | **POST** /admin/projects/{parentid}/people | 
*AdminProjectsApi* | [**admin_projects_by_id_people_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_people_delete) | **DELETE** /admin/projects/{parentid}/people | 
*AdminProjectsApi* | [**admin_projects_by_id_people_list**](docs/AdminProjectsApi.md#admin_projects_by_id_people_list) | **GET** /admin/projects/{parentid}/people | 
*AdminProjectsApi* | [**admin_projects_by_id_research_object_types_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_research_object_types_by_id_delete) | **DELETE** /admin/projects/{parentid}/research-object-types/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_research_object_types_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_research_object_types_by_id_get) | **GET** /admin/projects/{parentid}/research-object-types/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_research_object_types_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_research_object_types_by_id_update) | **PATCH** /admin/projects/{parentid}/research-object-types/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_research_object_types_create**](docs/AdminProjectsApi.md#admin_projects_by_id_research_object_types_create) | **POST** /admin/projects/{parentid}/research-object-types | 
*AdminProjectsApi* | [**admin_projects_by_id_research_object_types_delete_list**](docs/AdminProjectsApi.md#admin_projects_by_id_research_object_types_delete_list) | **DELETE** /admin/projects/{parentid}/research-object-types | 
*AdminProjectsApi* | [**admin_projects_by_id_research_object_types_list**](docs/AdminProjectsApi.md#admin_projects_by_id_research_object_types_list) | **GET** /admin/projects/{parentid}/research-object-types | 
*AdminProjectsApi* | [**admin_projects_by_id_rmls_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_rmls_by_id_delete) | **DELETE** /admin/projects/{parentid}/rmls/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_rmls_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_rmls_by_id_get) | **GET** /admin/projects/{parentid}/rmls/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_rmls_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_rmls_by_id_update) | **PATCH** /admin/projects/{parentid}/rmls/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_rmls_create**](docs/AdminProjectsApi.md#admin_projects_by_id_rmls_create) | **POST** /admin/projects/{parentid}/rmls | 
*AdminProjectsApi* | [**admin_projects_by_id_rmls_delete_list**](docs/AdminProjectsApi.md#admin_projects_by_id_rmls_delete_list) | **DELETE** /admin/projects/{parentid}/rmls | 
*AdminProjectsApi* | [**admin_projects_by_id_rmls_list**](docs/AdminProjectsApi.md#admin_projects_by_id_rmls_list) | **GET** /admin/projects/{parentid}/rmls | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_by_id_create**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_by_id_create) | **POST** /admin/projects/{parentid}/roles/{id}/{grandChildId} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_by_id_get) | **GET** /admin/projects/{parentid}/roles/{id}/{grandChildId} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_by_id_update) | **PATCH** /admin/projects/{parentid}/roles/{id}/{grandChildId} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_create**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_create) | **POST** /admin/projects/{parentid}/roles/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_delete) | **DELETE** /admin/projects/{parentid}/roles/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_get**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_get) | **GET** /admin/projects/{parentid}/roles/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_by_id_update) | **PATCH** /admin/projects/{parentid}/roles/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_create**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_create) | **POST** /admin/projects/{parentid}/roles | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_delete**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_delete) | **DELETE** /admin/projects/{parentid}/roles | 
*AdminProjectsApi* | [**admin_projects_by_id_roles_list**](docs/AdminProjectsApi.md#admin_projects_by_id_roles_list) | **GET** /admin/projects/{parentid}/roles | 
*AdminProjectsApi* | [**admin_projects_by_id_update**](docs/AdminProjectsApi.md#admin_projects_by_id_update) | **PATCH** /admin/projects/{id} | 
*AdminProjectsApi* | [**admin_projects_by_id_upload_logo**](docs/AdminProjectsApi.md#admin_projects_by_id_upload_logo) | **POST** /admin/projects/{id}/upload-logo | 
*AdminProjectsApi* | [**admin_projects_create**](docs/AdminProjectsApi.md#admin_projects_create) | **POST** /admin/projects | 
*AdminProjectsApi* | [**admin_projects_delete_list**](docs/AdminProjectsApi.md#admin_projects_delete_list) | **DELETE** /admin/projects | 
*AdminProjectsApi* | [**admin_projects_list**](docs/AdminProjectsApi.md#admin_projects_list) | **GET** /admin/projects | 
*AdminProjectsApi* | [**admin_projects_search_advanced_search_get**](docs/AdminProjectsApi.md#admin_projects_search_advanced_search_get) | **GET** /admin/projects/search | 
*AdminProjectsApi* | [**admin_projects_search_advanced_search_post**](docs/AdminProjectsApi.md#admin_projects_search_advanced_search_post) | **POST** /admin/projects/search | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_delete**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_delete) | **DELETE** /admin/research-object-types/{id} | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_get**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_get) | **GET** /admin/research-object-types/{id} | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_projects_by_id_delete**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_projects_by_id_delete) | **DELETE** /admin/research-object-types/{parentid}/projects/{id} | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_projects_by_id_get**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_projects_by_id_get) | **GET** /admin/research-object-types/{parentid}/projects/{id} | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_projects_by_id_update**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_projects_by_id_update) | **PATCH** /admin/research-object-types/{parentid}/projects/{id} | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_projects_create**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_projects_create) | **POST** /admin/research-object-types/{parentid}/projects | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_projects_delete_list**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_projects_delete_list) | **DELETE** /admin/research-object-types/{parentid}/projects | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_projects_list**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_projects_list) | **GET** /admin/research-object-types/{parentid}/projects | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_by_id_update**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_by_id_update) | **PATCH** /admin/research-object-types/{id} | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_create**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_create) | **POST** /admin/research-object-types | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_delete_list**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_delete_list) | **DELETE** /admin/research-object-types | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_list**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_list) | **GET** /admin/research-object-types | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_search_advanced_search_get**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_search_advanced_search_get) | **GET** /admin/research-object-types/search | 
*AdminResearchObjectTypesApi* | [**admin_research_object_types_search_advanced_search_post**](docs/AdminResearchObjectTypesApi.md#admin_research_object_types_search_advanced_search_post) | **POST** /admin/research-object-types/search | 
*AdminRmlsApi* | [**admin_rmls_by_id_delete**](docs/AdminRmlsApi.md#admin_rmls_by_id_delete) | **DELETE** /admin/rmls/{id} | 
*AdminRmlsApi* | [**admin_rmls_by_id_delete_rdf_delete_file**](docs/AdminRmlsApi.md#admin_rmls_by_id_delete_rdf_delete_file) | **DELETE** /admin/rmls/{id}/delete-rdf | 
*AdminRmlsApi* | [**admin_rmls_by_id_download_rdf_download_file**](docs/AdminRmlsApi.md#admin_rmls_by_id_download_rdf_download_file) | **GET** /admin/rmls/{id}/download-rdf | 
*AdminRmlsApi* | [**admin_rmls_by_id_get**](docs/AdminRmlsApi.md#admin_rmls_by_id_get) | **GET** /admin/rmls/{id} | 
*AdminRmlsApi* | [**admin_rmls_by_id_projects_by_id_delete**](docs/AdminRmlsApi.md#admin_rmls_by_id_projects_by_id_delete) | **DELETE** /admin/rmls/{parentid}/projects/{id} | 
*AdminRmlsApi* | [**admin_rmls_by_id_projects_by_id_get**](docs/AdminRmlsApi.md#admin_rmls_by_id_projects_by_id_get) | **GET** /admin/rmls/{parentid}/projects/{id} | 
*AdminRmlsApi* | [**admin_rmls_by_id_projects_by_id_update**](docs/AdminRmlsApi.md#admin_rmls_by_id_projects_by_id_update) | **PATCH** /admin/rmls/{parentid}/projects/{id} | 
*AdminRmlsApi* | [**admin_rmls_by_id_projects_create**](docs/AdminRmlsApi.md#admin_rmls_by_id_projects_create) | **POST** /admin/rmls/{parentid}/projects | 
*AdminRmlsApi* | [**admin_rmls_by_id_projects_delete_list**](docs/AdminRmlsApi.md#admin_rmls_by_id_projects_delete_list) | **DELETE** /admin/rmls/{parentid}/projects | 
*AdminRmlsApi* | [**admin_rmls_by_id_projects_list**](docs/AdminRmlsApi.md#admin_rmls_by_id_projects_list) | **GET** /admin/rmls/{parentid}/projects | 
*AdminRmlsApi* | [**admin_rmls_by_id_update**](docs/AdminRmlsApi.md#admin_rmls_by_id_update) | **PATCH** /admin/rmls/{id} | 
*AdminRmlsApi* | [**admin_rmls_by_id_upload_file**](docs/AdminRmlsApi.md#admin_rmls_by_id_upload_file) | **POST** /admin/rmls/{id}/upload-file | 
*AdminRmlsApi* | [**admin_rmls_create**](docs/AdminRmlsApi.md#admin_rmls_create) | **POST** /admin/rmls | 
*AdminRmlsApi* | [**admin_rmls_delete_list**](docs/AdminRmlsApi.md#admin_rmls_delete_list) | **DELETE** /admin/rmls | 
*AdminRmlsApi* | [**admin_rmls_list**](docs/AdminRmlsApi.md#admin_rmls_list) | **GET** /admin/rmls | 
*AdminRmlsApi* | [**admin_rmls_search_advanced_search_get**](docs/AdminRmlsApi.md#admin_rmls_search_advanced_search_get) | **GET** /admin/rmls/search | 
*AdminRmlsApi* | [**admin_rmls_search_advanced_search_post**](docs/AdminRmlsApi.md#admin_rmls_search_advanced_search_post) | **POST** /admin/rmls/search | 
*AdminRmlsApi* | [**admin_rmls_upload_rdf_create_item_and_upload_file**](docs/AdminRmlsApi.md#admin_rmls_upload_rdf_create_item_and_upload_file) | **POST** /admin/rmls/upload-rdf | 
*AdminRolesApi* | [**admin_roles_by_id_delete**](docs/AdminRolesApi.md#admin_roles_by_id_delete) | **DELETE** /admin/roles/{id} | 
*AdminRolesApi* | [**admin_roles_by_id_get**](docs/AdminRolesApi.md#admin_roles_by_id_get) | **GET** /admin/roles/{id} | 
*AdminRolesApi* | [**admin_roles_by_id_update**](docs/AdminRolesApi.md#admin_roles_by_id_update) | **PATCH** /admin/roles/{id} | 
*AdminRolesApi* | [**admin_roles_create**](docs/AdminRolesApi.md#admin_roles_create) | **POST** /admin/roles | 
*AdminRolesApi* | [**admin_roles_delete_list**](docs/AdminRolesApi.md#admin_roles_delete_list) | **DELETE** /admin/roles | 
*AdminRolesApi* | [**admin_roles_list**](docs/AdminRolesApi.md#admin_roles_list) | **GET** /admin/roles | 
*AdminRolesApi* | [**admin_roles_search_advanced_search_get**](docs/AdminRolesApi.md#admin_roles_search_advanced_search_get) | **GET** /admin/roles/search | 
*AdminRolesApi* | [**admin_roles_search_advanced_search_post**](docs/AdminRolesApi.md#admin_roles_search_advanced_search_post) | **POST** /admin/roles/search | 
*AdminSystemPropertiesApi* | [**admin_system_properties**](docs/AdminSystemPropertiesApi.md#admin_system_properties) | **GET** /admin/system-properties | 
*AdminTriplestoreApi* | [**admin_triplestore_queries_by_id_detail_execute_query_for_detail**](docs/AdminTriplestoreApi.md#admin_triplestore_queries_by_id_detail_execute_query_for_detail) | **POST** /admin/triplestore/queries/{datasetId}/detail | 
*AdminTriplestoreApi* | [**admin_triplestore_queries_by_id_execute_query**](docs/AdminTriplestoreApi.md#admin_triplestore_queries_by_id_execute_query) | **POST** /admin/triplestore/queries/{datasetId} | 
*AdminTriplestoreApi* | [**admin_triplestore_queries_by_id_list_execute_query_for_list**](docs/AdminTriplestoreApi.md#admin_triplestore_queries_by_id_list_execute_query_for_list) | **POST** /admin/triplestore/queries/{datasetId}/list | 
*AdminTriplestoreApi* | [**admin_triplestore_settings_by_id_delete**](docs/AdminTriplestoreApi.md#admin_triplestore_settings_by_id_delete) | **DELETE** /admin/triplestore/settings/{id} | 
*AdminTriplestoreApi* | [**admin_triplestore_settings_by_id_get**](docs/AdminTriplestoreApi.md#admin_triplestore_settings_by_id_get) | **GET** /admin/triplestore/settings/{id} | 
*AdminTriplestoreApi* | [**admin_triplestore_settings_by_id_update**](docs/AdminTriplestoreApi.md#admin_triplestore_settings_by_id_update) | **PATCH** /admin/triplestore/settings/{id} | 
*AdminTriplestoreApi* | [**admin_triplestore_settings_create**](docs/AdminTriplestoreApi.md#admin_triplestore_settings_create) | **POST** /admin/triplestore/settings | 
*AdminTriplestoreApi* | [**admin_triplestore_settings_delete_list**](docs/AdminTriplestoreApi.md#admin_triplestore_settings_delete_list) | **DELETE** /admin/triplestore/settings | 
*AdminTriplestoreApi* | [**admin_triplestore_settings_list**](docs/AdminTriplestoreApi.md#admin_triplestore_settings_list) | **GET** /admin/triplestore/settings | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_by_id_delete**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_by_id_delete) | **DELETE** /admin/triplestore-datasets/{id} | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_by_id_get**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_by_id_get) | **GET** /admin/triplestore-datasets/{id} | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_by_id_update**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_by_id_update) | **PATCH** /admin/triplestore-datasets/{id} | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_create**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_create) | **POST** /admin/triplestore-datasets | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_delete_list**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_delete_list) | **DELETE** /admin/triplestore-datasets | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_list**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_list) | **GET** /admin/triplestore-datasets | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_search_advanced_search_get**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_search_advanced_search_get) | **GET** /admin/triplestore-datasets/search | 
*AdminTriplestoreDatasetsApi* | [**admin_triplestore_datasets_search_advanced_search_post**](docs/AdminTriplestoreDatasetsApi.md#admin_triplestore_datasets_search_advanced_search_post) | **POST** /admin/triplestore-datasets/search | 
*AdminUsersApi* | [**admin_users_authenticated_get_authenticated_user**](docs/AdminUsersApi.md#admin_users_authenticated_get_authenticated_user) | **GET** /admin/users/authenticated | 
*AdminUsersApi* | [**admin_users_by_id_delete**](docs/AdminUsersApi.md#admin_users_by_id_delete) | **DELETE** /admin/users/{id} | 
*AdminUsersApi* | [**admin_users_by_id_get**](docs/AdminUsersApi.md#admin_users_by_id_get) | **GET** /admin/users/{id} | 
*AdminUsersApi* | [**admin_users_by_id_update**](docs/AdminUsersApi.md#admin_users_by_id_update) | **PATCH** /admin/users/{id} | 
*AdminUsersApi* | [**admin_users_create**](docs/AdminUsersApi.md#admin_users_create) | **POST** /admin/users | 
*AdminUsersApi* | [**admin_users_delete_list**](docs/AdminUsersApi.md#admin_users_delete_list) | **DELETE** /admin/users | 
*AdminUsersApi* | [**admin_users_list**](docs/AdminUsersApi.md#admin_users_list) | **GET** /admin/users | 
*AdminUsersApi* | [**admin_users_new_user_by_id_create_new_user**](docs/AdminUsersApi.md#admin_users_new_user_by_id_create_new_user) | **POST** /admin/users/new-user/{externalUid} | 
*AdminUsersApi* | [**admin_users_revoke_all_tokens_by_id_revoke_all_tokens**](docs/AdminUsersApi.md#admin_users_revoke_all_tokens_by_id_revoke_all_tokens) | **POST** /admin/users/revoke-all-tokens/{externalUid} | 
*AdminUsersApi* | [**admin_users_revoke_my_tokens**](docs/AdminUsersApi.md#admin_users_revoke_my_tokens) | **POST** /admin/users/revoke-my-tokens | 
*AdminUsersApi* | [**admin_users_search_advanced_search_get**](docs/AdminUsersApi.md#admin_users_search_advanced_search_get) | **GET** /admin/users/search | 
*AdminUsersApi* | [**admin_users_search_advanced_search_post**](docs/AdminUsersApi.md#admin_users_search_advanced_search_post) | **POST** /admin/users/search | 
*AdminUsersApi* | [**admin_users_synchronize**](docs/AdminUsersApi.md#admin_users_synchronize) | **POST** /admin/users/synchronize | 
*HederaApi* | [**root_get**](docs/HederaApi.md#root_get) | **GET** / | 
*IiifCollectionsApi* | [**iiif_collections_by_id_by_id_get**](docs/IiifCollectionsApi.md#iiif_collections_by_id_by_id_get) | **GET** /iiif/collections/{projectShortName}/{id} | 
*IiifCollectionsApi* | [**iiif_collections_by_id_list**](docs/IiifCollectionsApi.md#iiif_collections_by_id_list) | **GET** /iiif/collections/{projectShortName} | 
*IiifManifestsApi* | [**iiif_manifests_by_id_by_id_get**](docs/IiifManifestsApi.md#iiif_manifests_by_id_by_id_get) | **GET** /iiif/manifests/{projectShortName}/{id} | 
*IiifManifestsApi* | [**iiif_manifests_by_id_list**](docs/IiifManifestsApi.md#iiif_manifests_by_id_list) | **GET** /iiif/manifests/{projectShortName} | 
*IiifProtocolVersionApi* | [**iiif_by_id_by_id_download_token_get_token_for_iiif**](docs/IiifProtocolVersionApi.md#iiif_by_id_by_id_download_token_get_token_for_iiif) | **GET** /iiif/{protocolVersion}/{projectShortName}/download-token | 
*IiifProtocolVersionApi* | [**iiif_by_id_by_id_execute_iiif_request**](docs/IiifProtocolVersionApi.md#iiif_by_id_by_id_execute_iiif_request) | **GET** /iiif/{protocolVersion}/{projectShortName}/** | 
*IndexApi* | [**index_home**](docs/IndexApi.md#index_home) | **GET** /index | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_by_id_delete**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_by_id_delete) | **DELETE** /index/index-field-aliases/{id} | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_by_id_get**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_by_id_get) | **GET** /index/index-field-aliases/{id} | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_by_id_update**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_by_id_update) | **PATCH** /index/index-field-aliases/{id} | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_create**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_create) | **POST** /index/index-field-aliases | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_delete_list**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_delete_list) | **DELETE** /index/index-field-aliases | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_list**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_list) | **GET** /index/index-field-aliases | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_list_facet_requests_by_id_facets_list**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_list_facet_requests_by_id_facets_list) | **GET** /index/index-field-aliases/list-facet-requests/{indexName} | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_search_advanced_search_get**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_search_advanced_search_get) | **GET** /index/index-field-aliases/search | 
*IndexIndexFieldAliasesApi* | [**index_index_field_aliases_search_advanced_search_post**](docs/IndexIndexFieldAliasesApi.md#index_index_field_aliases_search_advanced_search_post) | **POST** /index/index-field-aliases/search | 
*IndexIndexesApi* | [**index_indexes_by_id_get**](docs/IndexIndexesApi.md#index_indexes_by_id_get) | **GET** /index/indexes/{id} | 
*IndexIndexesApi* | [**index_indexes_list**](docs/IndexIndexesApi.md#index_indexes_list) | **GET** /index/indexes | 
*IndexSettingsApi* | [**index_settings_by_id_delete**](docs/IndexSettingsApi.md#index_settings_by_id_delete) | **DELETE** /index/settings/{id} | 
*IndexSettingsApi* | [**index_settings_by_id_get**](docs/IndexSettingsApi.md#index_settings_by_id_get) | **GET** /index/settings/{id} | 
*IndexSettingsApi* | [**index_settings_by_id_update**](docs/IndexSettingsApi.md#index_settings_by_id_update) | **PATCH** /index/settings/{id} | 
*IndexSettingsApi* | [**index_settings_create**](docs/IndexSettingsApi.md#index_settings_create) | **POST** /index/settings | 
*IndexSettingsApi* | [**index_settings_delete_all**](docs/IndexSettingsApi.md#index_settings_delete_all) | **DELETE** /index/settings/delete-all | 
*IndexSettingsApi* | [**index_settings_delete_list**](docs/IndexSettingsApi.md#index_settings_delete_list) | **DELETE** /index/settings | 
*IndexSettingsApi* | [**index_settings_list**](docs/IndexSettingsApi.md#index_settings_list) | **GET** /index/settings | 
*IngestApi* | [**ingest_home**](docs/IngestApi.md#ingest_home) | **GET** /ingest | 
*IngestIiifRefreshApi* | [**ingest_iiif_refresh_by_id_refresh_iiif**](docs/IngestIiifRefreshApi.md#ingest_iiif_refresh_by_id_refresh_iiif) | **POST** /ingest/iiif-refresh/{projectId} | 
*IngestPrivateIndexApi* | [**ingest_private_index_by_id_delete**](docs/IngestPrivateIndexApi.md#ingest_private_index_by_id_delete) | **DELETE** /ingest/private-index/{id} | 
*IngestPrivateIndexApi* | [**ingest_private_index_by_id_get**](docs/IngestPrivateIndexApi.md#ingest_private_index_by_id_get) | **GET** /ingest/private-index/{id} | 
*IngestPrivateIndexApi* | [**ingest_private_index_by_id_update**](docs/IngestPrivateIndexApi.md#ingest_private_index_by_id_update) | **PATCH** /ingest/private-index/{id} | 
*IngestPrivateIndexApi* | [**ingest_private_index_create**](docs/IngestPrivateIndexApi.md#ingest_private_index_create) | **POST** /ingest/private-index | 
*IngestPrivateIndexApi* | [**ingest_private_index_delete_by_query**](docs/IngestPrivateIndexApi.md#ingest_private_index_delete_by_query) | **POST** /ingest/private-index/delete-by-query | 
*IngestPrivateIndexApi* | [**ingest_private_index_delete_list**](docs/IngestPrivateIndexApi.md#ingest_private_index_delete_list) | **DELETE** /ingest/private-index | 
*IngestPrivateIndexApi* | [**ingest_private_index_list**](docs/IngestPrivateIndexApi.md#ingest_private_index_list) | **GET** /ingest/private-index | 
*IngestPrivateIndexApi* | [**ingest_private_index_search_get**](docs/IngestPrivateIndexApi.md#ingest_private_index_search_get) | **GET** /ingest/private-index/search | 
*IngestPrivateIndexApi* | [**ingest_private_index_search_post**](docs/IngestPrivateIndexApi.md#ingest_private_index_search_post) | **POST** /ingest/private-index/search | 
*IngestPublicIndexApi* | [**ingest_public_index_by_id_delete**](docs/IngestPublicIndexApi.md#ingest_public_index_by_id_delete) | **DELETE** /ingest/public-index/{id} | 
*IngestPublicIndexApi* | [**ingest_public_index_by_id_get**](docs/IngestPublicIndexApi.md#ingest_public_index_by_id_get) | **GET** /ingest/public-index/{id} | 
*IngestPublicIndexApi* | [**ingest_public_index_by_id_update**](docs/IngestPublicIndexApi.md#ingest_public_index_by_id_update) | **PATCH** /ingest/public-index/{id} | 
*IngestPublicIndexApi* | [**ingest_public_index_create**](docs/IngestPublicIndexApi.md#ingest_public_index_create) | **POST** /ingest/public-index | 
*IngestPublicIndexApi* | [**ingest_public_index_delete_by_query**](docs/IngestPublicIndexApi.md#ingest_public_index_delete_by_query) | **POST** /ingest/public-index/delete-by-query | 
*IngestPublicIndexApi* | [**ingest_public_index_delete_list**](docs/IngestPublicIndexApi.md#ingest_public_index_delete_list) | **DELETE** /ingest/public-index | 
*IngestPublicIndexApi* | [**ingest_public_index_list**](docs/IngestPublicIndexApi.md#ingest_public_index_list) | **GET** /ingest/public-index | 
*IngestPublicIndexApi* | [**ingest_public_index_search_get**](docs/IngestPublicIndexApi.md#ingest_public_index_search_get) | **GET** /ingest/public-index/search | 
*IngestPublicIndexApi* | [**ingest_public_index_search_post**](docs/IngestPublicIndexApi.md#ingest_public_index_search_post) | **POST** /ingest/public-index/search | 
*IngestPurgeIdMappingApi* | [**ingest_purge_id_mapping_by_id_purge**](docs/IngestPurgeIdMappingApi.md#ingest_purge_id_mapping_by_id_purge) | **POST** /ingest/purge-id-mapping/{projectShortName} | 
*IngestPurgeRdfApi* | [**ingest_purge_rdf_by_id_purge_rdf**](docs/IngestPurgeRdfApi.md#ingest_purge_rdf_by_id_purge_rdf) | **POST** /ingest/purge-rdf/{projectId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_add_dataset_by_id_add_dataset_list**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_add_dataset_by_id_add_dataset_list) | **POST** /ingest/rdf-dataset-files/add-dataset/{triplestoreDatasetId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_add_dataset_by_id_add_dataset**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_add_dataset_by_id_add_dataset) | **POST** /ingest/rdf-dataset-files/{id}/add-dataset/{triplestoreDatasetId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_delete**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_delete) | **DELETE** /ingest/rdf-dataset-files/{id} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_delete_dataset_by_id_delete_dataset**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_delete_dataset_by_id_delete_dataset) | **POST** /ingest/rdf-dataset-files/{id}/delete-dataset/{triplestoreDatasetId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_download**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_download) | **GET** /ingest/rdf-dataset-files/{id}/download | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_get**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_get) | **GET** /ingest/rdf-dataset-files/{id} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_history**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_history) | **GET** /ingest/rdf-dataset-files/{id}/history | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_put_in_error**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_put_in_error) | **POST** /ingest/rdf-dataset-files/{id}/put-in-error | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_replace_dataset_by_id_replace_dataset**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_replace_dataset_by_id_replace_dataset) | **POST** /ingest/rdf-dataset-files/{id}/replace-dataset/{triplestoreDatasetId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_by_id_update**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_by_id_update) | **PATCH** /ingest/rdf-dataset-files/{id} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_create**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_create) | **POST** /ingest/rdf-dataset-files | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_delete_dataset_by_id_delete_dataset_list**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_delete_dataset_by_id_delete_dataset_list) | **POST** /ingest/rdf-dataset-files/delete-dataset/{triplestoreDatasetId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_delete_list**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_delete_list) | **DELETE** /ingest/rdf-dataset-files | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_list**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_list) | **GET** /ingest/rdf-dataset-files | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_put_in_error**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_put_in_error) | **POST** /ingest/rdf-dataset-files/put-in-error | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_replace_dataset_by_id_replace_dataset_list**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_replace_dataset_by_id_replace_dataset_list) | **POST** /ingest/rdf-dataset-files/replace-dataset/{triplestoreDatasetId} | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_search_advanced_search_get**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_search_advanced_search_get) | **GET** /ingest/rdf-dataset-files/search | 
*IngestRdfDatasetFilesApi* | [**ingest_rdf_dataset_files_search_advanced_search_post**](docs/IngestRdfDatasetFilesApi.md#ingest_rdf_dataset_files_search_advanced_search_post) | **POST** /ingest/rdf-dataset-files/search | 
*IngestRefreshApi* | [**ingest_refresh**](docs/IngestRefreshApi.md#ingest_refresh) | **POST** /ingest/refresh | 
*IngestRefreshApi* | [**ingest_refresh_by_id_refresh**](docs/IngestRefreshApi.md#ingest_refresh_by_id_refresh) | **POST** /ingest/refresh/{projectId} | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_by_id_delete**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_by_id_delete) | **DELETE** /ingest/research-data-files/{id} | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_by_id_download**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_by_id_download) | **GET** /ingest/research-data-files/{id}/download | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_by_id_get**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_by_id_get) | **GET** /ingest/research-data-files/{id} | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_by_id_history**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_by_id_history) | **GET** /ingest/research-data-files/{id}/history | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_by_id_put_in_error**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_by_id_put_in_error) | **POST** /ingest/research-data-files/{id}/put-in-error | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_by_id_update**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_by_id_update) | **PATCH** /ingest/research-data-files/{id} | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_create**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_create) | **POST** /ingest/research-data-files | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_delete_folder**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_delete_folder) | **POST** /ingest/research-data-files/delete-folder | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_delete_list**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_delete_list) | **DELETE** /ingest/research-data-files | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_download**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_download) | **GET** /ingest/research-data-files/download | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_list**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_list) | **GET** /ingest/research-data-files | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_list_folders**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_list_folders) | **GET** /ingest/research-data-files/list-folders | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_put_in_error**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_put_in_error) | **POST** /ingest/research-data-files/put-in-error | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_reload**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_reload) | **POST** /ingest/research-data-files/reload | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_search_advanced_search_get**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_search_advanced_search_get) | **GET** /ingest/research-data-files/search | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_search_advanced_search_post**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_search_advanced_search_post) | **POST** /ingest/research-data-files/search | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_upload**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_upload) | **POST** /ingest/research-data-files/upload | 
*IngestResearchDataFilesApi* | [**ingest_research_data_files_upload_zip**](docs/IngestResearchDataFilesApi.md#ingest_research_data_files_upload_zip) | **POST** /ingest/research-data-files/upload-zip | 
*IngestSourceDatasetFilesApi* | [**ingest_source_dataset_files_by_id_get**](docs/IngestSourceDatasetFilesApi.md#ingest_source_dataset_files_by_id_get) | **GET** /ingest/source-dataset-files/{id} | 
*IngestSourceDatasetFilesApi* | [**ingest_source_dataset_files_list**](docs/IngestSourceDatasetFilesApi.md#ingest_source_dataset_files_list) | **GET** /ingest/source-dataset-files | 
*IngestSourceDatasetFilesApi* | [**ingest_source_dataset_files_search_advanced_search_get**](docs/IngestSourceDatasetFilesApi.md#ingest_source_dataset_files_search_advanced_search_get) | **GET** /ingest/source-dataset-files/search | 
*IngestSourceDatasetFilesApi* | [**ingest_source_dataset_files_search_advanced_search_post**](docs/IngestSourceDatasetFilesApi.md#ingest_source_dataset_files_search_advanced_search_post) | **POST** /ingest/source-dataset-files/search | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_delete**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_delete) | **DELETE** /ingest/source-datasets/{id} | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_delete_logo**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_delete_logo) | **DELETE** /ingest/source-datasets/{id}/delete-logo | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_download_logo**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_download_logo) | **GET** /ingest/source-datasets/{id}/download-logo | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_get**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_get) | **GET** /ingest/source-datasets/{id} | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_history**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_history) | **GET** /ingest/source-datasets/{id}/history | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_apply_rml**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_apply_rml) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/apply-rml | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_apply_rml**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_apply_rml) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/{id}/apply-rml | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_check**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_check) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/{id}/check | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_delete**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_delete) | **DELETE** /ingest/source-datasets/{parentid}/source-dataset-files/{id} | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_download**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_download) | **GET** /ingest/source-datasets/{parentid}/source-dataset-files/{id}/download | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_get**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_get) | **GET** /ingest/source-datasets/{parentid}/source-dataset-files/{id} | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_history**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_history) | **GET** /ingest/source-datasets/{parentid}/source-dataset-files/{id}/history | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_put_in_error**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_put_in_error) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/{id}/put-in-error | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_transform_rdf**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_transform_rdf) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/{id}/transform-rdf | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_by_id_update**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_by_id_update) | **PATCH** /ingest/source-datasets/{parentid}/source-dataset-files/{id} | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_create**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_create) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_delete_list**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_delete_list) | **DELETE** /ingest/source-datasets/{parentid}/source-dataset-files | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_list**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_list) | **GET** /ingest/source-datasets/{parentid}/source-dataset-files | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_put_in_error**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_put_in_error) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/put-in-error | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_search_get**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_search_get) | **GET** /ingest/source-datasets/{parentid}/source-dataset-files/search | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_source_dataset_files_transform_rdf**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_source_dataset_files_transform_rdf) | **POST** /ingest/source-datasets/{parentid}/source-dataset-files/transform-rdf | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_update**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_update) | **PATCH** /ingest/source-datasets/{id} | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_upload**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_upload) | **POST** /ingest/source-datasets/{id}/upload | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_upload_logo**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_upload_logo) | **POST** /ingest/source-datasets/{id}/upload-logo | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_by_id_upload_zip**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_by_id_upload_zip) | **POST** /ingest/source-datasets/{id}/upload-zip | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_create**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_create) | **POST** /ingest/source-datasets | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_delete_list**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_delete_list) | **DELETE** /ingest/source-datasets | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_list**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_list) | **GET** /ingest/source-datasets | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_search_advanced_search_get**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_search_advanced_search_get) | **GET** /ingest/source-datasets/search | 
*IngestSourceDatasetsApi* | [**ingest_source_datasets_search_advanced_search_post**](docs/IngestSourceDatasetsApi.md#ingest_source_datasets_search_advanced_search_post) | **POST** /ingest/source-datasets/search | 
*LdProjectShortNameApi* | [**ld_by_id_by_id_by_id_get_research_object_rdf_as_turtle**](docs/LdProjectShortNameApi.md#ld_by_id_by_id_by_id_get_research_object_rdf_as_turtle) | **GET** /ld/{projectShortName}/{researchObjectTypeName}/{hederaId} | 
*LdProjectShortNameApi* | [**ld_by_id_by_id_list_research_objects**](docs/LdProjectShortNameApi.md#ld_by_id_by_id_list_research_objects) | **GET** /ld/{projectShortName}/{researchObjectTypeName} | 
*LdProjectShortNameApi* | [**ld_by_id_list_research_object_type**](docs/LdProjectShortNameApi.md#ld_by_id_list_research_object_type) | **GET** /ld/{projectShortName} | 
*OaiInfoApi* | [**oai_info_home**](docs/OaiInfoApi.md#oai_info_home) | **GET** /oai-info | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_by_id_delete**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_by_id_delete) | **DELETE** /oai-info/oai-metadata-prefixes/{id} | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_by_id_get**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_by_id_get) | **GET** /oai-info/oai-metadata-prefixes/{id} | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_by_id_update**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_by_id_update) | **PATCH** /oai-info/oai-metadata-prefixes/{id} | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_create**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_create) | **POST** /oai-info/oai-metadata-prefixes | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_delete_list**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_delete_list) | **DELETE** /oai-info/oai-metadata-prefixes | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_list**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_list) | **GET** /oai-info/oai-metadata-prefixes | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_search_advanced_search_get**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_search_advanced_search_get) | **GET** /oai-info/oai-metadata-prefixes/search | 
*OaiInfoOaiMetadataPrefixesApi* | [**oai_info_oai_metadata_prefixes_search_advanced_search_post**](docs/OaiInfoOaiMetadataPrefixesApi.md#oai_info_oai_metadata_prefixes_search_advanced_search_post) | **POST** /oai-info/oai-metadata-prefixes/search | 
*OaiInfoOaiProviderApi* | [**oai_info_oai_provider_oai_process**](docs/OaiInfoOaiProviderApi.md#oai_info_oai_provider_oai_process) | **GET** /oai-info/oai-provider/oai | 
*OaiInfoOaiProviderApi* | [**oai_info_oai_provider_oai_process_post**](docs/OaiInfoOaiProviderApi.md#oai_info_oai_provider_oai_process_post) | **POST** /oai-info/oai-provider/oai | 
*OaiInfoOaiProviderApi* | [**oai_info_oai_provider_oai_schema_xsd**](docs/OaiInfoOaiProviderApi.md#oai_info_oai_provider_oai_schema_xsd) | **GET** /oai-info/oai-provider/oai/schema | 
*OaiInfoOaiProviderApi* | [**oai_info_oai_provider_oai_xsl**](docs/OaiInfoOaiProviderApi.md#oai_info_oai_provider_oai_xsl) | **GET** /oai-info/oai-provider/oai/xsl | 
*OaiInfoOaiProviderApi* | [**oai_info_oai_provider_status**](docs/OaiInfoOaiProviderApi.md#oai_info_oai_provider_status) | **GET** /oai-info/oai-provider | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_by_id_delete**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_by_id_delete) | **DELETE** /oai-info/oai-sets/{id} | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_by_id_get**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_by_id_get) | **GET** /oai-info/oai-sets/{id} | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_by_id_update**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_by_id_update) | **PATCH** /oai-info/oai-sets/{id} | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_create**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_create) | **POST** /oai-info/oai-sets | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_delete_list**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_delete_list) | **DELETE** /oai-info/oai-sets | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_list**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_list) | **GET** /oai-info/oai-sets | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_search_advanced_search_get**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_search_advanced_search_get) | **GET** /oai-info/oai-sets/search | 
*OaiInfoOaiSetsApi* | [**oai_info_oai_sets_search_advanced_search_post**](docs/OaiInfoOaiSetsApi.md#oai_info_oai_sets_search_advanced_search_post) | **POST** /oai-info/oai-sets/search | 
*OntologiesApi* | [**ontologies_list**](docs/OntologiesApi.md#ontologies_list) | **GET** /ontologies | 
*OntologiesIdApi* | [**ontologies_by_id_get_ontology_content**](docs/OntologiesIdApi.md#ontologies_by_id_get_ontology_content) | **GET** /ontologies/{id} | 
*ResourceSrvApi* | [**resource_srv_home**](docs/ResourceSrvApi.md#resource_srv_home) | **GET** /resource-srv | 
*SchemaApi* | [**call_schema**](docs/SchemaApi.md#call_schema) | **GET** /schema | 
*SitemapNameXmlApi* | [**sitemap_by_id_xml_get_sitemap**](docs/SitemapNameXmlApi.md#sitemap_by_id_xml_get_sitemap) | **GET** /sitemap-{name}.xml | 
*SitemapXmlApi* | [**sitemap_xml_get_sitemap_index**](docs/SitemapXmlApi.md#sitemap_xml_get_sitemap_index) | **GET** /sitemap.xml | 
*SparqlProjectNameApi* | [**sparql_by_id_execute_get_query**](docs/SparqlProjectNameApi.md#sparql_by_id_execute_get_query) | **GET** /sparql/{projectName} | 
*SparqlProjectNameApi* | [**sparql_by_id_execute_post_query**](docs/SparqlProjectNameApi.md#sparql_by_id_execute_post_query) | **POST** /sparql/{projectName} | 
*SsoUserApi* | [**sso_user_user**](docs/SsoUserApi.md#sso_user_user) | **GET** /sso-user | 


## Documentation For Models

 - [AboutType](docs/AboutType.md)
 - [ApplicationRole](docs/ApplicationRole.md)
 - [AuthLoginInfo](docs/AuthLoginInfo.md)
 - [AuthUserDto](docs/AuthUserDto.md)
 - [AuthorizedProjectDto](docs/AuthorizedProjectDto.md)
 - [ChangeInfo](docs/ChangeInfo.md)
 - [DatasetSettings](docs/DatasetSettings.md)
 - [DescriptionType](docs/DescriptionType.md)
 - [DownloadToken](docs/DownloadToken.md)
 - [FacetProperties](docs/FacetProperties.md)
 - [FacetRequest](docs/FacetRequest.md)
 - [FacetResult](docs/FacetResult.md)
 - [FacetResultValue](docs/FacetResultValue.md)
 - [FundingAgency](docs/FundingAgency.md)
 - [FundingAgencyLogo](docs/FundingAgencyLogo.md)
 - [GetRecordType](docs/GetRecordType.md)
 - [GlobalBanner](docs/GlobalBanner.md)
 - [HeaderType](docs/HeaderType.md)
 - [IIIFAnnotation](docs/IIIFAnnotation.md)
 - [IIIFAnnotationPage](docs/IIIFAnnotationPage.md)
 - [IIIFCanvas](docs/IIIFCanvas.md)
 - [IIIFCollection](docs/IIIFCollection.md)
 - [IIIFCollectionEntry](docs/IIIFCollectionEntry.md)
 - [IIIFCollectionItem](docs/IIIFCollectionItem.md)
 - [IIIFCollectionSettings](docs/IIIFCollectionSettings.md)
 - [IIIFImage](docs/IIIFImage.md)
 - [IIIFManifest](docs/IIIFManifest.md)
 - [IIIFManifestEntry](docs/IIIFManifestEntry.md)
 - [IIIFMetadataItem](docs/IIIFMetadataItem.md)
 - [IIIFMultiLanguageText](docs/IIIFMultiLanguageText.md)
 - [IIIFRequiredStatement](docs/IIIFRequiredStatement.md)
 - [IIIFResource](docs/IIIFResource.md)
 - [IIIFService](docs/IIIFService.md)
 - [IdentifyType](docs/IdentifyType.md)
 - [IndexFieldAlias](docs/IndexFieldAlias.md)
 - [IndexProperties](docs/IndexProperties.md)
 - [IngestSourceDatasetsByIdUploadRequest](docs/IngestSourceDatasetsByIdUploadRequest.md)
 - [Institution](docs/Institution.md)
 - [InstitutionLogo](docs/InstitutionLogo.md)
 - [JoinResourceContainer](docs/JoinResourceContainer.md)
 - [JoinResourceContainerJoinResourceObject](docs/JoinResourceContainerJoinResourceObject.md)
 - [JoinResourceObject](docs/JoinResourceObject.md)
 - [Label](docs/Label.md)
 - [LabelDTO](docs/LabelDTO.md)
 - [Language](docs/Language.md)
 - [LanguageDTO](docs/LanguageDTO.md)
 - [LargeLabel](docs/LargeLabel.md)
 - [License](docs/License.md)
 - [LicenseLogo](docs/LicenseLogo.md)
 - [Link](docs/Link.md)
 - [ListIdentifiersType](docs/ListIdentifiersType.md)
 - [ListMetadataFormatsType](docs/ListMetadataFormatsType.md)
 - [ListRecordsType](docs/ListRecordsType.md)
 - [ListSetsType](docs/ListSetsType.md)
 - [LoginInfo](docs/LoginInfo.md)
 - [MappingParameters](docs/MappingParameters.md)
 - [MetadataFormatType](docs/MetadataFormatType.md)
 - [MetadataType](docs/MetadataType.md)
 - [Module](docs/Module.md)
 - [ModuleList](docs/ModuleList.md)
 - [OAIMetadataPrefix](docs/OAIMetadataPrefix.md)
 - [OAIPMH](docs/OAIPMH.md)
 - [OAIPMHerrorType](docs/OAIPMHerrorType.md)
 - [OAIPMHtype](docs/OAIPMHtype.md)
 - [OAISet](docs/OAISet.md)
 - [OntologiesByIdGetOntologyContent200Response](docs/OntologiesByIdGetOntologyContent200Response.md)
 - [Ontology](docs/Ontology.md)
 - [OrcidToken](docs/OrcidToken.md)
 - [Pageable](docs/Pageable.md)
 - [Person](docs/Person.md)
 - [PersonAvatar](docs/PersonAvatar.md)
 - [Project](docs/Project.md)
 - [ProjectLogo](docs/ProjectLogo.md)
 - [ProjectPersonRole](docs/ProjectPersonRole.md)
 - [PublicOntology](docs/PublicOntology.md)
 - [PublicProject](docs/PublicProject.md)
 - [RdfDatasetFile](docs/RdfDatasetFile.md)
 - [RdfFile](docs/RdfFile.md)
 - [RecordType](docs/RecordType.md)
 - [Relation3TiersChildDTO](docs/Relation3TiersChildDTO.md)
 - [RequestType](docs/RequestType.md)
 - [ResearchDataFile](docs/ResearchDataFile.md)
 - [ResearchObjectMetadata](docs/ResearchObjectMetadata.md)
 - [ResearchObjectType](docs/ResearchObjectType.md)
 - [ResourceFile](docs/ResourceFile.md)
 - [RestCollectionAuthorizedProjectDto](docs/RestCollectionAuthorizedProjectDto.md)
 - [RestCollectionDatasetSettings](docs/RestCollectionDatasetSettings.md)
 - [RestCollectionFacetRequest](docs/RestCollectionFacetRequest.md)
 - [RestCollectionFundingAgency](docs/RestCollectionFundingAgency.md)
 - [RestCollectionGlobalBanner](docs/RestCollectionGlobalBanner.md)
 - [RestCollectionIIIFCollectionEntry](docs/RestCollectionIIIFCollectionEntry.md)
 - [RestCollectionIIIFCollectionSettings](docs/RestCollectionIIIFCollectionSettings.md)
 - [RestCollectionIIIFManifestEntry](docs/RestCollectionIIIFManifestEntry.md)
 - [RestCollectionIndexFieldAlias](docs/RestCollectionIndexFieldAlias.md)
 - [RestCollectionIndexProperties](docs/RestCollectionIndexProperties.md)
 - [RestCollectionInstitution](docs/RestCollectionInstitution.md)
 - [RestCollectionLanguage](docs/RestCollectionLanguage.md)
 - [RestCollectionLicense](docs/RestCollectionLicense.md)
 - [RestCollectionOAIMetadataPrefix](docs/RestCollectionOAIMetadataPrefix.md)
 - [RestCollectionOAISet](docs/RestCollectionOAISet.md)
 - [RestCollectionOntology](docs/RestCollectionOntology.md)
 - [RestCollectionPage](docs/RestCollectionPage.md)
 - [RestCollectionPerson](docs/RestCollectionPerson.md)
 - [RestCollectionProject](docs/RestCollectionProject.md)
 - [RestCollectionPublicOntology](docs/RestCollectionPublicOntology.md)
 - [RestCollectionPublicProject](docs/RestCollectionPublicProject.md)
 - [RestCollectionRdfDatasetFile](docs/RestCollectionRdfDatasetFile.md)
 - [RestCollectionRelation3TiersChildDTO](docs/RestCollectionRelation3TiersChildDTO.md)
 - [RestCollectionResearchDataFile](docs/RestCollectionResearchDataFile.md)
 - [RestCollectionResearchObjectMetadata](docs/RestCollectionResearchObjectMetadata.md)
 - [RestCollectionResearchObjectType](docs/RestCollectionResearchObjectType.md)
 - [RestCollectionRml](docs/RestCollectionRml.md)
 - [RestCollectionRole](docs/RestCollectionRole.md)
 - [RestCollectionSolidifyApplicationRole](docs/RestCollectionSolidifyApplicationRole.md)
 - [RestCollectionSourceDataset](docs/RestCollectionSourceDataset.md)
 - [RestCollectionSourceDatasetFile](docs/RestCollectionSourceDatasetFile.md)
 - [RestCollectionSparqlResultRow](docs/RestCollectionSparqlResultRow.md)
 - [RestCollectionStatusHistory](docs/RestCollectionStatusHistory.md)
 - [RestCollectionTriplestoreDataset](docs/RestCollectionTriplestoreDataset.md)
 - [RestCollectionUser](docs/RestCollectionUser.md)
 - [Result](docs/Result.md)
 - [ResumptionTokenType](docs/ResumptionTokenType.md)
 - [Rml](docs/Rml.md)
 - [Role](docs/Role.md)
 - [SearchCondition](docs/SearchCondition.md)
 - [SearchCriteria](docs/SearchCriteria.md)
 - [SetType](docs/SetType.md)
 - [SitemapXmlGetSitemapIndex200Response](docs/SitemapXmlGetSitemapIndex200Response.md)
 - [Sitemapindex](docs/Sitemapindex.md)
 - [SolidifyApplicationRole](docs/SolidifyApplicationRole.md)
 - [SourceDataset](docs/SourceDataset.md)
 - [SourceDatasetFile](docs/SourceDatasetFile.md)
 - [SourceDatasetLogo](docs/SourceDatasetLogo.md)
 - [SparqlResultRow](docs/SparqlResultRow.md)
 - [SparqlResultValue](docs/SparqlResultValue.md)
 - [StatusHistory](docs/StatusHistory.md)
 - [SystemProperties](docs/SystemProperties.md)
 - [TSitemap](docs/TSitemap.md)
 - [TUrl](docs/TUrl.md)
 - [TriplestoreDataset](docs/TriplestoreDataset.md)
 - [Urlset](docs/Urlset.md)
 - [User](docs/User.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="tokenAuth"></a>
### tokenAuth

- **Type**: Bearer authentication (JWT)

<a id="auth"></a>
### auth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: doc/oauth/authorize
- **Scopes**: 
 - **app-hedera**: hedera Solution


## Author

eresearch-opensource@unige.ch


