# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.application_role import ApplicationRole
from hedera_api_client.models.auth_login_info import AuthLoginInfo
from hedera_api_client.models.login_info import LoginInfo
from typing import Optional, Set
from typing_extensions import Self

class AuthUserDto(BaseModel):
    """
    AuthUserDto
    """ # noqa: E501
    res_id: Optional[StrictStr] = Field(default=None, alias="resId")
    external_uid: Optional[StrictStr] = Field(default=None, alias="externalUid")
    creation_when: Optional[datetime] = Field(default=None, alias="creationWhen")
    last_update_when: Optional[datetime] = Field(default=None, alias="lastUpdateWhen")
    creation_who: Optional[StrictStr] = Field(default=None, alias="creationWho")
    last_update_who: Optional[StrictStr] = Field(default=None, alias="lastUpdateWho")
    disabled: Optional[StrictBool] = None
    email: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    home_organization: Optional[StrictStr] = Field(default=None, alias="homeOrganization")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    application_role: Optional[ApplicationRole] = Field(default=None, alias="applicationRole")
    first_login: Optional[AuthLoginInfo] = Field(default=None, alias="firstLogin")
    last_login: Optional[LoginInfo] = Field(default=None, alias="lastLogin")
    orcid: Optional[StrictStr] = Field(default=None, description="The ORCID of the person (Format: xxxx-xxxx-xxxx-xxxx).")
    verified_orcid: Optional[StrictBool] = Field(default=None, description="if the person ORCID is verified with ORCID authentication.", alias="verifiedOrcid")
    enabled: Optional[StrictBool] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    __properties: ClassVar[List[str]] = ["resId", "externalUid", "creationWhen", "lastUpdateWhen", "creationWho", "lastUpdateWho", "disabled", "email", "firstName", "homeOrganization", "lastName", "applicationRole", "firstLogin", "lastLogin", "orcid", "verifiedOrcid", "enabled", "fullName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthUserDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application_role
        if self.application_role:
            _dict['applicationRole'] = self.application_role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of first_login
        if self.first_login:
            _dict['firstLogin'] = self.first_login.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_login
        if self.last_login:
            _dict['lastLogin'] = self.last_login.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthUserDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resId": obj.get("resId"),
            "externalUid": obj.get("externalUid"),
            "creationWhen": obj.get("creationWhen"),
            "lastUpdateWhen": obj.get("lastUpdateWhen"),
            "creationWho": obj.get("creationWho"),
            "lastUpdateWho": obj.get("lastUpdateWho"),
            "disabled": obj.get("disabled"),
            "email": obj.get("email"),
            "firstName": obj.get("firstName"),
            "homeOrganization": obj.get("homeOrganization"),
            "lastName": obj.get("lastName"),
            "applicationRole": ApplicationRole.from_dict(obj["applicationRole"]) if obj.get("applicationRole") is not None else None,
            "firstLogin": AuthLoginInfo.from_dict(obj["firstLogin"]) if obj.get("firstLogin") is not None else None,
            "lastLogin": LoginInfo.from_dict(obj["lastLogin"]) if obj.get("lastLogin") is not None else None,
            "orcid": obj.get("orcid"),
            "verifiedOrcid": obj.get("verifiedOrcid"),
            "enabled": obj.get("enabled"),
            "fullName": obj.get("fullName")
        })
        return _obj


