# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.label_dto import LabelDTO
from typing import Optional, Set
from typing_extensions import Self

class FacetProperties(BaseModel):
    """
    Describes facet properties used on archives search page.
    """ # noqa: E501
    name: Optional[StrictStr] = None
    default_visible_values: Optional[StrictInt] = Field(default=None, alias="defaultVisibleValues")
    labels: Optional[List[LabelDTO]] = None
    description_labels: Optional[List[LabelDTO]] = Field(default=None, alias="descriptionLabels")
    with_description: Optional[StrictBool] = Field(default=None, alias="withDescription")
    __properties: ClassVar[List[str]] = ["name", "defaultVisibleValues", "labels", "descriptionLabels", "withDescription"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FacetProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in description_labels (list)
        _items = []
        if self.description_labels:
            for _item_description_labels in self.description_labels:
                if _item_description_labels:
                    _items.append(_item_description_labels.to_dict())
            _dict['descriptionLabels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FacetProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "defaultVisibleValues": obj.get("defaultVisibleValues"),
            "labels": [LabelDTO.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "descriptionLabels": [LabelDTO.from_dict(_item) for _item in obj["descriptionLabels"]] if obj.get("descriptionLabels") is not None else None,
            "withDescription": obj.get("withDescription")
        })
        return _obj


