# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.label import Label
from hedera_api_client.models.large_label import LargeLabel
from hedera_api_client.models.link import Link
from typing import Optional, Set
from typing_extensions import Self

class GlobalBanner(BaseModel):
    """
    The global banner allows to communicate general informations.
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    name: Optional[StrictStr] = Field(default=None, description="The name of the global banner.")
    type: Optional[StrictStr] = Field(default=None, description="The type of the global banner.")
    title_labels: Optional[List[Label]] = Field(default=None, description="The title list by language of the global banner.", alias="titleLabels")
    description_labels: Optional[List[LargeLabel]] = Field(default=None, description="The description list by language of the global banner.", alias="descriptionLabels")
    enabled: Optional[StrictBool] = Field(default=None, description="If the global banner is enable.")
    start_date: Optional[datetime] = Field(default=None, description="The start date of the global banner.", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, description="The end date of the global banner.", alias="endDate")
    with_description: Optional[StrictBool] = Field(default=None, description="If the global banner has a description.", alias="withDescription")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "name", "type", "titleLabels", "descriptionLabels", "enabled", "startDate", "endDate", "withDescription", "_links"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CRITICAL', 'WARNING', 'INFO']):
            raise ValueError("must be one of enum values ('CRITICAL', 'WARNING', 'INFO')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GlobalBanner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "with_description",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in title_labels (list)
        _items = []
        if self.title_labels:
            for _item_title_labels in self.title_labels:
                if _item_title_labels:
                    _items.append(_item_title_labels.to_dict())
            _dict['titleLabels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in description_labels (list)
        _items = []
        if self.description_labels:
            for _item_description_labels in self.description_labels:
                if _item_description_labels:
                    _items.append(_item_description_labels.to_dict())
            _dict['descriptionLabels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GlobalBanner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "titleLabels": [Label.from_dict(_item) for _item in obj["titleLabels"]] if obj.get("titleLabels") is not None else None,
            "descriptionLabels": [LargeLabel.from_dict(_item) for _item in obj["descriptionLabels"]] if obj.get("descriptionLabels") is not None else None,
            "enabled": obj.get("enabled"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "withDescription": obj.get("withDescription"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


