# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.description_type import DescriptionType
from typing import Optional, Set
from typing_extensions import Self

class IdentifyType(BaseModel):
    """
    IdentifyType
    """ # noqa: E501
    repository_name: Optional[StrictStr] = Field(default=None, alias="repositoryName")
    base_url: Optional[StrictStr] = Field(default=None, alias="baseURL")
    protocol_version: Optional[StrictStr] = Field(default=None, alias="protocolVersion")
    admin_email: Optional[List[StrictStr]] = Field(default=None, alias="adminEmail")
    earliest_datestamp: Optional[StrictStr] = Field(default=None, alias="earliestDatestamp")
    deleted_record: Optional[StrictStr] = Field(default=None, alias="deletedRecord")
    granularity: Optional[StrictStr] = None
    compression: Optional[List[StrictStr]] = None
    description: Optional[List[DescriptionType]] = None
    __properties: ClassVar[List[str]] = ["repositoryName", "baseURL", "protocolVersion", "adminEmail", "earliestDatestamp", "deletedRecord", "granularity", "compression", "description"]

    @field_validator('deleted_record')
    def deleted_record_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NO', 'PERSISTENT', 'TRANSIENT']):
            raise ValueError("must be one of enum values ('NO', 'PERSISTENT', 'TRANSIENT')")
        return value

    @field_validator('granularity')
    def granularity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['YYYY_MM_DD', 'YYYY_MM_DD_THH_MM_SS_Z']):
            raise ValueError("must be one of enum values ('YYYY_MM_DD', 'YYYY_MM_DD_THH_MM_SS_Z')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentifyType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item_description in self.description:
                if _item_description:
                    _items.append(_item_description.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentifyType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "repositoryName": obj.get("repositoryName"),
            "baseURL": obj.get("baseURL"),
            "protocolVersion": obj.get("protocolVersion"),
            "adminEmail": obj.get("adminEmail"),
            "earliestDatestamp": obj.get("earliestDatestamp"),
            "deletedRecord": obj.get("deletedRecord"),
            "granularity": obj.get("granularity"),
            "compression": obj.get("compression"),
            "description": [DescriptionType.from_dict(_item) for _item in obj["description"]] if obj.get("description") is not None else None
        })
        return _obj


