# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.iiif_collection_item import IIIFCollectionItem
from hedera_api_client.models.iiif_multi_language_text import IIIFMultiLanguageText
from typing import Optional, Set
from typing_extensions import Self

class IIIFCollection(BaseModel):
    """
    A IIIF collection is the set of IIIF resources.
    """ # noqa: E501
    context: Optional[StrictStr] = Field(default=None, description="The JSON schema of the IIIF collection.")
    id: Optional[StrictStr] = Field(default=None, description="The identifier of the IIIF collection.")
    type: Optional[StrictStr] = Field(default=None, description="The type of the IIIF collection.")
    label: Optional[IIIFMultiLanguageText] = None
    items: Optional[List[IIIFCollectionItem]] = Field(default=None, description="The items of the IIIF collection.")
    __properties: ClassVar[List[str]] = ["context", "id", "type", "label", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IIIFCollection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of label
        if self.label:
            _dict['label'] = self.label.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IIIFCollection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "context": obj.get("context"),
            "id": obj.get("id"),
            "type": obj.get("type"),
            "label": IIIFMultiLanguageText.from_dict(obj["label"]) if obj.get("label") is not None else None,
            "items": [IIIFCollectionItem.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None
        })
        return _obj


