# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.iiif_canvas import IIIFCanvas
from hedera_api_client.models.iiif_metadata_item import IIIFMetadataItem
from hedera_api_client.models.iiif_multi_language_text import IIIFMultiLanguageText
from hedera_api_client.models.iiif_required_statement import IIIFRequiredStatement
from typing import Optional, Set
from typing_extensions import Self

class IIIFManifest(BaseModel):
    """
    A IIIF manifest is the metadata of a IIIF resource.
    """ # noqa: E501
    context: Optional[List[StrictStr]] = Field(default=None, description="The JSON schema of the IIIF manifest.", alias="@context")
    id: Optional[StrictStr] = Field(default=None, description="The identifier of the IIIF manifest.")
    type: Optional[StrictStr] = Field(default=None, description="The type of the IIIF manifest.")
    label: Optional[IIIFMultiLanguageText] = None
    metadata: Optional[List[IIIFMetadataItem]] = Field(default=None, description="The metadata of the IIIF manifest.")
    required_statement: Optional[IIIFRequiredStatement] = Field(default=None, alias="requiredStatement")
    items: Optional[List[IIIFCanvas]] = Field(default=None, description="The canvases of the IIIF manifest.")
    __properties: ClassVar[List[str]] = ["@context", "id", "type", "label", "metadata", "requiredStatement", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IIIFManifest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of label
        if self.label:
            _dict['label'] = self.label.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item_metadata in self.metadata:
                if _item_metadata:
                    _items.append(_item_metadata.to_dict())
            _dict['metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of required_statement
        if self.required_statement:
            _dict['requiredStatement'] = self.required_statement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IIIFManifest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "@context": obj.get("@context"),
            "id": obj.get("id"),
            "type": obj.get("type"),
            "label": IIIFMultiLanguageText.from_dict(obj["label"]) if obj.get("label") is not None else None,
            "metadata": [IIIFMetadataItem.from_dict(_item) for _item in obj["metadata"]] if obj.get("metadata") is not None else None,
            "requiredStatement": IIIFRequiredStatement.from_dict(obj["requiredStatement"]) if obj.get("requiredStatement") is not None else None,
            "items": [IIIFCanvas.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None
        })
        return _obj


