# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.link import Link
from typing import Optional, Set
from typing_extensions import Self

class OAISet(BaseModel):
    """
    OAI set.
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    description: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="The description of the OAI set.")
    enabled: Optional[StrictBool] = Field(default=None, description="If the OAI set is enable.")
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)]] = Field(default=None, description="The name of the OAI set.")
    query: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="The criteria to define the OAI set: query compliant with indexing search.")
    spec: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)]] = Field(default=None, description="The spec of OAI set, which is an unique identifier for the set.")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "description", "enabled", "name", "query", "spec", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OAISet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OAISet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "name": obj.get("name"),
            "query": obj.get("query"),
            "spec": obj.get("spec"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


