# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.get_record_type import GetRecordType
from hedera_api_client.models.identify_type import IdentifyType
from hedera_api_client.models.list_identifiers_type import ListIdentifiersType
from hedera_api_client.models.list_metadata_formats_type import ListMetadataFormatsType
from hedera_api_client.models.list_records_type import ListRecordsType
from hedera_api_client.models.list_sets_type import ListSetsType
from hedera_api_client.models.oaipm_herror_type import OAIPMHerrorType
from hedera_api_client.models.request_type import RequestType
from typing import Optional, Set
from typing_extensions import Self

class OAIPMHtype(BaseModel):
    """
    OAIPMHtype
    """ # noqa: E501
    response_date: Optional[datetime] = Field(default=None, alias="responseDate")
    request: Optional[RequestType] = None
    error: Optional[List[OAIPMHerrorType]] = None
    identify: Optional[IdentifyType] = None
    list_metadata_formats: Optional[ListMetadataFormatsType] = Field(default=None, alias="listMetadataFormats")
    list_sets: Optional[ListSetsType] = Field(default=None, alias="listSets")
    get_record: Optional[GetRecordType] = Field(default=None, alias="getRecord")
    list_identifiers: Optional[ListIdentifiersType] = Field(default=None, alias="listIdentifiers")
    list_records: Optional[ListRecordsType] = Field(default=None, alias="listRecords")
    __properties: ClassVar[List[str]] = ["responseDate", "request", "error", "identify", "listMetadataFormats", "listSets", "getRecord", "listIdentifiers", "listRecords"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OAIPMHtype from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in error (list)
        _items = []
        if self.error:
            for _item_error in self.error:
                if _item_error:
                    _items.append(_item_error.to_dict())
            _dict['error'] = _items
        # override the default output from pydantic by calling `to_dict()` of identify
        if self.identify:
            _dict['identify'] = self.identify.to_dict()
        # override the default output from pydantic by calling `to_dict()` of list_metadata_formats
        if self.list_metadata_formats:
            _dict['listMetadataFormats'] = self.list_metadata_formats.to_dict()
        # override the default output from pydantic by calling `to_dict()` of list_sets
        if self.list_sets:
            _dict['listSets'] = self.list_sets.to_dict()
        # override the default output from pydantic by calling `to_dict()` of get_record
        if self.get_record:
            _dict['getRecord'] = self.get_record.to_dict()
        # override the default output from pydantic by calling `to_dict()` of list_identifiers
        if self.list_identifiers:
            _dict['listIdentifiers'] = self.list_identifiers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of list_records
        if self.list_records:
            _dict['listRecords'] = self.list_records.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OAIPMHtype from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "responseDate": obj.get("responseDate"),
            "request": RequestType.from_dict(obj["request"]) if obj.get("request") is not None else None,
            "error": [OAIPMHerrorType.from_dict(_item) for _item in obj["error"]] if obj.get("error") is not None else None,
            "identify": IdentifyType.from_dict(obj["identify"]) if obj.get("identify") is not None else None,
            "listMetadataFormats": ListMetadataFormatsType.from_dict(obj["listMetadataFormats"]) if obj.get("listMetadataFormats") is not None else None,
            "listSets": ListSetsType.from_dict(obj["listSets"]) if obj.get("listSets") is not None else None,
            "getRecord": GetRecordType.from_dict(obj["getRecord"]) if obj.get("getRecord") is not None else None,
            "listIdentifiers": ListIdentifiersType.from_dict(obj["listIdentifiers"]) if obj.get("listIdentifiers") is not None else None,
            "listRecords": ListRecordsType.from_dict(obj["listRecords"]) if obj.get("listRecords") is not None else None
        })
        return _obj


