# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.link import Link
from hedera_api_client.models.orcid_token import OrcidToken
from hedera_api_client.models.person_avatar import PersonAvatar
from hedera_api_client.models.search_criteria import SearchCriteria
from typing import Optional, Set
from typing_extensions import Self

class Person(BaseModel):
    """
    A person is associated to a user on the platform. It contains information such as the person’s ORCID, institution and organizational units it belongs to.
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    search_criterias: Optional[List[SearchCriteria]] = Field(default=None, alias="searchCriterias")
    first_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)]] = Field(default=None, description="The first name of the person.", alias="firstName")
    last_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)]] = Field(default=None, description="The last name of the person.", alias="lastName")
    orcid: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The ORCID of the person (Format: xxxx-xxxx-xxxx-xxxx).")
    verified_orcid: Optional[StrictBool] = Field(default=None, description="if the person ORCID is verified with ORCID authentication.", alias="verifiedOrcid")
    orcid_token: Optional[OrcidToken] = Field(default=None, alias="orcidToken")
    avatar: Optional[PersonAvatar] = None
    full_name: Optional[StrictStr] = Field(default=None, description="The full name of the person", alias="fullName")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "searchCriterias", "firstName", "lastName", "orcid", "verifiedOrcid", "orcidToken", "avatar", "fullName", "_links"]

    @field_validator('orcid')
    def orcid_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"|[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{4}|[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}X", value):
            raise ValueError(r"must validate the regular expression /|[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{4}|[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}X/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Person from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "full_name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in search_criterias (list)
        _items = []
        if self.search_criterias:
            for _item_search_criterias in self.search_criterias:
                if _item_search_criterias:
                    _items.append(_item_search_criterias.to_dict())
            _dict['searchCriterias'] = _items
        # override the default output from pydantic by calling `to_dict()` of orcid_token
        if self.orcid_token:
            _dict['orcidToken'] = self.orcid_token.to_dict()
        # override the default output from pydantic by calling `to_dict()` of avatar
        if self.avatar:
            _dict['avatar'] = self.avatar.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Person from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "searchCriterias": [SearchCriteria.from_dict(_item) for _item in obj["searchCriterias"]] if obj.get("searchCriterias") is not None else None,
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "orcid": obj.get("orcid"),
            "verifiedOrcid": obj.get("verifiedOrcid"),
            "orcidToken": OrcidToken.from_dict(obj["orcidToken"]) if obj.get("orcidToken") is not None else None,
            "avatar": PersonAvatar.from_dict(obj["avatar"]) if obj.get("avatar") is not None else None,
            "fullName": obj.get("fullName"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


