# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.license import License
from hedera_api_client.models.link import Link
from hedera_api_client.models.project_logo import ProjectLogo
from hedera_api_client.models.research_object_type import ResearchObjectType
from typing import Optional, Set
from typing_extensions import Self

class Project(BaseModel):
    """
    A project represents a research project which contains metadata (source datasets) and files (research data files).
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    closing_date: Optional[date] = Field(default=None, description="The closing date of the project.", alias="closingDate")
    default_license: Optional[License] = Field(default=None, alias="defaultLicense")
    description: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1024)]] = Field(default=None, description="The description of the project.")
    file_number: Optional[StrictInt] = Field(default=None, description="The file number of the project (research data files)", alias="fileNumber")
    triple_number: Optional[StrictInt] = Field(default=None, description="The triple number of the project (source datasets)", alias="tripleNumber")
    total_size: Optional[StrictInt] = Field(default=None, description="The total size of the project ", alias="totalSize")
    keywords: Optional[List[StrictStr]] = Field(default=None, description="The keywords associated with this project, they are used as default for deposits created within this project.")
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=255)]] = Field(default=None, description="The name of the project.")
    storage_type: Optional[StrictStr] = Field(default=None, description="Storage type for research data files: - FILE => File Storage - OBJECT => Object Storage (S3) ", alias="storageType")
    short_name: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=63)]] = Field(default=None, description="The short name of the project (folder for file storage, bucket for object storage & triplestore dataset).", alias="shortName")
    opening_date: Optional[date] = Field(default=None, description="The opening date of the project.", alias="openingDate")
    url: Optional[StrictStr] = Field(default=None, description="The URL of the project.")
    logo: Optional[ProjectLogo] = None
    copyright_holder: Optional[StrictStr] = Field(default=None, description="The copyright holder of the project", alias="copyrightHolder")
    access_public: Optional[StrictBool] = Field(default=None, description="If the content of the project is public or private.", alias="accessPublic")
    iiif_manifest_sparql_query: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=2147483646)]] = Field(default=None, description="SPARQL query to generate IIIF manifest.", alias="iiifManifestSparqlQuery")
    iiif_manifest_research_object_type: Optional[ResearchObjectType] = Field(default=None, alias="iiifManifestResearchObjectType")
    research_data_file_research_object_type: Optional[ResearchObjectType] = Field(default=None, alias="researchDataFileResearchObjectType")
    open: Optional[StrictBool] = None
    smart_total_size: Optional[StrictStr] = Field(default=None, description="The total size in human-readable format of the project.", alias="smartTotalSize")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    has_data: Optional[StrictBool] = Field(default=None, description="If the project has data (source dataset or research data file)", alias="hasData")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "closingDate", "defaultLicense", "description", "fileNumber", "tripleNumber", "totalSize", "keywords", "name", "storageType", "shortName", "openingDate", "url", "logo", "copyrightHolder", "accessPublic", "iiifManifestSparqlQuery", "iiifManifestResearchObjectType", "researchDataFileResearchObjectType", "open", "smartTotalSize", "_links", "hasData"]

    @field_validator('storage_type')
    def storage_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FILE', 'OBJECT']):
            raise ValueError("must be one of enum values ('FILE', 'OBJECT')")
        return value

    @field_validator('short_name')
    def short_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"(?!(^xn--|^sthree-|.+-s3alias|.+--ol-s3$))^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$", value):
            raise ValueError(r"must validate the regular expression /(?!(^xn--|^sthree-|.+-s3alias|.+--ol-s3$))^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "smart_total_size",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_license
        if self.default_license:
            _dict['defaultLicense'] = self.default_license.to_dict()
        # override the default output from pydantic by calling `to_dict()` of logo
        if self.logo:
            _dict['logo'] = self.logo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of iiif_manifest_research_object_type
        if self.iiif_manifest_research_object_type:
            _dict['iiifManifestResearchObjectType'] = self.iiif_manifest_research_object_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of research_data_file_research_object_type
        if self.research_data_file_research_object_type:
            _dict['researchDataFileResearchObjectType'] = self.research_data_file_research_object_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "closingDate": obj.get("closingDate"),
            "defaultLicense": License.from_dict(obj["defaultLicense"]) if obj.get("defaultLicense") is not None else None,
            "description": obj.get("description"),
            "fileNumber": obj.get("fileNumber"),
            "tripleNumber": obj.get("tripleNumber"),
            "totalSize": obj.get("totalSize"),
            "keywords": obj.get("keywords"),
            "name": obj.get("name"),
            "storageType": obj.get("storageType"),
            "shortName": obj.get("shortName"),
            "openingDate": obj.get("openingDate"),
            "url": obj.get("url"),
            "logo": ProjectLogo.from_dict(obj["logo"]) if obj.get("logo") is not None else None,
            "copyrightHolder": obj.get("copyrightHolder"),
            "accessPublic": obj.get("accessPublic"),
            "iiifManifestSparqlQuery": obj.get("iiifManifestSparqlQuery"),
            "iiifManifestResearchObjectType": ResearchObjectType.from_dict(obj["iiifManifestResearchObjectType"]) if obj.get("iiifManifestResearchObjectType") is not None else None,
            "researchDataFileResearchObjectType": ResearchObjectType.from_dict(obj["researchDataFileResearchObjectType"]) if obj.get("researchDataFileResearchObjectType") is not None else None,
            "open": obj.get("open"),
            "smartTotalSize": obj.get("smartTotalSize"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None,
            "hasData": obj.get("hasData")
        })
        return _obj


