# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.link import Link
from hedera_api_client.models.project_logo import ProjectLogo
from typing import Optional, Set
from typing_extensions import Self

class PublicProject(BaseModel):
    """
    A project represents a research project which contains metadata (source datasets) and files (research data files).
    """ # noqa: E501
    res_id: Optional[StrictStr] = Field(default=None, alias="resId")
    name: Optional[StrictStr] = Field(default=None, description="The name of the project.")
    short_name: Optional[StrictStr] = Field(default=None, description="The short name of the project (folder for file storage, bucket for object storage & triplestore dataset).", alias="shortName")
    description: Optional[StrictStr] = Field(default=None, description="The description of the project.")
    url: Optional[StrictStr] = Field(default=None, description="The URL of the project.")
    opening_date: Optional[date] = Field(default=None, description="The opening date of the project.", alias="openingDate")
    closing_date: Optional[date] = Field(default=None, description="The closing date of the project.", alias="closingDate")
    logo: Optional[ProjectLogo] = None
    access_public: Optional[StrictBool] = Field(default=None, description="If the content of the project is public or private.", alias="accessPublic")
    file_number: Optional[StrictInt] = Field(default=None, description="The file number of the project (research data files)", alias="fileNumber")
    triple_number: Optional[StrictInt] = Field(default=None, description="The triple number of the project (source datasets)", alias="tripleNumber")
    total_size: Optional[StrictInt] = Field(default=None, description="The total size of the project ", alias="totalSize")
    smart_total_size: Optional[StrictStr] = Field(default=None, description="The total size in human-readable format of the project.", alias="smartTotalSize")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["resId", "name", "shortName", "description", "url", "openingDate", "closingDate", "logo", "accessPublic", "fileNumber", "tripleNumber", "totalSize", "smartTotalSize", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "smart_total_size",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of logo
        if self.logo:
            _dict['logo'] = self.logo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicProject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resId": obj.get("resId"),
            "name": obj.get("name"),
            "shortName": obj.get("shortName"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "openingDate": obj.get("openingDate"),
            "closingDate": obj.get("closingDate"),
            "logo": ProjectLogo.from_dict(obj["logo"]) if obj.get("logo") is not None else None,
            "accessPublic": obj.get("accessPublic"),
            "fileNumber": obj.get("fileNumber"),
            "tripleNumber": obj.get("tripleNumber"),
            "totalSize": obj.get("totalSize"),
            "smartTotalSize": obj.get("smartTotalSize"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


