# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.link import Link
from hedera_api_client.models.source_dataset_file import SourceDatasetFile
from typing import Optional, Set
from typing_extensions import Self

class RdfDatasetFile(BaseModel):
    """
    The file representing the output of a RML mapping. RDF Dataset File status: - NOT_IMPORTED => Initial status - TO_IMPORT => In queue to be imported - IMPORTING => RDF metadata storing in-progress (triple store) - INDEXING => Index metadata storing in-progress (index) - TO_REPLACE => In queue to be replaced - REPLACING => Replacement in-progress (purge metadat in triple store & index) - IMPORTED => RDF metadata imported - TO_REIMPORT => In queue to be reimport - IN_ERROR => In-Error (see the reason in the history) - TO_REMOVE => In queue to be removed - REMOVING => Deletion in-progress 
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    status_import: Optional[StrictStr] = Field(default=None, description="The status of the RDF dataset file.", alias="statusImport")
    status_message: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1024)]] = Field(default=None, description="The detailed message related to the RDF dataset file status.", alias="statusMessage")
    source_dataset_file: Optional[SourceDatasetFile] = Field(default=None, alias="sourceDatasetFile")
    rml_id: Optional[StrictStr] = Field(default=None, description="The RML file id used to generate this RDF dataset file", alias="rmlId")
    triplestore_dataset_id: Optional[StrictStr] = Field(default=None, description="The Triplestore dataset on which the RDF dataset file is deployer", alias="triplestoreDatasetId")
    file_name: Optional[StrictStr] = Field(default=None, description="The file name.", alias="fileName")
    file_size: Optional[StrictInt] = Field(default=None, description="The file size in bytes.", alias="fileSize")
    rdf_format: Optional[StrictStr] = Field(default=None, description="RDF format.", alias="rdfFormat")
    extension: Optional[StrictStr] = None
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    error_status_with_message: Optional[StrictStr] = Field(default=None, alias="errorStatusWithMessage")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "statusImport", "statusMessage", "sourceDatasetFile", "rmlId", "triplestoreDatasetId", "fileName", "fileSize", "rdfFormat", "extension", "projectId", "errorStatusWithMessage", "_links"]

    @field_validator('status_import')
    def status_import_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_IMPORTED', 'TO_IMPORT', 'IMPORTING', 'INDEXING', 'TO_REPLACE', 'REPLACING', 'IMPORTED', 'TO_REIMPORT', 'IN_ERROR', 'TO_REMOVE', 'REMOVING']):
            raise ValueError("must be one of enum values ('NOT_IMPORTED', 'TO_IMPORT', 'IMPORTING', 'INDEXING', 'TO_REPLACE', 'REPLACING', 'IMPORTED', 'TO_REIMPORT', 'IN_ERROR', 'TO_REMOVE', 'REMOVING')")
        return value

    @field_validator('rdf_format')
    def rdf_format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['JSON_LD', 'RDF_XML', 'RDF_JSON', 'N_TRIPLES', 'TURTLE', 'N3', 'N_QUADS', 'TRIG', 'TRIX']):
            raise ValueError("must be one of enum values ('JSON_LD', 'RDF_XML', 'RDF_JSON', 'N_TRIPLES', 'TURTLE', 'N3', 'N_QUADS', 'TRIG', 'TRIX')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RdfDatasetFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_dataset_file
        if self.source_dataset_file:
            _dict['sourceDatasetFile'] = self.source_dataset_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RdfDatasetFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "statusImport": obj.get("statusImport"),
            "statusMessage": obj.get("statusMessage"),
            "sourceDatasetFile": SourceDatasetFile.from_dict(obj["sourceDatasetFile"]) if obj.get("sourceDatasetFile") is not None else None,
            "rmlId": obj.get("rmlId"),
            "triplestoreDatasetId": obj.get("triplestoreDatasetId"),
            "fileName": obj.get("fileName"),
            "fileSize": obj.get("fileSize"),
            "rdfFormat": obj.get("rdfFormat"),
            "extension": obj.get("extension"),
            "projectId": obj.get("projectId"),
            "errorStatusWithMessage": obj.get("errorStatusWithMessage"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


