# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.about_type import AboutType
from hedera_api_client.models.header_type import HeaderType
from hedera_api_client.models.metadata_type import MetadataType
from typing import Optional, Set
from typing_extensions import Self

class RecordType(BaseModel):
    """
    RecordType
    """ # noqa: E501
    header: Optional[HeaderType] = None
    metadata: Optional[MetadataType] = None
    about: Optional[List[AboutType]] = None
    __properties: ClassVar[List[str]] = ["header", "metadata", "about"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecordType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of header
        if self.header:
            _dict['header'] = self.header.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in about (list)
        _items = []
        if self.about:
            for _item_about in self.about:
                if _item_about:
                    _items.append(_item_about.to_dict())
            _dict['about'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecordType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "header": HeaderType.from_dict(obj["header"]) if obj.get("header") is not None else None,
            "metadata": MetadataType.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "about": [AboutType.from_dict(_item) for _item in obj["about"]] if obj.get("about") is not None else None
        })
        return _obj


