# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RequestType(BaseModel):
    """
    RequestType
    """ # noqa: E501
    value: Optional[StrictStr] = None
    verb: Optional[StrictStr] = None
    identifier: Optional[StrictStr] = None
    metadata_prefix: Optional[StrictStr] = Field(default=None, alias="metadataPrefix")
    var_from: Optional[StrictStr] = Field(default=None, alias="from")
    until: Optional[StrictStr] = None
    set: Optional[StrictStr] = None
    resumption_token: Optional[StrictStr] = Field(default=None, alias="resumptionToken")
    __properties: ClassVar[List[str]] = ["value", "verb", "identifier", "metadataPrefix", "from", "until", "set", "resumptionToken"]

    @field_validator('verb')
    def verb_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IDENTIFY', 'LIST_METADATA_FORMATS', 'LIST_SETS', 'GET_RECORD', 'LIST_IDENTIFIERS', 'LIST_RECORDS']):
            raise ValueError("must be one of enum values ('IDENTIFY', 'LIST_METADATA_FORMATS', 'LIST_SETS', 'GET_RECORD', 'LIST_IDENTIFIERS', 'LIST_RECORDS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RequestType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RequestType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "value": obj.get("value"),
            "verb": obj.get("verb"),
            "identifier": obj.get("identifier"),
            "metadataPrefix": obj.get("metadataPrefix"),
            "from": obj.get("from"),
            "until": obj.get("until"),
            "set": obj.get("set"),
            "resumptionToken": obj.get("resumptionToken")
        })
        return _obj


