# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.link import Link
from hedera_api_client.models.project import Project
from hedera_api_client.models.research_object_type import ResearchObjectType
from typing import Optional, Set
from typing_extensions import Self

class ResearchDataFile(BaseModel):
    """
    A Research data file is the binary file linked in the project. Research data file status: - CREATED => The research data file entry is created - UPLOADED => The research data file is upload - PROCESSING => The research data file processing is in-progress - STORED => The research data file is stored in the project storage (file system or S3) - REFERENCED = The RDF metadata of the research data file are generated - COMPLETED => The research data file is ready to be accessed via search engine or the SPARQL queries - IN_ERROR => The research data file is in-error (see the reason in the history) - CHANGE_RELATIVE_LOCATION => The research data file 'change relative location' operation is in-progress 
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    accessible_from: Optional[StrictStr] = Field(default=None, description="The type of location where is stored.", alias="accessibleFrom")
    research_object_type: Optional[ResearchObjectType] = Field(default=None, alias="researchObjectType")
    research_object_type_id: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)]] = Field(default=None, description="The researchObjectType identifier of the ResearchDataFile.", alias="researchObjectTypeId")
    project: Optional[Project] = None
    project_id: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=2147483647)]] = Field(default=None, description="The project identifier of the ResearchDataFile.", alias="projectId")
    file_name: Optional[StrictStr] = Field(default=None, description="The file name.", alias="fileName")
    status: Optional[StrictStr] = Field(default=None, description="The status of the research data file.")
    status_message: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1024)]] = Field(default=None, description="The detailed message related to the research data file status.", alias="statusMessage")
    file_size: Optional[StrictInt] = Field(default=None, description="The research data file size in bytes.", alias="fileSize")
    relative_location: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, alias="relativeLocation")
    mime_type: Optional[StrictStr] = Field(default=None, description="The mime-type of the research data file.", alias="mimeType")
    metadata: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, description="The metadata of the research data file.")
    uri: Optional[StrictStr] = Field(default=None, description="The URI of the research data file.")
    rdf_metadata: Optional[StrictStr] = Field(default=None, description="The RDF metadata of the research data file.", alias="rdfMetadata")
    hedera_id: Optional[StrictStr] = Field(default=None, alias="hederaId")
    error_status_with_message: Optional[StrictStr] = Field(default=None, alias="errorStatusWithMessage")
    smart_file_size: Optional[StrictStr] = Field(default=None, description="The The research data file size in human-readable format.", alias="smartFileSize")
    full_file_name: Optional[StrictStr] = Field(default=None, alias="fullFileName")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "accessibleFrom", "researchObjectType", "researchObjectTypeId", "project", "projectId", "fileName", "status", "statusMessage", "fileSize", "relativeLocation", "mimeType", "metadata", "uri", "rdfMetadata", "hederaId", "errorStatusWithMessage", "smartFileSize", "fullFileName", "_links"]

    @field_validator('accessible_from')
    def accessible_from_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IIIF', 'IIIF_MANIFEST', 'TEI', 'WEB']):
            raise ValueError("must be one of enum values ('IIIF', 'IIIF_MANIFEST', 'TEI', 'WEB')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CREATED', 'UPLOADED', 'PROCESSING', 'STORED', 'REFERENCED', 'COMPLETED', 'IN_ERROR', 'CHANGE_RELATIVE_LOCATION']):
            raise ValueError("must be one of enum values ('CREATED', 'UPLOADED', 'PROCESSING', 'STORED', 'REFERENCED', 'COMPLETED', 'IN_ERROR', 'CHANGE_RELATIVE_LOCATION')")
        return value

    @field_validator('relative_location')
    def relative_location_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"(^\/$)|(^\/.*(?<!\/)$)", value):
            raise ValueError(r"must validate the regular expression /(^\/$)|(^\/.*(?<!\/)$)/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResearchDataFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "hedera_id",
            "smart_file_size",
            "full_file_name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of research_object_type
        if self.research_object_type:
            _dict['researchObjectType'] = self.research_object_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResearchDataFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "accessibleFrom": obj.get("accessibleFrom"),
            "researchObjectType": ResearchObjectType.from_dict(obj["researchObjectType"]) if obj.get("researchObjectType") is not None else None,
            "researchObjectTypeId": obj.get("researchObjectTypeId"),
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "projectId": obj.get("projectId"),
            "fileName": obj.get("fileName"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "fileSize": obj.get("fileSize"),
            "relativeLocation": obj.get("relativeLocation"),
            "mimeType": obj.get("mimeType"),
            "metadata": obj.get("metadata"),
            "uri": obj.get("uri"),
            "rdfMetadata": obj.get("rdfMetadata"),
            "hederaId": obj.get("hederaId"),
            "errorStatusWithMessage": obj.get("errorStatusWithMessage"),
            "smartFileSize": obj.get("smartFileSize"),
            "fullFileName": obj.get("fullFileName"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


