# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.facet_result import FacetResult
from hedera_api_client.models.index_properties import IndexProperties
from hedera_api_client.models.link import Link
from hedera_api_client.models.rest_collection_page import RestCollectionPage
from typing import Optional, Set
from typing_extensions import Self

class RestCollectionIndexProperties(BaseModel):
    """
    The structure of the REST response: - data: the list of objects - page: the pagination information - links: the HATEOAS links - facets: the search information 
    """ # noqa: E501
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    data: Optional[List[IndexProperties]] = Field(default=None, alias="_data")
    facets: Optional[List[FacetResult]] = Field(default=None, alias="_facets")
    page: Optional[RestCollectionPage] = Field(default=None, alias="_page")
    __properties: ClassVar[List[str]] = ["_links", "_data", "_facets", "_page"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RestCollectionIndexProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item_data in self.data:
                if _item_data:
                    _items.append(_item_data.to_dict())
            _dict['_data'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in facets (list)
        _items = []
        if self.facets:
            for _item_facets in self.facets:
                if _item_facets:
                    _items.append(_item_facets.to_dict())
            _dict['_facets'] = _items
        # override the default output from pydantic by calling `to_dict()` of page
        if self.page:
            _dict['_page'] = self.page.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RestCollectionIndexProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None,
            "_data": [IndexProperties.from_dict(_item) for _item in obj["_data"]] if obj.get("_data") is not None else None,
            "_facets": [FacetResult.from_dict(_item) for _item in obj["_facets"]] if obj.get("_facets") is not None else None,
            "_page": RestCollectionPage.from_dict(obj["_page"]) if obj.get("_page") is not None else None
        })
        return _obj


