# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SearchCondition(BaseModel):
    """
    The search conditions describes the query to search in the indexes. 
    """ # noqa: E501
    type: Optional[StrictStr] = None
    search_operator: Optional[StrictStr] = Field(default=None, alias="searchOperator")
    boolean_clause_type: Optional[StrictStr] = Field(default=None, alias="booleanClauseType")
    var_field: Optional[StrictStr] = Field(default=None, alias="field")
    multi_match_fields: Optional[List[StrictStr]] = Field(default=None, alias="multiMatchFields")
    value: Optional[StrictStr] = None
    terms: Optional[List[StrictStr]] = None
    upper_value: Optional[StrictStr] = Field(default=None, alias="upperValue")
    lower_value: Optional[StrictStr] = Field(default=None, alias="lowerValue")
    nested_conditions: Optional[List[SearchCondition]] = Field(default=None, alias="nestedConditions")
    __properties: ClassVar[List[str]] = ["type", "searchOperator", "booleanClauseType", "field", "multiMatchFields", "value", "terms", "upperValue", "lowerValue", "nestedConditions"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MATCH', 'TERM', 'WILDCARD', 'RANGE', 'QUERY', 'SIMPLE_QUERY', 'NESTED_BOOLEAN']):
            raise ValueError("must be one of enum values ('MATCH', 'TERM', 'WILDCARD', 'RANGE', 'QUERY', 'SIMPLE_QUERY', 'NESTED_BOOLEAN')")
        return value

    @field_validator('search_operator')
    def search_operator_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AND', 'OR']):
            raise ValueError("must be one of enum values ('AND', 'OR')")
        return value

    @field_validator('boolean_clause_type')
    def boolean_clause_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MUST', 'FILTER', 'SHOULD', 'MUST_NOT']):
            raise ValueError("must be one of enum values ('MUST', 'FILTER', 'SHOULD', 'MUST_NOT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchCondition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nested_conditions (list)
        _items = []
        if self.nested_conditions:
            for _item_nested_conditions in self.nested_conditions:
                if _item_nested_conditions:
                    _items.append(_item_nested_conditions.to_dict())
            _dict['nestedConditions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchCondition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "searchOperator": obj.get("searchOperator"),
            "booleanClauseType": obj.get("booleanClauseType"),
            "field": obj.get("field"),
            "multiMatchFields": obj.get("multiMatchFields"),
            "value": obj.get("value"),
            "terms": obj.get("terms"),
            "upperValue": obj.get("upperValue"),
            "lowerValue": obj.get("lowerValue"),
            "nestedConditions": [SearchCondition.from_dict(_item) for _item in obj["nestedConditions"]] if obj.get("nestedConditions") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
SearchCondition.model_rebuild(raise_errors=False)

