# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SearchCriteria(BaseModel):
    """
    SearchCriteria
    """ # noqa: E501
    case_insensitive: Optional[StrictBool] = Field(default=None, alias="caseInsensitive")
    case_type: Optional[StrictStr] = Field(default=None, alias="caseType")
    key: Optional[StrictStr] = None
    operation: Optional[StrictStr] = None
    operation_type: Optional[StrictStr] = Field(default=None, alias="operationType")
    value: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["caseInsensitive", "caseType", "key", "operation", "operationType", "value"]

    @field_validator('operation_type')
    def operation_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BETWEEN', 'CONTAINS', 'ENDS_WITH', 'EQUALITY', 'GREATER_EQUAL', 'GREATER_THAN', 'LESS_EQUAL', 'LESS_THAN', 'NEGATION', 'ORACLE_CONTAINS', 'STARTS_WITH']):
            raise ValueError("must be one of enum values ('BETWEEN', 'CONTAINS', 'ENDS_WITH', 'EQUALITY', 'GREATER_EQUAL', 'GREATER_THAN', 'LESS_EQUAL', 'LESS_THAN', 'NEGATION', 'ORACLE_CONTAINS', 'STARTS_WITH')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchCriteria from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchCriteria from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "caseInsensitive": obj.get("caseInsensitive"),
            "caseType": obj.get("caseType"),
            "key": obj.get("key"),
            "operation": obj.get("operation"),
            "operationType": obj.get("operationType"),
            "value": obj.get("value")
        })
        return _obj


