# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hedera_api_client.models.change_info import ChangeInfo
from hedera_api_client.models.link import Link
from hedera_api_client.models.research_data_file import ResearchDataFile
from hedera_api_client.models.search_criteria import SearchCriteria
from hedera_api_client.models.source_dataset import SourceDataset
from typing import Optional, Set
from typing_extensions import Self

class SourceDatasetFile(BaseModel):
    """
    The file represented by Source Dataset. Source Dataset File status: - NOT_TRANSFORMED => Initial status - TO_TRANSFORM => In queue to be transformed - TRANSFORMING => RML conversion in-progress - TRANSFORMED => Transformation completed - TO_CHECK => In queue ti be checked - CHECKING => Verification in-progress - CHECKED => Verification done without applying the transformation - IN_ERROR => In-Error (see the reason in the history) 
    """ # noqa: E501
    creation: Optional[ChangeInfo] = None
    last_update: Optional[ChangeInfo] = Field(default=None, alias="lastUpdate")
    res_id: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=50)]] = Field(default=None, description="The identifier of the resource. The default format is a Universally Unique IDentifier (UUID).", alias="resId")
    search_criterias: Optional[List[SearchCriteria]] = Field(default=None, alias="searchCriterias")
    file_size: Optional[StrictInt] = Field(default=None, description="The file size in bytes.", alias="fileSize")
    file_name: Optional[StrictStr] = Field(default=None, description="The file name.", alias="fileName")
    research_data_file: Optional[ResearchDataFile] = Field(default=None, alias="researchDataFile")
    status: Optional[StrictStr] = Field(default=None, description="The status of the source dataset file.")
    status_message: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1024)]] = Field(default=None, description="The detailed message related to the source dataset file status.", alias="statusMessage")
    type: Optional[StrictStr] = Field(default=None, description="Source Dataset File tyoe: - CSV => Comma-Separated Values file - XML => Extensible Markup Language file - JSON => JavaScript Object Notation file - RDF => Resource Description Framework file ")
    version: Optional[StrictStr] = Field(default=None, description="Version of SourceDatasetFile.")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    dataset: Optional[SourceDataset] = None
    error_status_with_message: Optional[StrictStr] = Field(default=None, alias="errorStatusWithMessage")
    link_to_research_data_file: Optional[StrictBool] = Field(default=None, alias="linkToResearchDataFile")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["creation", "lastUpdate", "resId", "searchCriterias", "fileSize", "fileName", "researchDataFile", "status", "statusMessage", "type", "version", "projectId", "dataset", "errorStatusWithMessage", "linkToResearchDataFile", "_links"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_TRANSFORMED', 'TO_TRANSFORM', 'TRANSFORMING', 'TRANSFORMED', 'TO_CHECK', 'CHECKING', 'CHECKED', 'IN_ERROR']):
            raise ValueError("must be one of enum values ('NOT_TRANSFORMED', 'TO_TRANSFORM', 'TRANSFORMING', 'TRANSFORMED', 'TO_CHECK', 'CHECKING', 'CHECKED', 'IN_ERROR')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CSV', 'XML', 'JSON', 'RDF']):
            raise ValueError("must be one of enum values ('CSV', 'XML', 'JSON', 'RDF')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SourceDatasetFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation
        if self.creation:
            _dict['creation'] = self.creation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_update
        if self.last_update:
            _dict['lastUpdate'] = self.last_update.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in search_criterias (list)
        _items = []
        if self.search_criterias:
            for _item_search_criterias in self.search_criterias:
                if _item_search_criterias:
                    _items.append(_item_search_criterias.to_dict())
            _dict['searchCriterias'] = _items
        # override the default output from pydantic by calling `to_dict()` of research_data_file
        if self.research_data_file:
            _dict['researchDataFile'] = self.research_data_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataset
        if self.dataset:
            _dict['dataset'] = self.dataset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SourceDatasetFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creation": ChangeInfo.from_dict(obj["creation"]) if obj.get("creation") is not None else None,
            "lastUpdate": ChangeInfo.from_dict(obj["lastUpdate"]) if obj.get("lastUpdate") is not None else None,
            "resId": obj.get("resId"),
            "searchCriterias": [SearchCriteria.from_dict(_item) for _item in obj["searchCriterias"]] if obj.get("searchCriterias") is not None else None,
            "fileSize": obj.get("fileSize"),
            "fileName": obj.get("fileName"),
            "researchDataFile": ResearchDataFile.from_dict(obj["researchDataFile"]) if obj.get("researchDataFile") is not None else None,
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "type": obj.get("type"),
            "version": obj.get("version"),
            "projectId": obj.get("projectId"),
            "dataset": SourceDataset.from_dict(obj["dataset"]) if obj.get("dataset") is not None else None,
            "errorStatusWithMessage": obj.get("errorStatusWithMessage"),
            "linkToResearchDataFile": obj.get("linkToResearchDataFile"),
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


