# coding: utf-8

"""
    hedera Solution API

    Repository for Active Research Datasets

    The version of the OpenAPI document: 1.1.0
    Contact: eresearch-opensource@unige.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hedera_api_client.models.facet_properties import FacetProperties
from hedera_api_client.models.link import Link
from typing import Optional, Set
from typing_extensions import Self

class SystemProperties(BaseModel):
    """
    A system property is defined by the back-end administrators, for the whole system.
    """ # noqa: E501
    default_license: Optional[StrictStr] = Field(default=None, description="The default license used by the system.", alias="defaultLicense")
    default_copyright_holder: Optional[StrictStr] = Field(default=None, description="The default copyright holder used by the system.", alias="defaultCopyrightHolder")
    file_size_limit: Optional[StrictStr] = Field(default=None, description="The maximum upload file size, in bytes.", alias="fileSizeLimit")
    orcid_client_id: Optional[StrictStr] = Field(default=None, description="The ORCID client ID used by the system.", alias="orcidClientId")
    search_facets: Optional[List[FacetProperties]] = Field(default=None, description="Describes facet properties used on archives search page.", alias="searchFacets")
    links: Optional[Dict[str, Link]] = Field(default=None, alias="_links")
    __properties: ClassVar[List[str]] = ["defaultLicense", "defaultCopyrightHolder", "fileSizeLimit", "orcidClientId", "searchFacets", "_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SystemProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in search_facets (list)
        _items = []
        if self.search_facets:
            for _item_search_facets in self.search_facets:
                if _item_search_facets:
                    _items.append(_item_search_facets.to_dict())
            _dict['searchFacets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in links (dict)
        _field_dict = {}
        if self.links:
            for _key_links in self.links:
                if self.links[_key_links]:
                    _field_dict[_key_links] = self.links[_key_links].to_dict()
            _dict['_links'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SystemProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultLicense": obj.get("defaultLicense"),
            "defaultCopyrightHolder": obj.get("defaultCopyrightHolder"),
            "fileSizeLimit": obj.get("fileSizeLimit"),
            "orcidClientId": obj.get("orcidClientId"),
            "searchFacets": [FacetProperties.from_dict(_item) for _item in obj["searchFacets"]] if obj.get("searchFacets") is not None else None,
            "_links": dict(
                (_k, Link.from_dict(_v))
                for _k, _v in obj["_links"].items()
            )
            if obj.get("_links") is not None
            else None
        })
        return _obj


