# Generated by Django 5.1.7 on 2025-09-08 08:07

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('localcosmos_server', '0005_servercontentimage_alt_text_servercontentimage_title_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='ServerExternalMedia',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('url', models.URLField(max_length=2000)),
                ('title', models.CharField(max_length=255)),
                ('caption', models.CharField(blank=True, max_length=255, null=True)),
                ('alt_text', models.CharField(blank=True, max_length=355, null=True)),
                ('media_type', models.CharField(choices=[('image', 'Image'), ('youtube', 'Youtube'), ('mp3', 'MP3 File'), ('wav', 'WAV File'), ('pdf', 'PDF Document'), ('website', 'Website'), ('file', 'File')], max_length=50)),
                ('media_category', models.CharField(blank=True, choices=[('video', 'Video'), ('audio', 'Audio'), ('document', 'Document')], max_length=50, null=True)),
                ('author', models.CharField(blank=True, max_length=255, null=True)),
                ('licence', models.TextField(blank=True, null=True)),
                ('position', models.IntegerField(default=0)),
                ('file_size', models.BigIntegerField(blank=True, help_text='File size in bytes', null=True)),
                ('last_checked_at', models.DateTimeField(blank=True, null=True)),
                ('is_accessible', models.BooleanField(default=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'External Media',
                'verbose_name_plural': 'External Media',
                'ordering': ['position', 'id'],
                'abstract': False,
                'unique_together': {('content_type', 'object_id', 'url')},
            },
        ),
    ]
