# Auto-generated, do not edit directly. Run `make generate_strategy_info` to update.

import enum

from pydantic import BaseModel

from exponent.core.remote_execution.types import ChatMode


class StrategyName(str, enum.Enum):
    NATURAL_EDIT = "NATURAL_EDIT"
    NATURAL_EDIT_EXPERIMENTAL = "NATURAL_EDIT_EXPERIMENTAL"
    FULL_FILE_REWRITE = "FULL_FILE_REWRITE"
    STREAMING_NATURAL_EDIT = "STREAMING_NATURAL_EDIT"
    FUNCTION_CALLING = "FUNCTION_CALLING"
    RAW_GPT = "RAW_GPT"
    STRICT_NATURAL_EDIT = "STRICT_NATURAL_EDIT"
    AGENT = "AGENT"
    AGENT_STEP = "AGENT_STEP"
    DATABASE = "DATABASE"
    DATABASE_AGENT = "DATABASE_AGENT"
    DATABASE_AGENT_STEP = "DATABASE_AGENT_STEP"
    REVIEW_FILES = "REVIEW_FILES"
    EXPLORE_CODEBASE = "EXPLORE_CODEBASE"
    GENERATE_REVIEW = "GENERATE_REVIEW"


class StrategyInfo(BaseModel):
    strategy_name: StrategyName
    display_name: str
    description: str
    disabled: bool
    display_order: int
    is_agentic: bool


CHAT_MODE_DEFAULTS: dict[ChatMode, StrategyName] = {
    ChatMode.DEFAULT: StrategyName.RAW_GPT,
    ChatMode.CLI: StrategyName.NATURAL_EDIT,
    ChatMode.CLOUD: StrategyName.NATURAL_EDIT,
    ChatMode.DATABASE: StrategyName.DATABASE,
    ChatMode.PYTHON_INTERPRETER: StrategyName.NATURAL_EDIT,
    ChatMode.WORKFLOW: StrategyName.NATURAL_EDIT,
}

STRATEGY_INFO_LIST: list[StrategyInfo] = [
    StrategyInfo(
        strategy_name=StrategyName.NATURAL_EDIT,
        display_name="Natural Edit",
        description="A natural file editing strategy.",
        disabled=False,
        display_order=0,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.NATURAL_EDIT_EXPERIMENTAL,
        display_name="Natural Edit Experimental",
        description="A natural file editing strategy.",
        disabled=True,
        display_order=0,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.STREAMING_NATURAL_EDIT,
        display_name="Streaming Natural Edit",
        description="A natural file editing strategy that streams edits.",
        disabled=True,
        display_order=1,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.FULL_FILE_REWRITE,
        display_name="Full File Rewrites",
        description="Rewrites the full file every time. Use this if your files are generally less than 300 lines.",
        disabled=False,
        display_order=2,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.FUNCTION_CALLING,
        display_name="Function Calling",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.RAW_GPT,
        display_name="Raw GPT",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.STRICT_NATURAL_EDIT,
        display_name="Natural Edit No FFR",
        description="A natural file editing strategy that does not use full file rewrites.",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.AGENT,
        display_name="Agent",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=True,
    ),
    StrategyInfo(
        strategy_name=StrategyName.AGENT_STEP,
        display_name="Agent Step",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.DATABASE,
        display_name="Database",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.DATABASE_AGENT,
        display_name="Database Agent",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=True,
    ),
    StrategyInfo(
        strategy_name=StrategyName.DATABASE_AGENT_STEP,
        display_name="Database Agent Step",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.REVIEW_FILES,
        display_name="Review Files",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.EXPLORE_CODEBASE,
        display_name="Explore Codebase",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.GENERATE_REVIEW,
        display_name="Generate Review",
        description="No description",
        disabled=True,
        display_order=99,
        is_agentic=False,
    ),
]


ENABLED_STRATEGY_INFO_LIST: list[StrategyInfo] = [
    StrategyInfo(
        strategy_name=StrategyName.NATURAL_EDIT,
        display_name="Natural Edit",
        description="A natural file editing strategy.",
        disabled=False,
        display_order=0,
        is_agentic=False,
    ),
    StrategyInfo(
        strategy_name=StrategyName.FULL_FILE_REWRITE,
        display_name="Full File Rewrites",
        description="Rewrites the full file every time. Use this if your files are generally less than 300 lines.",
        disabled=False,
        display_order=2,
        is_agentic=False,
    ),
]
