# coding: utf-8

"""
AuthorizationApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AuthorizationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_roles_role_id(self, role_id, **kwargs):
        """
        Delete an organization role.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_roles_role_id(role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_id: Role ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_roles_role_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'role_id' is set
        if ('role_id' not in params) or (params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `delete_roles_role_id`")


        resource_path = '/api/v2/authorization/roles/{roleId}'.replace('{format}', 'json')
        path_params = {}
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_user_id_roles(self, user_id, **kwargs):
        """
        Removes all the roles from the user.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_user_id_roles(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_id_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_user_id_roles`")


        resource_path = '/api/v2/users/{userId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_permissions(self, **kwargs):
        """
        Get all permissions.
        Retrieve a list of all permission defined in the system.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_permissions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: PermissionCollectionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_permissions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/authorization/permissions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PermissionCollectionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_products(self, **kwargs):
        """
        Get the list of enabled products
        Gets the list of enabled products. Some example product names are: collaborateFree, collaboratePro, communicate, and engage.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_products(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OrganizationProductEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_products" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/authorization/products'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationProductEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_roles(self, **kwargs):
        """
        Retrieve a list of all roles defined for the organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_roles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param list[str] permission: 
        :param bool user_count: 
        :return: OrganizationRoleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'permission', 'user_count']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_roles" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/authorization/roles'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'permission' in params:
            query_params['permission'] = params['permission']
        if 'user_count' in params:
            query_params['userCount'] = params['user_count']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationRoleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_roles_leftrole_id_comparedefault_rightrole_id(self, left_role_id, right_role_id, **kwargs):
        """
        Get an org role to default role comparison comparison
        Compares any organization role to a default role id and show differences

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_roles_leftrole_id_comparedefault_rightrole_id(left_role_id, right_role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str left_role_id: Left Role ID (required)
        :param str right_role_id: Right Role id (required)
        :return: DomainOrgRoleDifference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['left_role_id', 'right_role_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_roles_leftrole_id_comparedefault_rightrole_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'left_role_id' is set
        if ('left_role_id' not in params) or (params['left_role_id'] is None):
            raise ValueError("Missing the required parameter `left_role_id` when calling `get_roles_leftrole_id_comparedefault_rightrole_id`")
        # verify the required parameter 'right_role_id' is set
        if ('right_role_id' not in params) or (params['right_role_id'] is None):
            raise ValueError("Missing the required parameter `right_role_id` when calling `get_roles_leftrole_id_comparedefault_rightrole_id`")


        resource_path = '/api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId}'.replace('{format}', 'json')
        path_params = {}
        if 'left_role_id' in params:
            path_params['leftRoleId'] = params['left_role_id']
        if 'right_role_id' in params:
            path_params['rightRoleId'] = params['right_role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainOrgRoleDifference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_roles_role_id(self, role_id, **kwargs):
        """
        Get a single organization role.
        Get the organization role specified by its ID.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_roles_role_id(role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_id: Role ID (required)
        :return: DomainOrganizationRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_roles_role_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'role_id' is set
        if ('role_id' not in params) or (params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `get_roles_role_id`")


        resource_path = '/api/v2/authorization/roles/{roleId}'.replace('{format}', 'json')
        path_params = {}
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainOrganizationRole',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_id_roles(self, user_id, **kwargs):
        """
        Returns a listing of roles and permissions for a user.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_id_roles(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_id_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_id_roles`")


        resource_path = '/api/v2/users/{userId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_roles_role_id(self, role_id, **kwargs):
        """
        Patch Organization Role for needsUpdate Field
        Patch Organization Role for needsUpdate Field

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_roles_role_id(role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_id: Role ID (required)
        :param DomainOrganizationRole body: 
        :return: DomainOrganizationRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_roles_role_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'role_id' is set
        if ('role_id' not in params) or (params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `patch_roles_role_id`")


        resource_path = '/api/v2/authorization/roles/{roleId}'.replace('{format}', 'json')
        path_params = {}
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainOrganizationRole',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_roles(self, **kwargs):
        """
        Create an organization role.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_roles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DomainOrganizationRole body: 
        :return: DomainOrganizationRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_roles" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/authorization/roles'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainOrganizationRole',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_roles_default(self, **kwargs):
        """
        Restores all default roles
        This endpoint serves several purposes. 1. It provides the org with default roles. This is important for default roles that will be added after go-live (they can retroactively add the new default-role). Note: When not using a query param of force=true, it only adds the default roles not configured for the org; it does not overwrite roles. 2. Using the query param force=true, you can restore all default roles. Note: This does not have an effect on custom roles.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_roles_default(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool force: Restore default roles
        :return: OrganizationRoleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['force']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_roles_default" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/authorization/roles/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'force' in params:
            query_params['force'] = params['force']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationRoleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_roles_leftrole_id_comparedefault_rightrole_id(self, left_role_id, right_role_id, **kwargs):
        """
         Get an unsaved org role to default role comparison
        Allows users to compare their existing roles in an unsaved state to its default role

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_roles_leftrole_id_comparedefault_rightrole_id(left_role_id, right_role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str left_role_id: Left Role ID (required)
        :param str right_role_id: Right Role id (required)
        :param DomainOrganizationRole body: 
        :return: DomainOrgRoleDifference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['left_role_id', 'right_role_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_roles_leftrole_id_comparedefault_rightrole_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'left_role_id' is set
        if ('left_role_id' not in params) or (params['left_role_id'] is None):
            raise ValueError("Missing the required parameter `left_role_id` when calling `post_roles_leftrole_id_comparedefault_rightrole_id`")
        # verify the required parameter 'right_role_id' is set
        if ('right_role_id' not in params) or (params['right_role_id'] is None):
            raise ValueError("Missing the required parameter `right_role_id` when calling `post_roles_leftrole_id_comparedefault_rightrole_id`")


        resource_path = '/api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId}'.replace('{format}', 'json')
        path_params = {}
        if 'left_role_id' in params:
            path_params['leftRoleId'] = params['left_role_id']
        if 'right_role_id' in params:
            path_params['rightRoleId'] = params['right_role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainOrgRoleDifference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_roles_default(self, **kwargs):
        """
        Restore specified default roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_roles_default(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[DomainOrganizationRole] body: 
        :return: OrganizationRoleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_roles_default" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/authorization/roles/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationRoleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_roles_role_id(self, role_id, **kwargs):
        """
        Update an organization role.
        Update

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_roles_role_id(role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_id: Role ID (required)
        :param DomainOrganizationRole body: 
        :return: DomainOrganizationRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_roles_role_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'role_id' is set
        if ('role_id' not in params) or (params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `put_roles_role_id`")


        resource_path = '/api/v2/authorization/roles/{roleId}'.replace('{format}', 'json')
        path_params = {}
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainOrganizationRole',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_roles_role_id_users_add(self, role_id, **kwargs):
        """
        Sets the users for the role
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_roles_role_id_users_add(role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_id: Role ID (required)
        :param list[str] body: 
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_roles_role_id_users_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'role_id' is set
        if ('role_id' not in params) or (params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `put_roles_role_id_users_add`")


        resource_path = '/api/v2/authorization/roles/{roleId}/users/add'.replace('{format}', 'json')
        path_params = {}
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[str]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_roles_role_id_users_remove(self, role_id, **kwargs):
        """
        Removes the users from the role
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_roles_role_id_users_remove(role_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_id: Role ID (required)
        :param list[str] body: 
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_roles_role_id_users_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'role_id' is set
        if ('role_id' not in params) or (params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `put_roles_role_id_users_remove`")


        resource_path = '/api/v2/authorization/roles/{roleId}/users/remove'.replace('{format}', 'json')
        path_params = {}
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[str]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_user_id_roles(self, user_id, **kwargs):
        """
        Sets the user's roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_id_roles(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param list[str] body: 
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_user_id_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_user_id_roles`")


        resource_path = '/api/v2/users/{userId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
