# coding: utf-8

"""
ConversationsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ConversationsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_calls_call_id_participants_participant_id_consult(self, call_id, participant_id, **kwargs):
        """
        Cancel the transfer
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_calls_call_id_participants_participant_id_consult(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_calls_call_id_participants_participant_id_consult" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `delete_calls_call_id_participants_participant_id_consult`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `delete_calls_call_id_participants_participant_id_consult`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_conversation_id_participants_participant_id_codes_addcommunicationcode(self, conversation_id, participant_id, add_communication_code, **kwargs):
        """
        Delete a code used to add a communication to this participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_conversation_id_participants_participant_id_codes_addcommunicationcode(conversation_id, participant_id, add_communication_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :param str add_communication_code: addCommunicationCode (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id', 'add_communication_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_conversation_id_participants_participant_id_codes_addcommunicationcode" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_conversation_id_participants_participant_id_codes_addcommunicationcode`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `delete_conversation_id_participants_participant_id_codes_addcommunicationcode`")
        # verify the required parameter 'add_communication_code' is set
        if ('add_communication_code' not in params) or (params['add_communication_code'] is None):
            raise ValueError("Missing the required parameter `add_communication_code` when calling `delete_conversation_id_participants_participant_id_codes_addcommunicationcode`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']
        if 'add_communication_code' in params:
            path_params['addCommunicationCode'] = params['add_communication_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_emails_email_id_messages_draft_attachments_attachment_id(self, email_id, attachment_id, **kwargs):
        """
        Delete attachment from draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_emails_email_id_messages_draft_attachments_attachment_id(email_id, attachment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str attachment_id:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'attachment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_emails_email_id_messages_draft_attachments_attachment_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `delete_emails_email_id_messages_draft_attachments_attachment_id`")
        # verify the required parameter 'attachment_id' is set
        if ('attachment_id' not in params) or (params['attachment_id'] is None):
            raise ValueError("Missing the required parameter `attachment_id` when calling `delete_emails_email_id_messages_draft_attachments_attachment_id`")


        resource_path = '/api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'attachment_id' in params:
            path_params['attachmentId'] = params['attachment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callbacks(self, **kwargs):
        """
        Get callback conversations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callbacks(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: CallbackConversationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callbacks" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/callbacks'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallbackConversationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callbacks_callback_id(self, callback_id, **kwargs):
        """
        Get callback conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callbacks_callback_id(callback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callback_id:  (required)
        :return: CallbackConversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callback_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callbacks_callback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callback_id' is set
        if ('callback_id' not in params) or (params['callback_id'] is None):
            raise ValueError("Missing the required parameter `callback_id` when calling `get_callbacks_callback_id`")


        resource_path = '/api/v2/conversations/callbacks/{callbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'callback_id' in params:
            path_params['callbackId'] = params['callback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallbackConversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callbacks_callback_id_participants_participant_id_wrapup(self, callback_id, participant_id, **kwargs):
        """
        Get the wrap-up for this conversation participant. 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callbacks_callback_id_participants_participant_id_wrapup(callback_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callback_id:  (required)
        :param str participant_id:  (required)
        :param bool provisional: Indicates if the wrap-up code is provisional.
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callback_id', 'participant_id', 'provisional']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callbacks_callback_id_participants_participant_id_wrapup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callback_id' is set
        if ('callback_id' not in params) or (params['callback_id'] is None):
            raise ValueError("Missing the required parameter `callback_id` when calling `get_callbacks_callback_id_participants_participant_id_wrapup`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_callbacks_callback_id_participants_participant_id_wrapup`")


        resource_path = '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup'.replace('{format}', 'json')
        path_params = {}
        if 'callback_id' in params:
            path_params['callbackId'] = params['callback_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}
        if 'provisional' in params:
            query_params['provisional'] = params['provisional']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callbacks_callback_id_participants_participant_id_wrapupcodes(self, callback_id, participant_id, **kwargs):
        """
        Get list of wrapup codes for this conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callbacks_callback_id_participants_participant_id_wrapupcodes(callback_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callback_id:  (required)
        :param str participant_id:  (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callback_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callbacks_callback_id_participants_participant_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callback_id' is set
        if ('callback_id' not in params) or (params['callback_id'] is None):
            raise ValueError("Missing the required parameter `callback_id` when calling `get_callbacks_callback_id_participants_participant_id_wrapupcodes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_callbacks_callback_id_participants_participant_id_wrapupcodes`")


        resource_path = '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'callback_id' in params:
            path_params['callbackId'] = params['callback_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calls(self, **kwargs):
        """
        Get recent conversations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calls(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: CallConversationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/calls'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallConversationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calls_call_id(self, call_id, **kwargs):
        """
        Get call conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calls_call_id(call_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :return: CallConversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls_call_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `get_calls_call_id`")


        resource_path = '/api/v2/conversations/calls/{callId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallConversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calls_call_id_participants_participant_id_wrapup(self, call_id, participant_id, **kwargs):
        """
        Get the wrap-up for this conversation participant. 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calls_call_id_participants_participant_id_wrapup(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :param bool provisional: Indicates if the wrap-up code is provisional.
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id', 'provisional']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls_call_id_participants_participant_id_wrapup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `get_calls_call_id_participants_participant_id_wrapup`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_calls_call_id_participants_participant_id_wrapup`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}
        if 'provisional' in params:
            query_params['provisional'] = params['provisional']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calls_call_id_participants_participant_id_wrapupcodes(self, call_id, participant_id, **kwargs):
        """
        Get list of wrapup codes for this conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calls_call_id_participants_participant_id_wrapupcodes(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls_call_id_participants_participant_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `get_calls_call_id_participants_participant_id_wrapupcodes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_calls_call_id_participants_participant_id_wrapupcodes`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calls_history(self, **kwargs):
        """
        Get call history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calls_history(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str interval: Interval string; format is ISO-8601. Separate start and end times with forward slash '/'
        :return: CallConversationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'interval']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls_history" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/calls/history'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'interval' in params:
            query_params['interval'] = params['interval']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallConversationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calls_maximumconferenceparties(self, **kwargs):
        """
        Get the maximum number of participants that this user can have on a conference
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calls_maximumconferenceparties(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MaxParticipants
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls_maximumconferenceparties" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/calls/maximumconferenceparties'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MaxParticipants',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats(self, **kwargs):
        """
        Get recent chat conversations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ChatConversationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/chats'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatConversationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_chat_id(self, chat_id, **kwargs):
        """
        Get chat conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_chat_id(chat_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str chat_id:  (required)
        :return: ChatConversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chat_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_chat_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'chat_id' is set
        if ('chat_id' not in params) or (params['chat_id'] is None):
            raise ValueError("Missing the required parameter `chat_id` when calling `get_chats_chat_id`")


        resource_path = '/api/v2/conversations/chats/{chatId}'.replace('{format}', 'json')
        path_params = {}
        if 'chat_id' in params:
            path_params['chatId'] = params['chat_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatConversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_chat_id_participants_participant_id_wrapup(self, chat_id, participant_id, **kwargs):
        """
        Get the wrap-up for this conversation participant. 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_chat_id_participants_participant_id_wrapup(chat_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str chat_id:  (required)
        :param str participant_id:  (required)
        :param bool provisional: Indicates if the wrap-up code is provisional.
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chat_id', 'participant_id', 'provisional']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_chat_id_participants_participant_id_wrapup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'chat_id' is set
        if ('chat_id' not in params) or (params['chat_id'] is None):
            raise ValueError("Missing the required parameter `chat_id` when calling `get_chats_chat_id_participants_participant_id_wrapup`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_chats_chat_id_participants_participant_id_wrapup`")


        resource_path = '/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup'.replace('{format}', 'json')
        path_params = {}
        if 'chat_id' in params:
            path_params['chatId'] = params['chat_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}
        if 'provisional' in params:
            query_params['provisional'] = params['provisional']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_chat_id_participants_participant_id_wrapupcodes(self, chat_id, participant_id, **kwargs):
        """
        Get list of wrapup codes for this conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_chat_id_participants_participant_id_wrapupcodes(chat_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str chat_id:  (required)
        :param str participant_id:  (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chat_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_chat_id_participants_participant_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'chat_id' is set
        if ('chat_id' not in params) or (params['chat_id'] is None):
            raise ValueError("Missing the required parameter `chat_id` when calling `get_chats_chat_id_participants_participant_id_wrapupcodes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_chats_chat_id_participants_participant_id_wrapupcodes`")


        resource_path = '/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'chat_id' in params:
            path_params['chatId'] = params['chat_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id(self, conversation_id, **kwargs):
        """
        Get conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :return: Conversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id`")


        resource_path = '/api/v2/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Conversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id_participants_participant_id_wrapup(self, conversation_id, participant_id, **kwargs):
        """
        Get the wrap-up for this conversation participant. 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id_participants_participant_id_wrapup(conversation_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :param bool provisional: Indicates if the wrap-up code is provisional.
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id', 'provisional']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id_participants_participant_id_wrapup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id_participants_participant_id_wrapup`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_conversation_id_participants_participant_id_wrapup`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}/wrapup'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}
        if 'provisional' in params:
            query_params['provisional'] = params['provisional']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id_participants_participant_id_wrapupcodes(self, conversation_id, participant_id, **kwargs):
        """
        Get list of wrapup codes for this conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id_participants_participant_id_wrapupcodes(conversation_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id_participants_participant_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id_participants_participant_id_wrapupcodes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_conversation_id_participants_participant_id_wrapupcodes`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversations(self, **kwargs):
        """
        Get conversations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str communication_type: Call or Chat communication filtering
        :return: ConversationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['communication_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'communication_type' in params:
            query_params['communicationType'] = params['communication_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConversationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversations_conversation_id_details(self, conversation_id, **kwargs):
        """
        Get a conversation by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversations_conversation_id_details(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :return: AnalyticsConversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversations_conversation_id_details" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversations_conversation_id_details`")


        resource_path = '/api/v2/analytics/conversations/{conversationId}/details'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AnalyticsConversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails(self, **kwargs):
        """
        Get recent email conversations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EmailConversationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/emails'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailConversationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails_email_id(self, email_id, **kwargs):
        """
        Get email conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails_email_id(email_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :return: EmailConversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails_email_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_emails_email_id`")


        resource_path = '/api/v2/conversations/emails/{emailId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailConversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails_email_id_messages(self, email_id, **kwargs):
        """
        Get conversation messages
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails_email_id_messages(email_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :return: EmailMessageListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails_email_id_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_emails_email_id_messages`")


        resource_path = '/api/v2/conversations/emails/{emailId}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailMessageListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails_email_id_messages_draft(self, email_id, **kwargs):
        """
        Get conversation draft reply
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails_email_id_messages_draft(email_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :return: EmailMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails_email_id_messages_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_emails_email_id_messages_draft`")


        resource_path = '/api/v2/conversations/emails/{emailId}/messages/draft'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailMessage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails_email_id_messages_message_id(self, email_id, message_id, **kwargs):
        """
        Get conversation message
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails_email_id_messages_message_id(email_id, message_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str message_id:  (required)
        :return: EmailMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'message_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails_email_id_messages_message_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_emails_email_id_messages_message_id`")
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_emails_email_id_messages_message_id`")


        resource_path = '/api/v2/conversations/emails/{emailId}/messages/{messageId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailMessage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails_email_id_participants_participant_id_wrapup(self, email_id, participant_id, **kwargs):
        """
        Get the wrap-up for this conversation participant. 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails_email_id_participants_participant_id_wrapup(email_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str participant_id:  (required)
        :param bool provisional: Indicates if the wrap-up code is provisional.
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'participant_id', 'provisional']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails_email_id_participants_participant_id_wrapup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_emails_email_id_participants_participant_id_wrapup`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_emails_email_id_participants_participant_id_wrapup`")


        resource_path = '/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}
        if 'provisional' in params:
            query_params['provisional'] = params['provisional']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_emails_email_id_participants_participant_id_wrapupcodes(self, email_id, participant_id, **kwargs):
        """
        Get list of wrapup codes for this conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_emails_email_id_participants_participant_id_wrapupcodes(email_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str participant_id:  (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_emails_email_id_participants_participant_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_emails_email_id_participants_participant_id_wrapupcodes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `get_emails_email_id_participants_participant_id_wrapupcodes`")


        resource_path = '/api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_callbacks_callback_id_participants_participant_id(self, callback_id, participant_id, **kwargs):
        """
        Update conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_callbacks_callback_id_participants_participant_id(callback_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callback_id:  (required)
        :param str participant_id:  (required)
        :param MediaParticipantRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callback_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_callbacks_callback_id_participants_participant_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callback_id' is set
        if ('callback_id' not in params) or (params['callback_id'] is None):
            raise ValueError("Missing the required parameter `callback_id` when calling `patch_callbacks_callback_id_participants_participant_id`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_callbacks_callback_id_participants_participant_id`")


        resource_path = '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}'.replace('{format}', 'json')
        path_params = {}
        if 'callback_id' in params:
            path_params['callbackId'] = params['callback_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_callbacks_callback_id_participants_participant_id_attributes(self, callback_id, participant_id, **kwargs):
        """
        Update the attributes on a conversation participant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_callbacks_callback_id_participants_participant_id_attributes(callback_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callback_id:  (required)
        :param str participant_id:  (required)
        :param ParticipantAttributes body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callback_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_callbacks_callback_id_participants_participant_id_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callback_id' is set
        if ('callback_id' not in params) or (params['callback_id'] is None):
            raise ValueError("Missing the required parameter `callback_id` when calling `patch_callbacks_callback_id_participants_participant_id_attributes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_callbacks_callback_id_participants_participant_id_attributes`")


        resource_path = '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes'.replace('{format}', 'json')
        path_params = {}
        if 'callback_id' in params:
            path_params['callbackId'] = params['callback_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_calls_call_id(self, call_id, **kwargs):
        """
        Update conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_calls_call_id(call_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param Conversation body: Conversation
        :return: Conversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_calls_call_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `patch_calls_call_id`")


        resource_path = '/api/v2/conversations/calls/{callId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Conversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_calls_call_id_participants_participant_id(self, call_id, participant_id, **kwargs):
        """
        Update conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_calls_call_id_participants_participant_id(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :param MediaParticipantRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_calls_call_id_participants_participant_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `patch_calls_call_id_participants_participant_id`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_calls_call_id_participants_participant_id`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_calls_call_id_participants_participant_id_attributes(self, call_id, participant_id, **kwargs):
        """
        Update the attributes on a conversation participant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_calls_call_id_participants_participant_id_attributes(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :param ParticipantAttributes body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_calls_call_id_participants_participant_id_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `patch_calls_call_id_participants_participant_id_attributes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_calls_call_id_participants_participant_id_attributes`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/attributes'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_calls_call_id_participants_participant_id_consult(self, call_id, participant_id, **kwargs):
        """
        Change who can speak
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_calls_call_id_participants_participant_id_consult(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :param ConsultTransferUpdate body: new speak to
        :return: ConsultTransferResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_calls_call_id_participants_participant_id_consult" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `patch_calls_call_id_participants_participant_id_consult`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_calls_call_id_participants_participant_id_consult`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConsultTransferResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_chat_id_participants_participant_id(self, chat_id, participant_id, **kwargs):
        """
        Update conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_chat_id_participants_participant_id(chat_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str chat_id:  (required)
        :param str participant_id:  (required)
        :param MediaParticipantRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chat_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_chat_id_participants_participant_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'chat_id' is set
        if ('chat_id' not in params) or (params['chat_id'] is None):
            raise ValueError("Missing the required parameter `chat_id` when calling `patch_chats_chat_id_participants_participant_id`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_chats_chat_id_participants_participant_id`")


        resource_path = '/api/v2/conversations/chats/{chatId}/participants/{participantId}'.replace('{format}', 'json')
        path_params = {}
        if 'chat_id' in params:
            path_params['chatId'] = params['chat_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_chat_id_participants_participant_id_attributes(self, chat_id, participant_id, **kwargs):
        """
        Update the attributes on a conversation participant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_chat_id_participants_participant_id_attributes(chat_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str chat_id:  (required)
        :param str participant_id:  (required)
        :param ParticipantAttributes body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chat_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_chat_id_participants_participant_id_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'chat_id' is set
        if ('chat_id' not in params) or (params['chat_id'] is None):
            raise ValueError("Missing the required parameter `chat_id` when calling `patch_chats_chat_id_participants_participant_id_attributes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_chats_chat_id_participants_participant_id_attributes`")


        resource_path = '/api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes'.replace('{format}', 'json')
        path_params = {}
        if 'chat_id' in params:
            path_params['chatId'] = params['chat_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_conversation_id_participants_participant_id(self, conversation_id, participant_id, **kwargs):
        """
        Update a participant.
        Update conversation participant.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_conversation_id_participants_participant_id(conversation_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :param MediaParticipantRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_conversation_id_participants_participant_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `patch_conversation_id_participants_participant_id`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_conversation_id_participants_participant_id`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_conversation_id_participants_participant_id_attributes(self, conversation_id, participant_id, **kwargs):
        """
        Update the attributes on a conversation participant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_conversation_id_participants_participant_id_attributes(conversation_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :param ParticipantAttributes body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_conversation_id_participants_participant_id_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `patch_conversation_id_participants_participant_id_attributes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_conversation_id_participants_participant_id_attributes`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}/attributes'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_emails_email_id_participants_participant_id(self, email_id, participant_id, **kwargs):
        """
        Update conversation participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_emails_email_id_participants_participant_id(email_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str participant_id:  (required)
        :param MediaParticipantRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_emails_email_id_participants_participant_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `patch_emails_email_id_participants_participant_id`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_emails_email_id_participants_participant_id`")


        resource_path = '/api/v2/conversations/emails/{emailId}/participants/{participantId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_emails_email_id_participants_participant_id_attributes(self, email_id, participant_id, **kwargs):
        """
        Update the attributes on a conversation participant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_emails_email_id_participants_participant_id_attributes(email_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str participant_id:  (required)
        :param ParticipantAttributes body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_emails_email_id_participants_participant_id_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `patch_emails_email_id_participants_participant_id_attributes`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `patch_emails_email_id_participants_participant_id_attributes`")


        resource_path = '/api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_callbacks(self, **kwargs):
        """
        Create a Callback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_callbacks(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateCallbackCommand body: 
        :return: CreateCallbackResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_callbacks" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/callbacks'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CreateCallbackResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_callbacks_callback_id_participants_participant_id_replace(self, callback_id, participant_id, **kwargs):
        """
        Replace this participant with the specified user and/or address
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_callbacks_callback_id_participants_participant_id_replace(callback_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callback_id:  (required)
        :param str participant_id:  (required)
        :param TransferRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callback_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_callbacks_callback_id_participants_participant_id_replace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callback_id' is set
        if ('callback_id' not in params) or (params['callback_id'] is None):
            raise ValueError("Missing the required parameter `callback_id` when calling `post_callbacks_callback_id_participants_participant_id_replace`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_callbacks_callback_id_participants_participant_id_replace`")


        resource_path = '/api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace'.replace('{format}', 'json')
        path_params = {}
        if 'callback_id' in params:
            path_params['callbackId'] = params['callback_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calls(self, **kwargs):
        """
        Create a call conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calls(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateCallRequest body: 
        :return: CreateCallResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calls" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/calls'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CreateCallResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calls_call_id(self, call_id, **kwargs):
        """
        Add a new call to a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calls_call_id(call_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param CallCommand body: Conversation
        :return: Conversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calls_call_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `post_calls_call_id`")


        resource_path = '/api/v2/conversations/calls/{callId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Conversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calls_call_id_participants(self, call_id, **kwargs):
        """
        Add participants to a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calls_call_id_participants(call_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param Conversation body: Conversation
        :return: Conversation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calls_call_id_participants" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `post_calls_call_id_participants`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Conversation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calls_call_id_participants_participant_id_consult(self, call_id, participant_id, **kwargs):
        """
        Initiate and update consult transfer
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calls_call_id_participants_participant_id_consult(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :param ConsultTransfer body: Destination address & initial speak to
        :return: ConsultTransferResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calls_call_id_participants_participant_id_consult" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `post_calls_call_id_participants_participant_id_consult`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_calls_call_id_participants_participant_id_consult`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/consult'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConsultTransferResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calls_call_id_participants_participant_id_monitor(self, call_id, participant_id, **kwargs):
        """
        Listen in on the conversation from the point of view of a given participant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calls_call_id_participants_participant_id_monitor(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calls_call_id_participants_participant_id_monitor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `post_calls_call_id_participants_participant_id_monitor`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_calls_call_id_participants_participant_id_monitor`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/monitor'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calls_call_id_participants_participant_id_replace(self, call_id, participant_id, **kwargs):
        """
        Replace this participant with the specified user and/or address
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calls_call_id_participants_participant_id_replace(call_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_id:  (required)
        :param str participant_id:  (required)
        :param TransferRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calls_call_id_participants_participant_id_replace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_id' is set
        if ('call_id' not in params) or (params['call_id'] is None):
            raise ValueError("Missing the required parameter `call_id` when calling `post_calls_call_id_participants_participant_id_replace`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_calls_call_id_participants_participant_id_replace`")


        resource_path = '/api/v2/conversations/calls/{callId}/participants/{participantId}/replace'.replace('{format}', 'json')
        path_params = {}
        if 'call_id' in params:
            path_params['callId'] = params['call_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_chat_id_participants_participant_id_replace(self, chat_id, participant_id, **kwargs):
        """
        Replace this participant with the specified user and/or address
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_chat_id_participants_participant_id_replace(chat_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str chat_id:  (required)
        :param str participant_id:  (required)
        :param TransferRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chat_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_chat_id_participants_participant_id_replace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'chat_id' is set
        if ('chat_id' not in params) or (params['chat_id'] is None):
            raise ValueError("Missing the required parameter `chat_id` when calling `post_chats_chat_id_participants_participant_id_replace`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_chats_chat_id_participants_participant_id_replace`")


        resource_path = '/api/v2/conversations/chats/{chatId}/participants/{participantId}/replace'.replace('{format}', 'json')
        path_params = {}
        if 'chat_id' in params:
            path_params['chatId'] = params['chat_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversation_id_participants_participant_id_callbacks(self, conversation_id, participant_id, **kwargs):
        """
        Create a new callback for the specified participant on the conversation.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversation_id_participants_participant_id_callbacks(conversation_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :param CreateCallbackCommand body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversation_id_participants_participant_id_callbacks" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversation_id_participants_participant_id_callbacks`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_conversation_id_participants_participant_id_callbacks`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}/callbacks'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversation_id_participants_participant_id_replace(self, conversation_id, participant_id, **kwargs):
        """
        Replace this participant with the specified user and/or address
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversation_id_participants_participant_id_replace(conversation_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversation ID (required)
        :param str participant_id: participant ID (required)
        :param TransferRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversation_id_participants_participant_id_replace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversation_id_participants_participant_id_replace`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_conversation_id_participants_participant_id_replace`")


        resource_path = '/api/v2/conversations/{conversationId}/participants/{participantId}/replace'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversations_aggregates_query(self, **kwargs):
        """
        Query for conversation aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversations_aggregates_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AggregationQuery body: query
        :return: AggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversations_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/analytics/conversations/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversations_conversation_id_details_properties(self, conversation_id, **kwargs):
        """
        Index conversation properties
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversations_conversation_id_details_properties(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :param PropertyIndexRequest body: request
        :return: PropertyIndexRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversations_conversation_id_details_properties" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversations_conversation_id_details_properties`")


        resource_path = '/api/v2/analytics/conversations/{conversationId}/details/properties'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PropertyIndexRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversations_details_query(self, **kwargs):
        """
        Query for conversation details
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversations_details_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConversationQuery body: query
        :return: AnalyticsConversationQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversations_details_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/analytics/conversations/details/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AnalyticsConversationQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_emails_email_id_messages(self, email_id, **kwargs):
        """
        Send an email reply
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_emails_email_id_messages(email_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param EmailMessage body: Reply
        :return: EmailMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_emails_email_id_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `post_emails_email_id_messages`")


        resource_path = '/api/v2/conversations/emails/{emailId}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailMessage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_emails_email_id_participants_participant_id_replace(self, email_id, participant_id, **kwargs):
        """
        Replace this participant with the specified user and/or address
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_emails_email_id_participants_participant_id_replace(email_id, participant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param str participant_id:  (required)
        :param TransferRequest body: 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'participant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_emails_email_id_participants_participant_id_replace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `post_emails_email_id_participants_participant_id_replace`")
        # verify the required parameter 'participant_id' is set
        if ('participant_id' not in params) or (params['participant_id'] is None):
            raise ValueError("Missing the required parameter `participant_id` when calling `post_emails_email_id_participants_participant_id_replace`")


        resource_path = '/api/v2/conversations/emails/{emailId}/participants/{participantId}/replace'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']
        if 'participant_id' in params:
            path_params['participantId'] = params['participant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_faxes(self, **kwargs):
        """
        Create Fax Conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_faxes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FaxSendRequest body: Fax
        :return: FaxSendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_faxes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/conversations/faxes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FaxSendResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_emails_email_id_messages_draft(self, email_id, **kwargs):
        """
        Update conversation draft reply
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_emails_email_id_messages_draft(email_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_id:  (required)
        :param EmailMessage body: Draft
        :return: EmailMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_emails_email_id_messages_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_id' is set
        if ('email_id' not in params) or (params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `put_emails_email_id_messages_draft`")


        resource_path = '/api/v2/conversations/emails/{emailId}/messages/draft'.replace('{format}', 'json')
        path_params = {}
        if 'email_id' in params:
            path_params['emailId'] = params['email_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailMessage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
