# coding: utf-8

"""
OutboundApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class OutboundApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_callabletimesets_callabletimeset_id(self, callable_time_set_id, **kwargs):
        """
        Delete callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_callabletimesets_callabletimeset_id(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_callabletimesets_callabletimeset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `delete_callabletimesets_callabletimeset_id`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_callanalysisresponsesets_callanalysisset_id(self, call_analysis_set_id, **kwargs):
        """
        Delete a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_callanalysisresponsesets_callanalysisset_id(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_callanalysisresponsesets_callanalysisset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `delete_callanalysisresponsesets_callanalysisset_id`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_campaigns_campaign_id(self, campaign_id, **kwargs):
        """
        Delete a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_campaigns_campaign_id(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_campaigns_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_campaigns_campaign_id`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_campaigns_campaign_id_progress(self, campaign_id, **kwargs):
        """
        Reset campaign progress and recycle the campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_campaigns_campaign_id_progress(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_campaigns_campaign_id_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_campaigns_campaign_id_progress`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contactlists_contactlist_id(self, contact_list_id, **kwargs):
        """
        Delete a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contactlists_contactlist_id(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contactlists_contactlist_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_contactlists_contactlist_id`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contactlists_contactlist_id_contacts_contact_id(self, contact_list_id, contact_id, **kwargs):
        """
        Delete a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contactlists_contactlist_id_contacts_contact_id(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contactlists_contactlist_id_contacts_contact_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_contactlists_contactlist_id_contacts_contact_id`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_contactlists_contactlist_id_contacts_contact_id`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_dnclists_dnclist_id(self, dnc_list_id, **kwargs):
        """
        Delete dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_dnclists_dnclist_id(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dnclists_dnclist_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_dnclists_dnclist_id`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_rulesets_ruleset_id(self, rule_set_id, **kwargs):
        """
        Delete a Rule set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_rulesets_ruleset_id(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_rulesets_ruleset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `delete_rulesets_ruleset_id`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_schedules_campaigns_campaign_id(self, campaign_id, **kwargs):
        """
        Delete a dialer campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_schedules_campaigns_campaign_id(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_schedules_campaigns_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_schedules_campaigns_campaign_id`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_schedules_sequences_sequence_id(self, sequence_id, **kwargs):
        """
        Delete a dialer sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_schedules_sequences_sequence_id(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_schedules_sequences_sequence_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `delete_schedules_sequences_sequence_id`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_sequences_sequence_id(self, sequence_id, **kwargs):
        """
        Delete a dialer campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_sequences_sequence_id(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sequences_sequence_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `delete_sequences_sequence_id`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callabletimesets(self, **kwargs):
        """
        Query callable time set list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callabletimesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CallableTimeSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callabletimesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callabletimesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callabletimesets_callabletimeset_id(self, callable_time_set_id, **kwargs):
        """
        Get callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callabletimesets_callabletimeset_id(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callabletimesets_callabletimeset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `get_callabletimesets_callabletimeset_id`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callanalysisresponsesets(self, **kwargs):
        """
        Query a list of dialer call analysis response sets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callanalysisresponsesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ResponseSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callanalysisresponsesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callanalysisresponsesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_callanalysisresponsesets_callanalysisset_id(self, call_analysis_set_id, **kwargs):
        """
        Get a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_callanalysisresponsesets_callanalysisset_id(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_callanalysisresponsesets_callanalysisset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `get_callanalysisresponsesets_callanalysisset_id`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_campaigns(self, **kwargs):
        """
        Query a list of dialer campaigns.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str contact_list_id: Contact List ID
        :param str dnc_list_id: DNC list ID
        :param str distribution_queue_id: Distribution queue ID
        :param str edge_group_id: Edge group ID
        :param str call_analysis_response_set_id: Call analysis response set ID
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'contact_list_id', 'dnc_list_id', 'distribution_queue_id', 'edge_group_id', 'call_analysis_response_set_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'contact_list_id' in params:
            query_params['contactListId'] = params['contact_list_id']
        if 'dnc_list_id' in params:
            query_params['dncListId'] = params['dnc_list_id']
        if 'distribution_queue_id' in params:
            query_params['distributionQueueId'] = params['distribution_queue_id']
        if 'edge_group_id' in params:
            query_params['edgeGroupId'] = params['edge_group_id']
        if 'call_analysis_response_set_id' in params:
            query_params['callAnalysisResponseSetId'] = params['call_analysis_response_set_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_campaigns_campaign_id(self, campaign_id, **kwargs):
        """
        Get dialer campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_campaigns_campaign_id(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaigns_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_campaigns_campaign_id`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_campaigns_campaign_id_diagnostics(self, campaign_id, **kwargs):
        """
        Get campaign diagnostics
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_campaigns_campaign_id_diagnostics(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignDiagnostics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaigns_campaign_id_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_campaigns_campaign_id_diagnostics`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/diagnostics'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDiagnostics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_campaigns_campaign_id_progress(self, campaign_id, **kwargs):
        """
        Get campaign progress
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_campaigns_campaign_id_progress(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaigns_campaign_id_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_campaigns_campaign_id_progress`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignProgress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_campaigns_campaign_id_stats(self, campaign_id, **kwargs):
        """
        Get statistics about a Dialer Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_campaigns_campaign_id_stats(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaigns_campaign_id_stats" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_campaigns_campaign_id_stats`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/stats'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignStats',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contactlists(self, **kwargs):
        """
        Query a list of contact lists.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contactlists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ContactListEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contactlists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contactlists_contactlist_id(self, contact_list_id, **kwargs):
        """
        Get a dialer contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contactlists_contactlist_id(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contactlists_contactlist_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_contactlists_contactlist_id`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contactlists_contactlist_id_contacts_contact_id(self, contact_list_id, contact_id, **kwargs):
        """
        Get a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contactlists_contactlist_id_contacts_contact_id(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contactlists_contactlist_id_contacts_contact_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_contactlists_contactlist_id_contacts_contact_id`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_contactlists_contactlist_id_contacts_contact_id`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contactlists_contactlist_id_export(self, contact_list_id, **kwargs):
        """
        Get the URI of a contact list export.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contactlists_contactlist_id_export(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param str download: Redirect to download uri
        :return: ExportUri
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'download']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contactlists_contactlist_id_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_contactlists_contactlist_id_export`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'download' in params:
            query_params['download'] = params['download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportUri',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contactlists_contactlist_id_importstatus(self, contact_list_id, **kwargs):
        """
        Get dialer contactList import status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contactlists_contactlist_id_importstatus(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contactlists_contactlist_id_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_contactlists_contactlist_id_importstatus`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_dnclists(self, **kwargs):
        """
        Query dialer DNC lists
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dnclists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DncListEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dnclists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/dnclists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_dnclists_dnclist_id(self, dnc_list_id, **kwargs):
        """
        Get dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dnclists_dnclist_id(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dnclists_dnclist_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_dnclists_dnclist_id`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_dnclists_dnclist_id_export(self, dnc_list_id, **kwargs):
        """
        Get the URI of a DNC list export.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dnclists_dnclist_id_export(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param str download: Redirect to download uri
        :return: ExportUri
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'download']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dnclists_dnclist_id_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_dnclists_dnclist_id_export`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'download' in params:
            query_params['download'] = params['download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportUri',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_dnclists_dnclist_id_importstatus(self, dnc_list_id, **kwargs):
        """
        Get dialer dncList import status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dnclists_dnclist_id_importstatus(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dnclists_dnclist_id_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_dnclists_dnclist_id_importstatus`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_rulesets(self, **kwargs):
        """
        Query a list of Rule Sets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rulesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: RuleSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rulesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/rulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_rulesets_ruleset_id(self, rule_set_id, **kwargs):
        """
        Get a Rule Set by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rulesets_ruleset_id(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rulesets_ruleset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `get_rulesets_ruleset_id`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_schedules_campaigns(self, **kwargs):
        """
        Query for a list of dialer campaign schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_schedules_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[CampaignSchedule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedules_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignSchedule]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_schedules_campaigns_campaign_id(self, campaign_id, **kwargs):
        """
        Get a dialer campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_schedules_campaigns_campaign_id(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedules_campaigns_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_schedules_campaigns_campaign_id`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_schedules_sequences(self, **kwargs):
        """
        Query for a list of dialer sequence schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_schedules_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[SequenceSchedule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedules_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[SequenceSchedule]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_schedules_sequences_sequence_id(self, sequence_id, **kwargs):
        """
        Get a dialer sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_schedules_sequences_sequence_id(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :return: SequenceSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schedules_sequences_sequence_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `get_schedules_sequences_sequence_id`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SequenceSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_sequences(self, **kwargs):
        """
        Query a list of dialer campaign sequences.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignSequenceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequenceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_sequences_sequence_id(self, sequence_id, **kwargs):
        """
        Get a dialer campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sequences_sequence_id(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sequences_sequence_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `get_sequences_sequence_id`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_wrapupcodemappings(self, **kwargs):
        """
        Get the Dialer wrap up code mapping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_wrapupcodemappings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: WrapUpCodeMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wrapupcodemappings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/wrapupcodemappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapUpCodeMapping',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_audits(self, **kwargs):
        """
        Retrieves audits for dialer.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_audits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DialerAuditRequest body: AuditSearch
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param bool facets_only: Facets only
        :return: AuditSearchResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'page_size', 'page_number', 'sort_by', 'sort_order', 'facets_only']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_audits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/audits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'facets_only' in params:
            query_params['facetsOnly'] = params['facets_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AuditSearchResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_callabletimesets(self, **kwargs):
        """
        Create callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_callabletimesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CallableTimeSet body: DialerCallableTimeSet
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_callabletimesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callabletimesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_callanalysisresponsesets(self, **kwargs):
        """
        Create a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_callanalysisresponsesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ResponseSet body: ResponseSet
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_callanalysisresponsesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callanalysisresponsesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_campaigns(self, **kwargs):
        """
        Create a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Campaign body: Campaign
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_campaigns_campaign_id_callback_schedule(self, campaign_id, **kwargs):
        """
        Schedule a Callback for a Dialer Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_campaigns_campaign_id_callback_schedule(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param ContactCallbackRequest body: ContactCallbackRequest
        :return: ContactCallbackRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_campaigns_campaign_id_callback_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `post_campaigns_campaign_id_callback_schedule`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/callback/schedule'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactCallbackRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_campaigns_progress(self, **kwargs):
        """
        Get progress for a list of campaigns
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_campaigns_progress(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: Campaign IDs
        :return: list[CampaignProgress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_campaigns_progress" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns/progress'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignProgress]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contactlists(self, **kwargs):
        """
        Create a contact List.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contactlists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactList body: ContactList
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contactlists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contactlists_contactlist_id_contacts(self, contact_list_id, **kwargs):
        """
        Add contacts to a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contactlists_contactlist_id_contacts(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[DialerContact] body: Contact
        :param bool priority: Contact priority.  True means the contact(s) will go to the beginning of the list, false means at the end.
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body', 'priority']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contactlists_contactlist_id_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_contactlists_contactlist_id_contacts`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'priority' in params:
            query_params['priority'] = params['priority']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contactlists_contactlist_id_export(self, contact_list_id, **kwargs):
        """
        Initiate the export of a contact list.
        Returns 200 if received OK.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contactlists_contactlist_id_export(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contactlists_contactlist_id_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_contactlists_contactlist_id_export`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversations_conversation_id_dnc(self, conversation_id, **kwargs):
        """
        Add phone numbers to a Dialer DNC list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversations_conversation_id_dnc(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversations_conversation_id_dnc" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversations_conversation_id_dnc`")


        resource_path = '/api/v2/outbound/conversations/{conversationId}/dnc'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_dnclists(self, **kwargs):
        """
        Create dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_dnclists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DncList body: DncList
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dnclists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/dnclists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_dnclists_dnclist_id_export(self, dnc_list_id, **kwargs):
        """
        Initiate the export of a dnc list.
        Returns 200 if received OK.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_dnclists_dnclist_id_export(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dnclists_dnclist_id_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_dnclists_dnclist_id_export`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_dnclists_dnclist_id_phonenumbers(self, dnc_list_id, **kwargs):
        """
        Add phone numbers to a Dialer DNC list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_dnclists_dnclist_id_phonenumbers(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param list[str] body: DNC Phone Numbers
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dnclists_dnclist_id_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_dnclists_dnclist_id_phonenumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/phonenumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_rulesets(self, **kwargs):
        """
        Create a Dialer Call Analysis Response Set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_rulesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RuleSet body: RuleSet
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_rulesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/rulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_sequences(self, **kwargs):
        """
        Create a new campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CampaignSequence body: Organization
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_callabletimesets_callabletimeset_id(self, callable_time_set_id, **kwargs):
        """
        Update callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_callabletimesets_callabletimeset_id(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :param CallableTimeSet body: DialerCallableTimeSet
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_callabletimesets_callabletimeset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `put_callabletimesets_callabletimeset_id`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_callanalysisresponsesets_callanalysisset_id(self, call_analysis_set_id, **kwargs):
        """
        Update a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_callanalysisresponsesets_callanalysisset_id(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :param ResponseSet body: ResponseSet
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_callanalysisresponsesets_callanalysisset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `put_callanalysisresponsesets_callanalysisset_id`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_campaigns_campaign_id(self, campaign_id, **kwargs):
        """
        Update a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_campaigns_campaign_id(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param Campaign body: Campaign
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_campaigns_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_campaigns_campaign_id`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_campaigns_campaign_id_agents_user_id(self, campaign_id, user_id, **kwargs):
        """
        Send notification that an agent's state changed 
        New agent state.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_campaigns_campaign_id_agents_user_id(campaign_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param str user_id: Agent's user ID (required)
        :param Agent body: agent
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_campaigns_campaign_id_agents_user_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_campaigns_campaign_id_agents_user_id`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_campaigns_campaign_id_agents_user_id`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/agents/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_contactlists_contactlist_id(self, contact_list_id, **kwargs):
        """
        Update a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_contactlists_contactlist_id(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param ContactList body: ContactList
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_contactlists_contactlist_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `put_contactlists_contactlist_id`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_contactlists_contactlist_id_contacts_contact_id(self, contact_list_id, contact_id, **kwargs):
        """
        Update a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_contactlists_contactlist_id_contacts_contact_id(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :param DialerContact body: Contact
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_contactlists_contactlist_id_contacts_contact_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `put_contactlists_contactlist_id_contacts_contact_id`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_contactlists_contactlist_id_contacts_contact_id`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_dnclists_dnclist_id(self, dnc_list_id, **kwargs):
        """
        Update dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_dnclists_dnclist_id(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncList body: DncList
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_dnclists_dnclist_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `put_dnclists_dnclist_id`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_rulesets_ruleset_id(self, rule_set_id, **kwargs):
        """
        Update a RuleSet.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_rulesets_ruleset_id(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :param RuleSet body: RuleSet
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_rulesets_ruleset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `put_rulesets_ruleset_id`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_schedules_campaigns_campaign_id(self, campaign_id, **kwargs):
        """
        Update a new campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_schedules_campaigns_campaign_id(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param CampaignSchedule body: CampaignSchedule
        :return: CampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_schedules_campaigns_campaign_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_schedules_campaigns_campaign_id`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_schedules_sequences_sequence_id(self, sequence_id, **kwargs):
        """
        Update a new sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_schedules_sequences_sequence_id(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :param SequenceSchedule body: SequenceSchedule
        :return: SequenceSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_schedules_sequences_sequence_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `put_schedules_sequences_sequence_id`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SequenceSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_sequences_sequence_id(self, sequence_id, **kwargs):
        """
        Update a new campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_sequences_sequence_id(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :param CampaignSequence body: Organization
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_sequences_sequence_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `put_sequences_sequence_id`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_wrapupcodemappings(self, **kwargs):
        """
        Update the Dialer wrap up code mapping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_wrapupcodemappings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WrapUpCodeMapping body: wrapUpCodeMapping
        :return: WrapUpCodeMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_wrapupcodemappings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/wrapupcodemappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapUpCodeMapping',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
