# coding: utf-8

"""
QualityApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class QualityApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_calibrations_calibration_id(self, calibration_id, calibrator_id, **kwargs):
        """
        Delete a calibration by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_calibrations_calibration_id(calibration_id, calibrator_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibration_id: Calibration ID (required)
        :param str calibrator_id: calibratorId (required)
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibration_id', 'calibrator_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_calibrations_calibration_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibration_id' is set
        if ('calibration_id' not in params) or (params['calibration_id'] is None):
            raise ValueError("Missing the required parameter `calibration_id` when calling `delete_calibrations_calibration_id`")
        # verify the required parameter 'calibrator_id' is set
        if ('calibrator_id' not in params) or (params['calibrator_id'] is None):
            raise ValueError("Missing the required parameter `calibrator_id` when calling `delete_calibrations_calibration_id`")


        resource_path = '/api/v2/quality/calibrations/{calibrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'calibration_id' in params:
            path_params['calibrationId'] = params['calibration_id']

        query_params = {}
        if 'calibrator_id' in params:
            query_params['calibratorId'] = params['calibrator_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_conversations_conversation_id_evaluations_evaluation_id(self, conversation_id, evaluation_id, **kwargs):
        """
        Delete an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_conversations_conversation_id_evaluations_evaluation_id(conversation_id, evaluation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id:  (required)
        :param str evaluation_id:  (required)
        :param str expand: evaluatorId
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'evaluation_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_conversations_conversation_id_evaluations_evaluation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_conversations_conversation_id_evaluations_evaluation_id`")
        # verify the required parameter 'evaluation_id' is set
        if ('evaluation_id' not in params) or (params['evaluation_id'] is None):
            raise ValueError("Missing the required parameter `evaluation_id` when calling `delete_conversations_conversation_id_evaluations_evaluation_id`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'evaluation_id' in params:
            path_params['evaluationId'] = params['evaluation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_forms_form_id(self, form_id, **kwargs):
        """
        Delete an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_forms_form_id(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_forms_form_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `delete_forms_form_id`")


        resource_path = '/api/v2/quality/forms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_keywordsets(self, ids, **kwargs):
        """
        Delete keyword sets
        Bulk delete of keyword sets; this will only delete the keyword sets that match the ids specified in the query param.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_keywordsets(ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ids: A comma-delimited list of valid KeywordSet ids (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_keywordsets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ids' is set
        if ('ids' not in params) or (params['ids'] is None):
            raise ValueError("Missing the required parameter `ids` when calling `delete_keywordsets`")


        resource_path = '/api/v2/quality/keywordsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_keywordsets_keywordset_id(self, keyword_set_id, **kwargs):
        """
        Delete a keywordSet by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_keywordsets_keywordset_id(keyword_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str keyword_set_id: KeywordSet ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keyword_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_keywordsets_keywordset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'keyword_set_id' is set
        if ('keyword_set_id' not in params) or (params['keyword_set_id'] is None):
            raise ValueError("Missing the required parameter `keyword_set_id` when calling `delete_keywordsets_keywordset_id`")


        resource_path = '/api/v2/quality/keywordsets/{keywordSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'keyword_set_id' in params:
            path_params['keywordSetId'] = params['keyword_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_agents_activity(self, **kwargs):
        """
        Gets a list of Agent Activities
        Including the number of evaluations and average evaluation score

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agents_activity(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param datetime start_time: Start time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param datetime end_time: End time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param list[str] agent_user_id: user id of agent requested
        :param str evaluator_user_id: user id of the evaluator
        :param str name: name
        :param str group: group id
        :return: AgentActivityEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'start_time', 'end_time', 'agent_user_id', 'evaluator_user_id', 'name', 'group']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agents_activity" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/agents/activity'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'agent_user_id' in params:
            query_params['agentUserId'] = params['agent_user_id']
        if 'evaluator_user_id' in params:
            query_params['evaluatorUserId'] = params['evaluator_user_id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'group' in params:
            query_params['group'] = params['group']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentActivityEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calibrations(self, calibrator_id, **kwargs):
        """
        Get the list of calibrations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calibrations(calibrator_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibrator_id: user id of calibrator (required)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str conversation_id: conversation id
        :param datetime start_time: Beginning of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param datetime end_time: end of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :return: CalibrationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibrator_id', 'page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'conversation_id', 'start_time', 'end_time']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calibrations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibrator_id' is set
        if ('calibrator_id' not in params) or (params['calibrator_id'] is None):
            raise ValueError("Missing the required parameter `calibrator_id` when calling `get_calibrations`")


        resource_path = '/api/v2/quality/calibrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'calibrator_id' in params:
            query_params['calibratorId'] = params['calibrator_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CalibrationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_calibrations_calibration_id(self, calibration_id, calibrator_id, **kwargs):
        """
        Get a calibration by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_calibrations_calibration_id(calibration_id, calibrator_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibration_id: Calibration ID (required)
        :param str calibrator_id: calibratorId (required)
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibration_id', 'calibrator_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calibrations_calibration_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibration_id' is set
        if ('calibration_id' not in params) or (params['calibration_id'] is None):
            raise ValueError("Missing the required parameter `calibration_id` when calling `get_calibrations_calibration_id`")
        # verify the required parameter 'calibrator_id' is set
        if ('calibrator_id' not in params) or (params['calibrator_id'] is None):
            raise ValueError("Missing the required parameter `calibrator_id` when calling `get_calibrations_calibration_id`")


        resource_path = '/api/v2/quality/calibrations/{calibrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'calibration_id' in params:
            path_params['calibrationId'] = params['calibration_id']

        query_params = {}
        if 'calibrator_id' in params:
            query_params['calibratorId'] = params['calibrator_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversations_conversation_id_audits(self, conversation_id, **kwargs):
        """
        Get audits for conversation or recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversations_conversation_id_audits(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str recording_id: id of the recording
        :param str entity_type: entity type options: Recording, Calibration, Evaluation, Annotation
        :return: QualityAuditPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'recording_id', 'entity_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversations_conversation_id_audits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversations_conversation_id_audits`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/audits'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'recording_id' in params:
            query_params['recordingId'] = params['recording_id']
        if 'entity_type' in params:
            query_params['entityType'] = params['entity_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QualityAuditPage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversations_conversation_id_evaluations_evaluation_id(self, conversation_id, evaluation_id, **kwargs):
        """
        Get an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversations_conversation_id_evaluations_evaluation_id(conversation_id, evaluation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id:  (required)
        :param str evaluation_id:  (required)
        :param str expand: agent, evaluator, evaluationForm
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'evaluation_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversations_conversation_id_evaluations_evaluation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversations_conversation_id_evaluations_evaluation_id`")
        # verify the required parameter 'evaluation_id' is set
        if ('evaluation_id' not in params) or (params['evaluation_id'] is None):
            raise ValueError("Missing the required parameter `evaluation_id` when calling `get_conversations_conversation_id_evaluations_evaluation_id`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'evaluation_id' in params:
            path_params['evaluationId'] = params['evaluation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_evaluations_query(self, **kwargs):
        """
        Queries Evaluations and returns a paged list
        Query params must include one of conversationId, evaluatorUserId, or agentUserId

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_evaluations_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str conversation_id: conversationId specified
        :param str agent_user_id: user id of the agent
        :param str evaluator_user_id: evaluator user id
        :param str queue_id: queue id
        :param str start_time: start time of the evaluation query
        :param str end_time: end time of the evaluation query
        :param list[str] evaluation_state: evaluation state options: Pending, InProgress, Finished
        :param bool is_released: the evaluation has been released
        :param bool agent_has_read: agent has the evaluation
        :param bool expand_answer_total_scores: get the total scores for evaluations
        :param int maximum: maximum
        :return: EvaluationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'conversation_id', 'agent_user_id', 'evaluator_user_id', 'queue_id', 'start_time', 'end_time', 'evaluation_state', 'is_released', 'agent_has_read', 'expand_answer_total_scores', 'maximum']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluations_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/evaluations/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']
        if 'agent_user_id' in params:
            query_params['agentUserId'] = params['agent_user_id']
        if 'evaluator_user_id' in params:
            query_params['evaluatorUserId'] = params['evaluator_user_id']
        if 'queue_id' in params:
            query_params['queueId'] = params['queue_id']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'evaluation_state' in params:
            query_params['evaluationState'] = params['evaluation_state']
        if 'is_released' in params:
            query_params['isReleased'] = params['is_released']
        if 'agent_has_read' in params:
            query_params['agentHasRead'] = params['agent_has_read']
        if 'expand_answer_total_scores' in params:
            query_params['expandAnswerTotalScores'] = params['expand_answer_total_scores']
        if 'maximum' in params:
            query_params['maximum'] = params['maximum']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_evaluators_activity(self, **kwargs):
        """
        Get an evaluator activity
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_evaluators_activity(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param datetime start_time: The start time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param datetime end_time: The end time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param str name: Evaluator name
        :param list[str] permission: permission strings
        :param str group: group id
        :return: EvaluatorActivityEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'start_time', 'end_time', 'name', 'permission', 'group']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluators_activity" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/evaluators/activity'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'permission' in params:
            query_params['permission'] = params['permission']
        if 'group' in params:
            query_params['group'] = params['group']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluatorActivityEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_forms(self, **kwargs):
        """
        Get the list of evaluation forms
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_forms(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str expand: Expand
        :param str name: Name
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'next_page', 'previous_page', 'expand', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_forms" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/forms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_forms_form_id(self, form_id, **kwargs):
        """
        Get an evaluation form
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_forms_form_id(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_forms_form_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_forms_form_id`")


        resource_path = '/api/v2/quality/forms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_forms_form_id_versions(self, form_id, **kwargs):
        """
        Gets all the revisions for a specific evaluation.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_forms_form_id_versions(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_forms_form_id_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_forms_form_id_versions`")


        resource_path = '/api/v2/quality/forms/{formId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_keywordsets(self, **kwargs):
        """
        Get the list of keyword sets
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_keywordsets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str name: the keyword set name - used for filtering results in searches.
        :return: KeywordSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_keywordsets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/keywordsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_keywordsets_keywordset_id(self, keyword_set_id, **kwargs):
        """
        Get a keywordSet by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_keywordsets_keywordset_id(keyword_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str keyword_set_id: KeywordSet ID (required)
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keyword_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_keywordsets_keywordset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'keyword_set_id' is set
        if ('keyword_set_id' not in params) or (params['keyword_set_id'] is None):
            raise ValueError("Missing the required parameter `keyword_set_id` when calling `get_keywordsets_keywordset_id`")


        resource_path = '/api/v2/quality/keywordsets/{keywordSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'keyword_set_id' in params:
            path_params['keywordSetId'] = params['keyword_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_publishedforms(self, **kwargs):
        """
        Get the published evaluation forms.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_publishedforms(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_publishedforms" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/publishedforms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_publishedforms_form_id(self, form_id, **kwargs):
        """
        Get the published evaluation forms.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_publishedforms_form_id(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_publishedforms_form_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_publishedforms_form_id`")


        resource_path = '/api/v2/quality/publishedforms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_calibrations(self, **kwargs):
        """
        Create a calibration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_calibrations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Calibration body: calibration
        :param str expand: calibratorId
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_calibrations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/calibrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversations_conversation_id_evaluations(self, conversation_id, **kwargs):
        """
        Create an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversations_conversation_id_evaluations(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id:  (required)
        :param Evaluation body: evaluation
        :param str expand: evaluatorId
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversations_conversation_id_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversations_conversation_id_evaluations`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_evaluations_aggregates_query(self, **kwargs):
        """
        Query for evaluation aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_evaluations_aggregates_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AggregationQuery body: query
        :return: AggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_evaluations_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/analytics/evaluations/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_evaluations_scoring(self, **kwargs):
        """
        Score evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_evaluations_scoring(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationFormAndScoringSet body: evaluationAndScoringSet
        :return: EvaluationScoringSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_evaluations_scoring" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/evaluations/scoring'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationScoringSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_forms(self, **kwargs):
        """
        Create an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_forms(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationForm body: 
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_forms" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/forms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_keywordsets(self, **kwargs):
        """
        Create a Keyword Set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_keywordsets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param KeywordSet body: keywordSet
        :param str expand: queueId
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_keywordsets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/keywordsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_publishedforms(self, **kwargs):
        """
        Publish an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_publishedforms(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationForm body: 
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_publishedforms" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/publishedforms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_calibrations_calibration_id(self, calibration_id, **kwargs):
        """
        Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_calibrations_calibration_id(calibration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibration_id: Calibration ID (required)
        :param Calibration body: Calibration
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibration_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_calibrations_calibration_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibration_id' is set
        if ('calibration_id' not in params) or (params['calibration_id'] is None):
            raise ValueError("Missing the required parameter `calibration_id` when calling `put_calibrations_calibration_id`")


        resource_path = '/api/v2/quality/calibrations/{calibrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'calibration_id' in params:
            path_params['calibrationId'] = params['calibration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_conversations_conversation_id_evaluations_evaluation_id(self, conversation_id, evaluation_id, **kwargs):
        """
        Update an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_conversations_conversation_id_evaluations_evaluation_id(conversation_id, evaluation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id:  (required)
        :param str evaluation_id:  (required)
        :param Evaluation body: evaluation
        :param str expand: evaluatorId
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'evaluation_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_conversations_conversation_id_evaluations_evaluation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_conversations_conversation_id_evaluations_evaluation_id`")
        # verify the required parameter 'evaluation_id' is set
        if ('evaluation_id' not in params) or (params['evaluation_id'] is None):
            raise ValueError("Missing the required parameter `evaluation_id` when calling `put_conversations_conversation_id_evaluations_evaluation_id`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'evaluation_id' in params:
            path_params['evaluationId'] = params['evaluation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_forms_form_id(self, form_id, **kwargs):
        """
        Update an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_forms_form_id(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param EvaluationForm body: 
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_forms_form_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `put_forms_form_id`")


        resource_path = '/api/v2/quality/forms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_keywordsets_keywordset_id(self, keyword_set_id, **kwargs):
        """
        Update a keywordSet to the specified keywordSet via PUT.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_keywordsets_keywordset_id(keyword_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str keyword_set_id: KeywordSet ID (required)
        :param KeywordSet body: keywordSet
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keyword_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_keywordsets_keywordset_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'keyword_set_id' is set
        if ('keyword_set_id' not in params) or (params['keyword_set_id'] is None):
            raise ValueError("Missing the required parameter `keyword_set_id` when calling `put_keywordsets_keywordset_id`")


        resource_path = '/api/v2/quality/keywordsets/{keywordSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'keyword_set_id' in params:
            path_params['keywordSetId'] = params['keyword_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
