# coding: utf-8

"""
RecordingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class RecordingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_conversation_id_recordings_recording_id_annotations_annotation_id(self, conversation_id, recording_id, annotation_id, **kwargs):
        """
        Delete annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_conversation_id_recordings_recording_id_annotations_annotation_id(conversation_id, recording_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str annotation_id: Annotation ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'annotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_conversation_id_recordings_recording_id_annotations_annotation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_conversation_id_recordings_recording_id_annotations_annotation_id`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `delete_conversation_id_recordings_recording_id_annotations_annotation_id`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `delete_conversation_id_recordings_recording_id_annotations_annotation_id`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_mediaretentionpolicies(self, ids, **kwargs):
        """
        Delete media retention policies
        Bulk delete of media retention policies, this will only delete the polices that match the ids specified in the query param.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_mediaretentionpolicies(ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ids:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ids' is set
        if ('ids' not in params) or (params['ids'] is None):
            raise ValueError("Missing the required parameter `ids` when calling `delete_mediaretentionpolicies`")


        resource_path = '/api/v2/recording/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_mediaretentionpolicies_policy_id(self, policy_id, **kwargs):
        """
        Delete a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_mediaretentionpolicies_policy_id(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mediaretentionpolicies_policy_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `delete_mediaretentionpolicies_policy_id`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orphan_id(self, orphan_id, **kwargs):
        """
         deletes a single orphan recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orphan_id(orphan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orphan_id: Orphan ID (required)
        :return: OrphanRecording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orphan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orphan_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'orphan_id' is set
        if ('orphan_id' not in params) or (params['orphan_id'] is None):
            raise ValueError("Missing the required parameter `orphan_id` when calling `delete_orphan_id`")


        resource_path = '/api/v2/orphanrecordings/{orphanId}'.replace('{format}', 'json')
        path_params = {}
        if 'orphan_id' in params:
            path_params['orphanId'] = params['orphan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrphanRecording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id_recordings(self, conversation_id, **kwargs):
        """
        Get all of a Conversation's Recordings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id_recordings(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param int max_wait_ms: The maximum number of milliseconds to wait for the recording to be ready.
        :param str format_id: The desired media format
        :return: list[Recording]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'max_wait_ms', 'format_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id_recordings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id_recordings`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'max_wait_ms' in params:
            query_params['maxWaitMs'] = params['max_wait_ms']
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Recording]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id_recordings_recording_id(self, conversation_id, recording_id, **kwargs):
        """
        Gets a specific recording.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id_recordings_recording_id(conversation_id, recording_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str format_id: The desired media format.
        :param bool download: requesting a download format of the recording
        :param str file_name: the name of the downloaded fileName
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'format_id', 'download', 'file_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id_recordings_recording_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id_recordings_recording_id`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_id_recordings_recording_id`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']
        if 'download' in params:
            query_params['download'] = params['download']
        if 'file_name' in params:
            query_params['fileName'] = params['file_name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id_recordings_recording_id_annotations(self, conversation_id, recording_id, **kwargs):
        """
        Get annotations for recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id_recordings_recording_id_annotations(conversation_id, recording_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :return: list[Annotation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id_recordings_recording_id_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id_recordings_recording_id_annotations`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_id_recordings_recording_id_annotations`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Annotation]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_conversation_id_recordings_recording_id_annotations_annotation_id(self, conversation_id, recording_id, annotation_id, **kwargs):
        """
        Get annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_conversation_id_recordings_recording_id_annotations_annotation_id(conversation_id, recording_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str annotation_id: Annotation ID (required)
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'annotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_conversation_id_recordings_recording_id_annotations_annotation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_conversation_id_recordings_recording_id_annotations_annotation_id`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `get_conversation_id_recordings_recording_id_annotations_annotation_id`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_conversation_id_recordings_recording_id_annotations_annotation_id`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Annotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_mediaretentionpolicies(self, **kwargs):
        """
        Gets media retention policy list with query options to filter on name and enabled.
        for a less verbose response, add summary=true to this endpoint

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_mediaretentionpolicies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str name: the policy name - used for filtering results in searches.
        :param bool enabled: checks to see if policy is enabled - use enabled = true or enabled = false
        :param bool summary: provides a less verbose response of policy lists.
        :param bool has_errors: provides a way to fetch all policies with errors or policies that do not have errors
        :return: PolicyEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'name', 'enabled', 'summary', 'has_errors']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'enabled' in params:
            query_params['enabled'] = params['enabled']
        if 'summary' in params:
            query_params['summary'] = params['summary']
        if 'has_errors' in params:
            query_params['hasErrors'] = params['has_errors']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PolicyEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_mediaretentionpolicies_policy_id(self, policy_id, **kwargs):
        """
        Get a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_mediaretentionpolicies_policy_id(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mediaretentionpolicies_policy_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `get_mediaretentionpolicies_policy_id`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orphan_id(self, orphan_id, **kwargs):
        """
        Gets a single orphan recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orphan_id(orphan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str orphan_id: Orphan ID (required)
        :return: OrphanRecording
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orphan_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orphan_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'orphan_id' is set
        if ('orphan_id' not in params) or (params['orphan_id'] is None):
            raise ValueError("Missing the required parameter `orphan_id` when calling `get_orphan_id`")


        resource_path = '/api/v2/orphanrecordings/{orphanId}'.replace('{format}', 'json')
        path_params = {}
        if 'orphan_id' in params:
            path_params['orphanId'] = params['orphan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrphanRecording',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orphanrecordings(self, **kwargs):
        """
        Gets all orphan recordings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orphanrecordings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :return: OrphanRecordingListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orphanrecordings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/orphanrecordings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrphanRecordingListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_settings(self, **kwargs):
        """
        Get the Recording Settings for the Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool create_default: If no settings are found, a new one is created with default values
        :return: RecordingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_default']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'create_default' in params:
            query_params['createDefault'] = params['create_default']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_mediaretentionpolicies_policy_id(self, policy_id, **kwargs):
        """
        Patch a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_mediaretentionpolicies_policy_id(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :param Policy body: Policy
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_mediaretentionpolicies_policy_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `patch_mediaretentionpolicies_policy_id`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_conversation_id_recordings_recording_id_annotations(self, conversation_id, recording_id, **kwargs):
        """
        Create annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_conversation_id_recordings_recording_id_annotations(conversation_id, recording_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param Annotation body: annotation
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_conversation_id_recordings_recording_id_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_conversation_id_recordings_recording_id_annotations`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `post_conversation_id_recordings_recording_id_annotations`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Annotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_mediaretentionpolicies(self, **kwargs):
        """
        Create media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_mediaretentionpolicies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Policy body: Policy
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_mediaretentionpolicies" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/mediaretentionpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_conversation_id_recordings_recording_id(self, conversation_id, recording_id, body, **kwargs):
        """
        Updates the retention records on a recording.
        Currently supports updating and removing both archive and delete dates for eligible recordings. A request to change the archival date of an archived recording will result in a restoration of the recording until the new date set. Use of the query parameter 'restoreDays' is deprecated and will be removed in the next major version release. If 'restoreDays' is provided, no attempt at updating other retention data will be made. To migrate to the new usage, issuing a request with restoreDays=10 would instead set the archiveDate's time stamp in the PUT body to 10 days in the future.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_conversation_id_recordings_recording_id(conversation_id, recording_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param Recording body: recording (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_conversation_id_recordings_recording_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_conversation_id_recordings_recording_id`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `put_conversation_id_recordings_recording_id`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_conversation_id_recordings_recording_id`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_conversation_id_recordings_recording_id_annotations_annotation_id(self, conversation_id, recording_id, annotation_id, **kwargs):
        """
        Update annotation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_conversation_id_recordings_recording_id_annotations_annotation_id(conversation_id, recording_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str recording_id: Recording ID (required)
        :param str annotation_id: Annotation ID (required)
        :param Annotation body: annotation
        :return: Annotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'recording_id', 'annotation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_conversation_id_recordings_recording_id_annotations_annotation_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_conversation_id_recordings_recording_id_annotations_annotation_id`")
        # verify the required parameter 'recording_id' is set
        if ('recording_id' not in params) or (params['recording_id'] is None):
            raise ValueError("Missing the required parameter `recording_id` when calling `put_conversation_id_recordings_recording_id_annotations_annotation_id`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `put_conversation_id_recordings_recording_id_annotations_annotation_id`")


        resource_path = '/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'recording_id' in params:
            path_params['recordingId'] = params['recording_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Annotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_mediaretentionpolicies_policy_id(self, policy_id, **kwargs):
        """
        Update a media retention policy
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_mediaretentionpolicies_policy_id(policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str policy_id: Policy ID (required)
        :param Policy body: Policy
        :return: Policy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_mediaretentionpolicies_policy_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params) or (params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `put_mediaretentionpolicies_policy_id`")


        resource_path = '/api/v2/recording/mediaretentionpolicies/{policyId}'.replace('{format}', 'json')
        path_params = {}
        if 'policy_id' in params:
            path_params['policyId'] = params['policy_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Policy',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_settings(self, **kwargs):
        """
        Update the Recording Settings for the Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RecordingSettings body: 
        :return: RecordingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/recording/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RecordingSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
