# coding: utf-8

"""
RoutingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class RoutingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_email_domains_domain_id(self, domain_id, **kwargs):
        """
        Delete a domain
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_email_domains_domain_id(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: domain ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_domains_domain_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `delete_email_domains_domain_id`")


        resource_path = '/api/v2/routing/email/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_email_domains_domainname_routes_route_id(self, domain_name, route_id, **kwargs):
        """
        Delete a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_email_domains_domainname_routes_route_id(domain_name, route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param str route_id: route ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_domains_domainname_routes_route_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `delete_email_domains_domainname_routes_route_id`")
        # verify the required parameter 'route_id' is set
        if ('route_id' not in params) or (params['route_id'] is None):
            raise ValueError("Missing the required parameter `route_id` when calling `delete_email_domains_domainname_routes_route_id`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes/{routeId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']
        if 'route_id' in params:
            path_params['routeId'] = params['route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_queues_queue_id(self, queue_id, **kwargs):
        """
        Delete a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_queues_queue_id(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param bool force_delete: 
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'force_delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_queues_queue_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_queues_queue_id`")


        resource_path = '/api/v2/routing/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'force_delete' in params:
            query_params['forceDelete'] = params['force_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_queues_queue_id_users_member_id(self, queue_id, member_id, **kwargs):
        """
        Delete queue member
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_queues_queue_id_users_member_id(queue_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str member_id: Member ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'member_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_queues_queue_id_users_member_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_queues_queue_id_users_member_id`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `delete_queues_queue_id_users_member_id`")


        resource_path = '/api/v2/routing/queues/{queueId}/users/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_queues_queue_id_wrapupcodes_code_id(self, queue_id, code_id, **kwargs):
        """
        Delete a wrap-up code from a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_queues_queue_id_wrapupcodes_code_id(queue_id, code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str code_id: Code ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_queues_queue_id_wrapupcodes_code_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_queues_queue_id_wrapupcodes_code_id`")
        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `delete_queues_queue_id_wrapupcodes_code_id`")


        resource_path = '/api/v2/routing/queues/{queueId}/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_skills_skill_id(self, skill_id, **kwargs):
        """
        Delete Routing Skill
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_skills_skill_id(skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str skill_id: Skill ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skill_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_skills_skill_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `delete_skills_skill_id`")


        resource_path = '/api/v2/routing/skills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_user_id_routingskills_skill_id(self, user_id, skill_id, **kwargs):
        """
        Remove routing skill from user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_user_id_routingskills_skill_id(user_id, skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param str skill_id:  (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'skill_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_id_routingskills_skill_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_user_id_routingskills_skill_id`")
        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `delete_user_id_routingskills_skill_id`")


        resource_path = '/api/v2/users/{userId}/routingskills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_utilization(self, **kwargs):
        """
        Delete utilization settings and revert to system defaults.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_utilization(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_utilization" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/utilization'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_wrapupcodes_code_id(self, code_id, **kwargs):
        """
        Delete wrap-up code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_wrapupcodes_code_id(code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str code_id: Wrapup Code ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_wrapupcodes_code_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `delete_wrapupcodes_code_id`")


        resource_path = '/api/v2/routing/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_email_domains(self, **kwargs):
        """
        Get domains
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_email_domains(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InboundDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_domains" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/email/domains'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_email_domains_domainname_routes(self, domain_name, **kwargs):
        """
        Get routes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_email_domains_domainname_routes(domain_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :return: InboundRouteEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_domains_domainname_routes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `get_email_domains_domainname_routes`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRouteEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_email_domains_domainname_routes_route_id(self, domain_name, route_id, **kwargs):
        """
        Get a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_email_domains_domainname_routes_route_id(domain_name, route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param str route_id: route ID (required)
        :return: InboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'route_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_domains_domainname_routes_route_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `get_email_domains_domainname_routes_route_id`")
        # verify the required parameter 'route_id' is set
        if ('route_id' not in params) or (params['route_id'] is None):
            raise ValueError("Missing the required parameter `route_id` when calling `get_email_domains_domainname_routes_route_id`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes/{routeId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']
        if 'route_id' in params:
            path_params['routeId'] = params['route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_email_setup(self, **kwargs):
        """
        Get email setup
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_email_setup(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EmailSetup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_setup" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/email/setup'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailSetup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_queues(self, **kwargs):
        """
        Get list of queues.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_queues(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str name: Name
        :param bool active: Active
        :return: QueueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'name', 'active']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_queues" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/queues'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'active' in params:
            query_params['active'] = params['active']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_queues_queue_id(self, queue_id, **kwargs):
        """
        Get details about this queue.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_queues_queue_id(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :return: Queue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_queues_queue_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_queues_queue_id`")


        resource_path = '/api/v2/routing/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Queue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_queues_queue_id_estimatedwaittime(self, queue_id, **kwargs):
        """
        Get Estimated Wait Time
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_queues_queue_id_estimatedwaittime(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: queueId (required)
        :param str conversation_id: conversationId
        :return: EstimatedWaitTimePredictions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_queues_queue_id_estimatedwaittime" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_queues_queue_id_estimatedwaittime`")


        resource_path = '/api/v2/routing/queues/{queueId}/estimatedwaittime'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EstimatedWaitTimePredictions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_queues_queue_id_users(self, queue_id, **kwargs):
        """
        Get the members of this queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_queues_queue_id_users(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str expand: expand
        :param bool direct_members: Only get users that are direct members of the queue
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'page_size', 'page_number', 'sort_by', 'expand', 'direct_members']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_queues_queue_id_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_queues_queue_id_users`")


        resource_path = '/api/v2/routing/queues/{queueId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'direct_members' in params:
            query_params['directMembers'] = params['direct_members']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_queues_queue_id_wrapupcodes(self, queue_id, code_id, **kwargs):
        """
        Get the wrap-up codes for a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_queues_queue_id_wrapupcodes(queue_id, code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str code_id: Code ID (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_queues_queue_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_queues_queue_id_wrapupcodes`")
        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `get_queues_queue_id_wrapupcodes`")


        resource_path = '/api/v2/routing/queues/{queueId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_skills(self, **kwargs):
        """
        Get the list of routing skills.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_skills(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SkillEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_skills" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/skills'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SkillEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_skills_skill_id(self, skill_id, **kwargs):
        """
        Get Routing Skill
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_skills_skill_id(skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str skill_id: Skill ID (required)
        :return: RoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skill_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_skills_skill_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `get_skills_skill_id`")


        resource_path = '/api/v2/routing/skills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_id_routingskills(self, user_id, **kwargs):
        """
        List routing skills for user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_id_routingskills(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Ascending or descending sort order
        :return: UserSkillEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'page_size', 'page_number', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_id_routingskills" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_id_routingskills`")


        resource_path = '/api/v2/users/{userId}/routingskills'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserSkillEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_utilization(self, **kwargs):
        """
        Get the utilization settings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_utilization(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Utilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_utilization" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/utilization'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Utilization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_wrapupcodes(self, **kwargs):
        """
        Get list of wrapup codes.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_wrapupcodes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :return: WrapupCodeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/wrapupcodes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCodeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_wrapupcodes_code_id(self, code_id, **kwargs):
        """
        Get details about this wrap-up code.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_wrapupcodes_code_id(code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str code_id: Wrapup Code ID (required)
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wrapupcodes_code_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `get_wrapupcodes_code_id`")


        resource_path = '/api/v2/routing/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_queues_queue_id_users(self, queue_id, **kwargs):
        """
        Join or unjoin a set of users for a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_queues_queue_id_users(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[QueueMember] body: Queue Members
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_queues_queue_id_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_queues_queue_id_users`")


        resource_path = '/api/v2/routing/queues/{queueId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_queues_queue_id_users_member_id(self, queue_id, member_id, **kwargs):
        """
        Update the ring number of joined status for a User in a Queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_queues_queue_id_users_member_id(queue_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str member_id: Member ID (required)
        :param QueueMember body: Queue Member
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'member_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_queues_queue_id_users_member_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `patch_queues_queue_id_users_member_id`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `patch_queues_queue_id_users_member_id`")


        resource_path = '/api/v2/routing/queues/{queueId}/users/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_email_domains(self, **kwargs):
        """
        Create a domain
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_email_domains(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param InboundDomain body: Domain
        :return: InboundDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_email_domains" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/email/domains'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_email_domains_domainname_routes(self, domain_name, **kwargs):
        """
        Create a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_email_domains_domainname_routes(domain_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param InboundRoute body: Route
        :return: InboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_email_domains_domainname_routes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `post_email_domains_domainname_routes`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_queues(self, **kwargs):
        """
        Create queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_queues(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Queue body: Queue
        :return: Queue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_queues" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/queues'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Queue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_queues_observations_query(self, **kwargs):
        """
        Query for queue observations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_queues_observations_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ObservationQuery body: query
        :return: ObservationQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_queues_observations_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/analytics/queues/observations/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ObservationQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_queues_queue_id_users(self, queue_id, **kwargs):
        """
        Bulk add or delete up to 100 queue members
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_queues_queue_id_users(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param list[QueueMember] body: Queue Members
        :param bool delete: True to delete queue members
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body', 'delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_queues_queue_id_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `post_queues_queue_id_users`")


        resource_path = '/api/v2/routing/queues/{queueId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'delete' in params:
            query_params['delete'] = params['delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueueMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_queues_queue_id_wrapupcodes(self, queue_id, code_id, **kwargs):
        """
        Add up to 100 wrap-up codes to a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_queues_queue_id_wrapupcodes(queue_id, code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param str code_id: Code ID (required)
        :param list[WrapupCode] body: 
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'code_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_queues_queue_id_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `post_queues_queue_id_wrapupcodes`")
        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `post_queues_queue_id_wrapupcodes`")


        resource_path = '/api/v2/routing/queues/{queueId}/wrapupcodes'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_skills(self, **kwargs):
        """
        Create Skill
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_skills(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RoutingSkill body: Skill
        :return: RoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_skills" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/skills'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_user_id_routingskills(self, user_id, **kwargs):
        """
        Add routing skill to user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_user_id_routingskills(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param UserRoutingSkill body: Skill
        :return: UserRoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_user_id_routingskills" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_user_id_routingskills`")


        resource_path = '/api/v2/users/{userId}/routingskills'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserRoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_wrapupcodes(self, **kwargs):
        """
        Create a wrap-up code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_wrapupcodes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WrapupCode body: WrapupCode
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_wrapupcodes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/wrapupcodes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_email_domains_domainname_routes_route_id(self, domain_name, route_id, **kwargs):
        """
        Update a route
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_email_domains_domainname_routes_route_id(domain_name, route_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_name: email domain (required)
        :param str route_id: route ID (required)
        :param InboundRoute body: Route
        :return: InboundRoute
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_name', 'route_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_email_domains_domainname_routes_route_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params) or (params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `put_email_domains_domainname_routes_route_id`")
        # verify the required parameter 'route_id' is set
        if ('route_id' not in params) or (params['route_id'] is None):
            raise ValueError("Missing the required parameter `route_id` when calling `put_email_domains_domainname_routes_route_id`")


        resource_path = '/api/v2/routing/email/domains/{domainName}/routes/{routeId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']
        if 'route_id' in params:
            path_params['routeId'] = params['route_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InboundRoute',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_queues_queue_id(self, queue_id, **kwargs):
        """
        Update a queue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_queues_queue_id(queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: Queue ID (required)
        :param Queue body: Queue
        :return: Queue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_queues_queue_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `put_queues_queue_id`")


        resource_path = '/api/v2/routing/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Queue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_user_id_routingskills_skill_id(self, user_id, skill_id, **kwargs):
        """
        Update routing skill proficiency or state.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_id_routingskills_skill_id(user_id, skill_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param str skill_id:  (required)
        :param UserRoutingSkill body: Skill
        :return: UserRoutingSkill
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'skill_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_user_id_routingskills_skill_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_user_id_routingskills_skill_id`")
        # verify the required parameter 'skill_id' is set
        if ('skill_id' not in params) or (params['skill_id'] is None):
            raise ValueError("Missing the required parameter `skill_id` when calling `put_user_id_routingskills_skill_id`")


        resource_path = '/api/v2/users/{userId}/routingskills/{skillId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'skill_id' in params:
            path_params['skillId'] = params['skill_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserRoutingSkill',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_utilization(self, **kwargs):
        """
        Update the utilization settings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_utilization(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Utilization body: utilization
        :return: Utilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_utilization" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/routing/utilization'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Utilization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_wrapupcodes_code_id(self, code_id, **kwargs):
        """
        Update wrap-up code
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_wrapupcodes_code_id(code_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str code_id: Wrapup Code ID (required)
        :param WrapupCode body: WrapupCode
        :return: WrapupCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_wrapupcodes_code_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'code_id' is set
        if ('code_id' not in params) or (params['code_id'] is None):
            raise ValueError("Missing the required parameter `code_id` when calling `put_wrapupcodes_code_id`")


        resource_path = '/api/v2/routing/wrapupcodes/{codeId}'.replace('{format}', 'json')
        path_params = {}
        if 'code_id' in params:
            path_params['codeId'] = params['code_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapupCode',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
