# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Account(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Account - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'org_legal_name': 'str',
            'billing_address_line1': 'str',
            'billing_address_line2': 'str',
            'billing_address_city': 'str',
            'billing_address_state': 'str',
            'billing_address_zip_code': 'str',
            'billing_address_country': 'str',
            'legal_address_line1': 'str',
            'legal_address_line2': 'str',
            'legal_address_city': 'str',
            'legal_address_state': 'str',
            'legal_address_zip_code': 'str',
            'legal_address_country': 'str',
            'billing_contact_first_name': 'str',
            'billing_contact_last_name': 'str',
            'billing_contact_email': 'str',
            'billing_contact_phone': 'str',
            'purchase_order_number': 'str',
            'is_tax_exempt': 'bool',
            'currency': 'str',
            'payment_term': 'str',
            'contract_term': 'int',
            'auto_renew': 'bool',
            'enabled': 'bool',
            'min_commit_quantities': 'dict(str, int)',
            'estimated_quantities': 'dict(str, int)',
            'one_time_charges': 'list[str]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'org_legal_name': 'orgLegalName',
            'billing_address_line1': 'billingAddressLine1',
            'billing_address_line2': 'billingAddressLine2',
            'billing_address_city': 'billingAddressCity',
            'billing_address_state': 'billingAddressState',
            'billing_address_zip_code': 'billingAddressZipCode',
            'billing_address_country': 'billingAddressCountry',
            'legal_address_line1': 'legalAddressLine1',
            'legal_address_line2': 'legalAddressLine2',
            'legal_address_city': 'legalAddressCity',
            'legal_address_state': 'legalAddressState',
            'legal_address_zip_code': 'legalAddressZipCode',
            'legal_address_country': 'legalAddressCountry',
            'billing_contact_first_name': 'billingContactFirstName',
            'billing_contact_last_name': 'billingContactLastName',
            'billing_contact_email': 'billingContactEmail',
            'billing_contact_phone': 'billingContactPhone',
            'purchase_order_number': 'purchaseOrderNumber',
            'is_tax_exempt': 'isTaxExempt',
            'currency': 'currency',
            'payment_term': 'paymentTerm',
            'contract_term': 'contractTerm',
            'auto_renew': 'autoRenew',
            'enabled': 'enabled',
            'min_commit_quantities': 'minCommitQuantities',
            'estimated_quantities': 'estimatedQuantities',
            'one_time_charges': 'oneTimeCharges',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._org_legal_name = None
        self._billing_address_line1 = None
        self._billing_address_line2 = None
        self._billing_address_city = None
        self._billing_address_state = None
        self._billing_address_zip_code = None
        self._billing_address_country = None
        self._legal_address_line1 = None
        self._legal_address_line2 = None
        self._legal_address_city = None
        self._legal_address_state = None
        self._legal_address_zip_code = None
        self._legal_address_country = None
        self._billing_contact_first_name = None
        self._billing_contact_last_name = None
        self._billing_contact_email = None
        self._billing_contact_phone = None
        self._purchase_order_number = None
        self._is_tax_exempt = False
        self._currency = None
        self._payment_term = None
        self._contract_term = None
        self._auto_renew = False
        self._enabled = False
        self._min_commit_quantities = None
        self._estimated_quantities = None
        self._one_time_charges = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Account.
        The globally unique identifier for the object.

        :return: The id of this Account.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Account.
        The globally unique identifier for the object.

        :param id: The id of this Account.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Account.


        :return: The name of this Account.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Account.


        :param name: The name of this Account.
        :type: str
        """
        
        self._name = name

    @property
    def org_legal_name(self):
        """
        Gets the org_legal_name of this Account.


        :return: The org_legal_name of this Account.
        :rtype: str
        """
        return self._org_legal_name

    @org_legal_name.setter
    def org_legal_name(self, org_legal_name):
        """
        Sets the org_legal_name of this Account.


        :param org_legal_name: The org_legal_name of this Account.
        :type: str
        """
        
        self._org_legal_name = org_legal_name

    @property
    def billing_address_line1(self):
        """
        Gets the billing_address_line1 of this Account.


        :return: The billing_address_line1 of this Account.
        :rtype: str
        """
        return self._billing_address_line1

    @billing_address_line1.setter
    def billing_address_line1(self, billing_address_line1):
        """
        Sets the billing_address_line1 of this Account.


        :param billing_address_line1: The billing_address_line1 of this Account.
        :type: str
        """
        
        self._billing_address_line1 = billing_address_line1

    @property
    def billing_address_line2(self):
        """
        Gets the billing_address_line2 of this Account.


        :return: The billing_address_line2 of this Account.
        :rtype: str
        """
        return self._billing_address_line2

    @billing_address_line2.setter
    def billing_address_line2(self, billing_address_line2):
        """
        Sets the billing_address_line2 of this Account.


        :param billing_address_line2: The billing_address_line2 of this Account.
        :type: str
        """
        
        self._billing_address_line2 = billing_address_line2

    @property
    def billing_address_city(self):
        """
        Gets the billing_address_city of this Account.


        :return: The billing_address_city of this Account.
        :rtype: str
        """
        return self._billing_address_city

    @billing_address_city.setter
    def billing_address_city(self, billing_address_city):
        """
        Sets the billing_address_city of this Account.


        :param billing_address_city: The billing_address_city of this Account.
        :type: str
        """
        
        self._billing_address_city = billing_address_city

    @property
    def billing_address_state(self):
        """
        Gets the billing_address_state of this Account.


        :return: The billing_address_state of this Account.
        :rtype: str
        """
        return self._billing_address_state

    @billing_address_state.setter
    def billing_address_state(self, billing_address_state):
        """
        Sets the billing_address_state of this Account.


        :param billing_address_state: The billing_address_state of this Account.
        :type: str
        """
        
        self._billing_address_state = billing_address_state

    @property
    def billing_address_zip_code(self):
        """
        Gets the billing_address_zip_code of this Account.


        :return: The billing_address_zip_code of this Account.
        :rtype: str
        """
        return self._billing_address_zip_code

    @billing_address_zip_code.setter
    def billing_address_zip_code(self, billing_address_zip_code):
        """
        Sets the billing_address_zip_code of this Account.


        :param billing_address_zip_code: The billing_address_zip_code of this Account.
        :type: str
        """
        
        self._billing_address_zip_code = billing_address_zip_code

    @property
    def billing_address_country(self):
        """
        Gets the billing_address_country of this Account.


        :return: The billing_address_country of this Account.
        :rtype: str
        """
        return self._billing_address_country

    @billing_address_country.setter
    def billing_address_country(self, billing_address_country):
        """
        Sets the billing_address_country of this Account.


        :param billing_address_country: The billing_address_country of this Account.
        :type: str
        """
        
        self._billing_address_country = billing_address_country

    @property
    def legal_address_line1(self):
        """
        Gets the legal_address_line1 of this Account.


        :return: The legal_address_line1 of this Account.
        :rtype: str
        """
        return self._legal_address_line1

    @legal_address_line1.setter
    def legal_address_line1(self, legal_address_line1):
        """
        Sets the legal_address_line1 of this Account.


        :param legal_address_line1: The legal_address_line1 of this Account.
        :type: str
        """
        
        self._legal_address_line1 = legal_address_line1

    @property
    def legal_address_line2(self):
        """
        Gets the legal_address_line2 of this Account.


        :return: The legal_address_line2 of this Account.
        :rtype: str
        """
        return self._legal_address_line2

    @legal_address_line2.setter
    def legal_address_line2(self, legal_address_line2):
        """
        Sets the legal_address_line2 of this Account.


        :param legal_address_line2: The legal_address_line2 of this Account.
        :type: str
        """
        
        self._legal_address_line2 = legal_address_line2

    @property
    def legal_address_city(self):
        """
        Gets the legal_address_city of this Account.


        :return: The legal_address_city of this Account.
        :rtype: str
        """
        return self._legal_address_city

    @legal_address_city.setter
    def legal_address_city(self, legal_address_city):
        """
        Sets the legal_address_city of this Account.


        :param legal_address_city: The legal_address_city of this Account.
        :type: str
        """
        
        self._legal_address_city = legal_address_city

    @property
    def legal_address_state(self):
        """
        Gets the legal_address_state of this Account.


        :return: The legal_address_state of this Account.
        :rtype: str
        """
        return self._legal_address_state

    @legal_address_state.setter
    def legal_address_state(self, legal_address_state):
        """
        Sets the legal_address_state of this Account.


        :param legal_address_state: The legal_address_state of this Account.
        :type: str
        """
        
        self._legal_address_state = legal_address_state

    @property
    def legal_address_zip_code(self):
        """
        Gets the legal_address_zip_code of this Account.


        :return: The legal_address_zip_code of this Account.
        :rtype: str
        """
        return self._legal_address_zip_code

    @legal_address_zip_code.setter
    def legal_address_zip_code(self, legal_address_zip_code):
        """
        Sets the legal_address_zip_code of this Account.


        :param legal_address_zip_code: The legal_address_zip_code of this Account.
        :type: str
        """
        
        self._legal_address_zip_code = legal_address_zip_code

    @property
    def legal_address_country(self):
        """
        Gets the legal_address_country of this Account.


        :return: The legal_address_country of this Account.
        :rtype: str
        """
        return self._legal_address_country

    @legal_address_country.setter
    def legal_address_country(self, legal_address_country):
        """
        Sets the legal_address_country of this Account.


        :param legal_address_country: The legal_address_country of this Account.
        :type: str
        """
        
        self._legal_address_country = legal_address_country

    @property
    def billing_contact_first_name(self):
        """
        Gets the billing_contact_first_name of this Account.


        :return: The billing_contact_first_name of this Account.
        :rtype: str
        """
        return self._billing_contact_first_name

    @billing_contact_first_name.setter
    def billing_contact_first_name(self, billing_contact_first_name):
        """
        Sets the billing_contact_first_name of this Account.


        :param billing_contact_first_name: The billing_contact_first_name of this Account.
        :type: str
        """
        
        self._billing_contact_first_name = billing_contact_first_name

    @property
    def billing_contact_last_name(self):
        """
        Gets the billing_contact_last_name of this Account.


        :return: The billing_contact_last_name of this Account.
        :rtype: str
        """
        return self._billing_contact_last_name

    @billing_contact_last_name.setter
    def billing_contact_last_name(self, billing_contact_last_name):
        """
        Sets the billing_contact_last_name of this Account.


        :param billing_contact_last_name: The billing_contact_last_name of this Account.
        :type: str
        """
        
        self._billing_contact_last_name = billing_contact_last_name

    @property
    def billing_contact_email(self):
        """
        Gets the billing_contact_email of this Account.


        :return: The billing_contact_email of this Account.
        :rtype: str
        """
        return self._billing_contact_email

    @billing_contact_email.setter
    def billing_contact_email(self, billing_contact_email):
        """
        Sets the billing_contact_email of this Account.


        :param billing_contact_email: The billing_contact_email of this Account.
        :type: str
        """
        
        self._billing_contact_email = billing_contact_email

    @property
    def billing_contact_phone(self):
        """
        Gets the billing_contact_phone of this Account.


        :return: The billing_contact_phone of this Account.
        :rtype: str
        """
        return self._billing_contact_phone

    @billing_contact_phone.setter
    def billing_contact_phone(self, billing_contact_phone):
        """
        Sets the billing_contact_phone of this Account.


        :param billing_contact_phone: The billing_contact_phone of this Account.
        :type: str
        """
        
        self._billing_contact_phone = billing_contact_phone

    @property
    def purchase_order_number(self):
        """
        Gets the purchase_order_number of this Account.


        :return: The purchase_order_number of this Account.
        :rtype: str
        """
        return self._purchase_order_number

    @purchase_order_number.setter
    def purchase_order_number(self, purchase_order_number):
        """
        Sets the purchase_order_number of this Account.


        :param purchase_order_number: The purchase_order_number of this Account.
        :type: str
        """
        
        self._purchase_order_number = purchase_order_number

    @property
    def is_tax_exempt(self):
        """
        Gets the is_tax_exempt of this Account.


        :return: The is_tax_exempt of this Account.
        :rtype: bool
        """
        return self._is_tax_exempt

    @is_tax_exempt.setter
    def is_tax_exempt(self, is_tax_exempt):
        """
        Sets the is_tax_exempt of this Account.


        :param is_tax_exempt: The is_tax_exempt of this Account.
        :type: bool
        """
        
        self._is_tax_exempt = is_tax_exempt

    @property
    def currency(self):
        """
        Gets the currency of this Account.


        :return: The currency of this Account.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this Account.


        :param currency: The currency of this Account.
        :type: str
        """
        
        self._currency = currency

    @property
    def payment_term(self):
        """
        Gets the payment_term of this Account.


        :return: The payment_term of this Account.
        :rtype: str
        """
        return self._payment_term

    @payment_term.setter
    def payment_term(self, payment_term):
        """
        Sets the payment_term of this Account.


        :param payment_term: The payment_term of this Account.
        :type: str
        """
        
        self._payment_term = payment_term

    @property
    def contract_term(self):
        """
        Gets the contract_term of this Account.


        :return: The contract_term of this Account.
        :rtype: int
        """
        return self._contract_term

    @contract_term.setter
    def contract_term(self, contract_term):
        """
        Sets the contract_term of this Account.


        :param contract_term: The contract_term of this Account.
        :type: int
        """
        
        self._contract_term = contract_term

    @property
    def auto_renew(self):
        """
        Gets the auto_renew of this Account.


        :return: The auto_renew of this Account.
        :rtype: bool
        """
        return self._auto_renew

    @auto_renew.setter
    def auto_renew(self, auto_renew):
        """
        Sets the auto_renew of this Account.


        :param auto_renew: The auto_renew of this Account.
        :type: bool
        """
        
        self._auto_renew = auto_renew

    @property
    def enabled(self):
        """
        Gets the enabled of this Account.


        :return: The enabled of this Account.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Account.


        :param enabled: The enabled of this Account.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def min_commit_quantities(self):
        """
        Gets the min_commit_quantities of this Account.


        :return: The min_commit_quantities of this Account.
        :rtype: dict(str, int)
        """
        return self._min_commit_quantities

    @min_commit_quantities.setter
    def min_commit_quantities(self, min_commit_quantities):
        """
        Sets the min_commit_quantities of this Account.


        :param min_commit_quantities: The min_commit_quantities of this Account.
        :type: dict(str, int)
        """
        
        self._min_commit_quantities = min_commit_quantities

    @property
    def estimated_quantities(self):
        """
        Gets the estimated_quantities of this Account.


        :return: The estimated_quantities of this Account.
        :rtype: dict(str, int)
        """
        return self._estimated_quantities

    @estimated_quantities.setter
    def estimated_quantities(self, estimated_quantities):
        """
        Sets the estimated_quantities of this Account.


        :param estimated_quantities: The estimated_quantities of this Account.
        :type: dict(str, int)
        """
        
        self._estimated_quantities = estimated_quantities

    @property
    def one_time_charges(self):
        """
        Gets the one_time_charges of this Account.


        :return: The one_time_charges of this Account.
        :rtype: list[str]
        """
        return self._one_time_charges

    @one_time_charges.setter
    def one_time_charges(self, one_time_charges):
        """
        Sets the one_time_charges of this Account.


        :param one_time_charges: The one_time_charges of this Account.
        :type: list[str]
        """
        
        self._one_time_charges = one_time_charges

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Account.
        The URI for this object

        :return: The self_uri of this Account.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Account.
        The URI for this object

        :param self_uri: The self_uri of this Account.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

