# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AccountOverview(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AccountOverview - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'is_super_user': 'bool',
            'has_account_number': 'bool',
            'usage_charges': 'list[Charge]',
            'domestic_charges_total': 'int',
            'international_charges_total': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'is_super_user': 'isSuperUser',
            'has_account_number': 'hasAccountNumber',
            'usage_charges': 'usageCharges',
            'domestic_charges_total': 'domesticChargesTotal',
            'international_charges_total': 'internationalChargesTotal',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._is_super_user = False
        self._has_account_number = False
        self._usage_charges = None
        self._domestic_charges_total = None
        self._international_charges_total = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this AccountOverview.
        The globally unique identifier for the object.

        :return: The id of this AccountOverview.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AccountOverview.
        The globally unique identifier for the object.

        :param id: The id of this AccountOverview.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this AccountOverview.


        :return: The name of this AccountOverview.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AccountOverview.


        :param name: The name of this AccountOverview.
        :type: str
        """
        
        self._name = name

    @property
    def is_super_user(self):
        """
        Gets the is_super_user of this AccountOverview.


        :return: The is_super_user of this AccountOverview.
        :rtype: bool
        """
        return self._is_super_user

    @is_super_user.setter
    def is_super_user(self, is_super_user):
        """
        Sets the is_super_user of this AccountOverview.


        :param is_super_user: The is_super_user of this AccountOverview.
        :type: bool
        """
        
        self._is_super_user = is_super_user

    @property
    def has_account_number(self):
        """
        Gets the has_account_number of this AccountOverview.


        :return: The has_account_number of this AccountOverview.
        :rtype: bool
        """
        return self._has_account_number

    @has_account_number.setter
    def has_account_number(self, has_account_number):
        """
        Sets the has_account_number of this AccountOverview.


        :param has_account_number: The has_account_number of this AccountOverview.
        :type: bool
        """
        
        self._has_account_number = has_account_number

    @property
    def usage_charges(self):
        """
        Gets the usage_charges of this AccountOverview.


        :return: The usage_charges of this AccountOverview.
        :rtype: list[Charge]
        """
        return self._usage_charges

    @usage_charges.setter
    def usage_charges(self, usage_charges):
        """
        Sets the usage_charges of this AccountOverview.


        :param usage_charges: The usage_charges of this AccountOverview.
        :type: list[Charge]
        """
        
        self._usage_charges = usage_charges

    @property
    def domestic_charges_total(self):
        """
        Gets the domestic_charges_total of this AccountOverview.


        :return: The domestic_charges_total of this AccountOverview.
        :rtype: int
        """
        return self._domestic_charges_total

    @domestic_charges_total.setter
    def domestic_charges_total(self, domestic_charges_total):
        """
        Sets the domestic_charges_total of this AccountOverview.


        :param domestic_charges_total: The domestic_charges_total of this AccountOverview.
        :type: int
        """
        
        self._domestic_charges_total = domestic_charges_total

    @property
    def international_charges_total(self):
        """
        Gets the international_charges_total of this AccountOverview.


        :return: The international_charges_total of this AccountOverview.
        :rtype: int
        """
        return self._international_charges_total

    @international_charges_total.setter
    def international_charges_total(self, international_charges_total):
        """
        Sets the international_charges_total of this AccountOverview.


        :param international_charges_total: The international_charges_total of this AccountOverview.
        :type: int
        """
        
        self._international_charges_total = international_charges_total

    @property
    def self_uri(self):
        """
        Gets the self_uri of this AccountOverview.
        The URI for this object

        :return: The self_uri of this AccountOverview.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this AccountOverview.
        The URI for this object

        :param self_uri: The self_uri of this AccountOverview.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

