# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AccountStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AccountStatus - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'org_name': 'str',
            'configured': 'bool',
            'admin_uiurl': 'str',
            'third_party_account_id': 'str',
            'third_party_subscription_id': 'str',
            'third_party_subscription_non_acb_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'org_name': 'orgName',
            'configured': 'configured',
            'admin_uiurl': 'adminUIURL',
            'third_party_account_id': 'thirdPartyAccountId',
            'third_party_subscription_id': 'thirdPartySubscriptionId',
            'third_party_subscription_non_acb_id': 'thirdPartySubscriptionNonAcbId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._org_name = None
        self._configured = False
        self._admin_uiurl = None
        self._third_party_account_id = None
        self._third_party_subscription_id = None
        self._third_party_subscription_non_acb_id = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this AccountStatus.
        The globally unique identifier for the object.

        :return: The id of this AccountStatus.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AccountStatus.
        The globally unique identifier for the object.

        :param id: The id of this AccountStatus.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this AccountStatus.


        :return: The name of this AccountStatus.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AccountStatus.


        :param name: The name of this AccountStatus.
        :type: str
        """
        
        self._name = name

    @property
    def org_name(self):
        """
        Gets the org_name of this AccountStatus.


        :return: The org_name of this AccountStatus.
        :rtype: str
        """
        return self._org_name

    @org_name.setter
    def org_name(self, org_name):
        """
        Sets the org_name of this AccountStatus.


        :param org_name: The org_name of this AccountStatus.
        :type: str
        """
        
        self._org_name = org_name

    @property
    def configured(self):
        """
        Gets the configured of this AccountStatus.


        :return: The configured of this AccountStatus.
        :rtype: bool
        """
        return self._configured

    @configured.setter
    def configured(self, configured):
        """
        Sets the configured of this AccountStatus.


        :param configured: The configured of this AccountStatus.
        :type: bool
        """
        
        self._configured = configured

    @property
    def admin_uiurl(self):
        """
        Gets the admin_uiurl of this AccountStatus.


        :return: The admin_uiurl of this AccountStatus.
        :rtype: str
        """
        return self._admin_uiurl

    @admin_uiurl.setter
    def admin_uiurl(self, admin_uiurl):
        """
        Sets the admin_uiurl of this AccountStatus.


        :param admin_uiurl: The admin_uiurl of this AccountStatus.
        :type: str
        """
        
        self._admin_uiurl = admin_uiurl

    @property
    def third_party_account_id(self):
        """
        Gets the third_party_account_id of this AccountStatus.


        :return: The third_party_account_id of this AccountStatus.
        :rtype: str
        """
        return self._third_party_account_id

    @third_party_account_id.setter
    def third_party_account_id(self, third_party_account_id):
        """
        Sets the third_party_account_id of this AccountStatus.


        :param third_party_account_id: The third_party_account_id of this AccountStatus.
        :type: str
        """
        
        self._third_party_account_id = third_party_account_id

    @property
    def third_party_subscription_id(self):
        """
        Gets the third_party_subscription_id of this AccountStatus.


        :return: The third_party_subscription_id of this AccountStatus.
        :rtype: str
        """
        return self._third_party_subscription_id

    @third_party_subscription_id.setter
    def third_party_subscription_id(self, third_party_subscription_id):
        """
        Sets the third_party_subscription_id of this AccountStatus.


        :param third_party_subscription_id: The third_party_subscription_id of this AccountStatus.
        :type: str
        """
        
        self._third_party_subscription_id = third_party_subscription_id

    @property
    def third_party_subscription_non_acb_id(self):
        """
        Gets the third_party_subscription_non_acb_id of this AccountStatus.


        :return: The third_party_subscription_non_acb_id of this AccountStatus.
        :rtype: str
        """
        return self._third_party_subscription_non_acb_id

    @third_party_subscription_non_acb_id.setter
    def third_party_subscription_non_acb_id(self, third_party_subscription_non_acb_id):
        """
        Sets the third_party_subscription_non_acb_id of this AccountStatus.


        :param third_party_subscription_non_acb_id: The third_party_subscription_non_acb_id of this AccountStatus.
        :type: str
        """
        
        self._third_party_subscription_non_acb_id = third_party_subscription_non_acb_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this AccountStatus.
        The URI for this object

        :return: The self_uri of this AccountStatus.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this AccountStatus.
        The URI for this object

        :param self_uri: The self_uri of this AccountStatus.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

