# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AnalyticsConversation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AnalyticsConversation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'conversation_start': 'datetime',
            'participants': 'list[AnalyticsParticipant]',
            'evaluations': 'list[AnalyticsEvaluation]'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'conversation_start': 'conversationStart',
            'participants': 'participants',
            'evaluations': 'evaluations'
        }

        self._conversation_id = None
        self._conversation_start = None
        self._participants = None
        self._evaluations = None

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this AnalyticsConversation.


        :return: The conversation_id of this AnalyticsConversation.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this AnalyticsConversation.


        :param conversation_id: The conversation_id of this AnalyticsConversation.
        :type: str
        """
        
        self._conversation_id = conversation_id

    @property
    def conversation_start(self):
        """
        Gets the conversation_start of this AnalyticsConversation.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The conversation_start of this AnalyticsConversation.
        :rtype: datetime
        """
        return self._conversation_start

    @conversation_start.setter
    def conversation_start(self, conversation_start):
        """
        Sets the conversation_start of this AnalyticsConversation.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param conversation_start: The conversation_start of this AnalyticsConversation.
        :type: datetime
        """
        
        self._conversation_start = conversation_start

    @property
    def participants(self):
        """
        Gets the participants of this AnalyticsConversation.


        :return: The participants of this AnalyticsConversation.
        :rtype: list[AnalyticsParticipant]
        """
        return self._participants

    @participants.setter
    def participants(self, participants):
        """
        Sets the participants of this AnalyticsConversation.


        :param participants: The participants of this AnalyticsConversation.
        :type: list[AnalyticsParticipant]
        """
        
        self._participants = participants

    @property
    def evaluations(self):
        """
        Gets the evaluations of this AnalyticsConversation.


        :return: The evaluations of this AnalyticsConversation.
        :rtype: list[AnalyticsEvaluation]
        """
        return self._evaluations

    @evaluations.setter
    def evaluations(self, evaluations):
        """
        Sets the evaluations of this AnalyticsConversation.


        :param evaluations: The evaluations of this AnalyticsConversation.
        :type: list[AnalyticsEvaluation]
        """
        
        self._evaluations = evaluations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

