# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ArchitectAuditMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ArchitectAuditMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'str',
            'user': 'AuditUser',
            'timestamp': 'datetime',
            'changes': 'list[Change]',
            'entity': 'AuditEntity'
        }

        self.attribute_map = {
            'action': 'action',
            'user': 'user',
            'timestamp': 'timestamp',
            'changes': 'changes',
            'entity': 'entity'
        }

        self._action = None
        self._user = None
        self._timestamp = None
        self._changes = None
        self._entity = None

    @property
    def action(self):
        """
        Gets the action of this ArchitectAuditMessage.
        The audit action

        :return: The action of this ArchitectAuditMessage.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this ArchitectAuditMessage.
        The audit action

        :param action: The action of this ArchitectAuditMessage.
        :type: str
        """
        allowed_values = ["CHECKIN", "PUBLISH", "DELETE"]
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action`, must be one of {0}"
                .format(allowed_values)
            )

        self._action = action

    @property
    def user(self):
        """
        Gets the user of this ArchitectAuditMessage.


        :return: The user of this ArchitectAuditMessage.
        :rtype: AuditUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ArchitectAuditMessage.


        :param user: The user of this ArchitectAuditMessage.
        :type: AuditUser
        """
        
        self._user = user

    @property
    def timestamp(self):
        """
        Gets the timestamp of this ArchitectAuditMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The timestamp of this ArchitectAuditMessage.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this ArchitectAuditMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param timestamp: The timestamp of this ArchitectAuditMessage.
        :type: datetime
        """
        
        self._timestamp = timestamp

    @property
    def changes(self):
        """
        Gets the changes of this ArchitectAuditMessage.


        :return: The changes of this ArchitectAuditMessage.
        :rtype: list[Change]
        """
        return self._changes

    @changes.setter
    def changes(self, changes):
        """
        Sets the changes of this ArchitectAuditMessage.


        :param changes: The changes of this ArchitectAuditMessage.
        :type: list[Change]
        """
        
        self._changes = changes

    @property
    def entity(self):
        """
        Gets the entity of this ArchitectAuditMessage.


        :return: The entity of this ArchitectAuditMessage.
        :rtype: AuditEntity
        """
        return self._entity

    @entity.setter
    def entity(self, entity):
        """
        Sets the entity of this ArchitectAuditMessage.


        :param entity: The entity of this ArchitectAuditMessage.
        :type: AuditEntity
        """
        
        self._entity = entity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

