# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Asset(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Asset - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'download_url': 'str',
            'file_size_bytes': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'download_url': 'downloadUrl',
            'file_size_bytes': 'fileSizeBytes',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._download_url = None
        self._file_size_bytes = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Asset.
        The globally unique identifier for the object.

        :return: The id of this Asset.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Asset.
        The globally unique identifier for the object.

        :param id: The id of this Asset.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Asset.


        :return: The name of this Asset.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Asset.


        :param name: The name of this Asset.
        :type: str
        """
        
        self._name = name

    @property
    def download_url(self):
        """
        Gets the download_url of this Asset.


        :return: The download_url of this Asset.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url):
        """
        Sets the download_url of this Asset.


        :param download_url: The download_url of this Asset.
        :type: str
        """
        
        self._download_url = download_url

    @property
    def file_size_bytes(self):
        """
        Gets the file_size_bytes of this Asset.


        :return: The file_size_bytes of this Asset.
        :rtype: int
        """
        return self._file_size_bytes

    @file_size_bytes.setter
    def file_size_bytes(self, file_size_bytes):
        """
        Sets the file_size_bytes of this Asset.


        :param file_size_bytes: The file_size_bytes of this Asset.
        :type: int
        """
        
        self._file_size_bytes = file_size_bytes

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Asset.
        The URI for this object

        :return: The self_uri of this Asset.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Asset.
        The URI for this object

        :param self_uri: The self_uri of this Asset.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

