# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AssociatedDocument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AssociatedDocument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'document': 'Document',
            'document_association_type': 'str'
        }

        self.attribute_map = {
            'document': 'document',
            'document_association_type': 'documentAssociationType'
        }

        self._document = None
        self._document_association_type = None

    @property
    def document(self):
        """
        Gets the document of this AssociatedDocument.
        the document associated with the workitem

        :return: The document of this AssociatedDocument.
        :rtype: Document
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this AssociatedDocument.
        the document associated with the workitem

        :param document: The document of this AssociatedDocument.
        :type: Document
        """
        
        self._document = document

    @property
    def document_association_type(self):
        """
        Gets the document_association_type of this AssociatedDocument.
        the document association type

        :return: The document_association_type of this AssociatedDocument.
        :rtype: str
        """
        return self._document_association_type

    @document_association_type.setter
    def document_association_type(self, document_association_type):
        """
        Sets the document_association_type of this AssociatedDocument.
        the document association type

        :param document_association_type: The document_association_type of this AssociatedDocument.
        :type: str
        """
        allowed_values = ["UNKNOWN", "MAIN", "SECONDARY"]
        if document_association_type not in allowed_values:
            raise ValueError(
                "Invalid value for `document_association_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._document_association_type = document_association_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

