# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AuthzGrant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AuthzGrant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'permission_context': 'AuthzPermissionContext',
            'role': 'AuthzGrantRole',
            'grant_made_at': 'datetime'
        }

        self.attribute_map = {
            'permission_context': 'permissionContext',
            'role': 'role',
            'grant_made_at': 'grantMadeAt'
        }

        self._permission_context = None
        self._role = None
        self._grant_made_at = None

    @property
    def permission_context(self):
        """
        Gets the permission_context of this AuthzGrant.


        :return: The permission_context of this AuthzGrant.
        :rtype: AuthzPermissionContext
        """
        return self._permission_context

    @permission_context.setter
    def permission_context(self, permission_context):
        """
        Sets the permission_context of this AuthzGrant.


        :param permission_context: The permission_context of this AuthzGrant.
        :type: AuthzPermissionContext
        """
        
        self._permission_context = permission_context

    @property
    def role(self):
        """
        Gets the role of this AuthzGrant.


        :return: The role of this AuthzGrant.
        :rtype: AuthzGrantRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this AuthzGrant.


        :param role: The role of this AuthzGrant.
        :type: AuthzGrantRole
        """
        
        self._role = role

    @property
    def grant_made_at(self):
        """
        Gets the grant_made_at of this AuthzGrant.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The grant_made_at of this AuthzGrant.
        :rtype: datetime
        """
        return self._grant_made_at

    @grant_made_at.setter
    def grant_made_at(self, grant_made_at):
        """
        Sets the grant_made_at of this AuthzGrant.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param grant_made_at: The grant_made_at of this AuthzGrant.
        :type: datetime
        """
        
        self._grant_made_at = grant_made_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

