# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AvailableAdditionalService(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AvailableAdditionalService - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'part_number': 'str',
            'required_for_products': 'list[str]',
            'available_for_products': 'list[str]',
            'default_for_products': 'list[str]',
            'exclusive_from_products': 'list[str]',
            'rate': 'Rate',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'part_number': 'partNumber',
            'required_for_products': 'requiredForProducts',
            'available_for_products': 'availableForProducts',
            'default_for_products': 'defaultForProducts',
            'exclusive_from_products': 'exclusiveFromProducts',
            'rate': 'rate',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._part_number = None
        self._required_for_products = None
        self._available_for_products = None
        self._default_for_products = None
        self._exclusive_from_products = None
        self._rate = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this AvailableAdditionalService.
        The globally unique identifier for the object.

        :return: The id of this AvailableAdditionalService.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AvailableAdditionalService.
        The globally unique identifier for the object.

        :param id: The id of this AvailableAdditionalService.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this AvailableAdditionalService.


        :return: The name of this AvailableAdditionalService.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AvailableAdditionalService.


        :param name: The name of this AvailableAdditionalService.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this AvailableAdditionalService.
        The description of this additional service.

        :return: The description of this AvailableAdditionalService.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AvailableAdditionalService.
        The description of this additional service.

        :param description: The description of this AvailableAdditionalService.
        :type: str
        """
        
        self._description = description

    @property
    def part_number(self):
        """
        Gets the part_number of this AvailableAdditionalService.
        The part number of this additional service.

        :return: The part_number of this AvailableAdditionalService.
        :rtype: str
        """
        return self._part_number

    @part_number.setter
    def part_number(self, part_number):
        """
        Sets the part_number of this AvailableAdditionalService.
        The part number of this additional service.

        :param part_number: The part_number of this AvailableAdditionalService.
        :type: str
        """
        
        self._part_number = part_number

    @property
    def required_for_products(self):
        """
        Gets the required_for_products of this AvailableAdditionalService.
        The list of products which require this additional service.

        :return: The required_for_products of this AvailableAdditionalService.
        :rtype: list[str]
        """
        return self._required_for_products

    @required_for_products.setter
    def required_for_products(self, required_for_products):
        """
        Sets the required_for_products of this AvailableAdditionalService.
        The list of products which require this additional service.

        :param required_for_products: The required_for_products of this AvailableAdditionalService.
        :type: list[str]
        """
        
        self._required_for_products = required_for_products

    @property
    def available_for_products(self):
        """
        Gets the available_for_products of this AvailableAdditionalService.
        The list of products for which this additional service is available.

        :return: The available_for_products of this AvailableAdditionalService.
        :rtype: list[str]
        """
        return self._available_for_products

    @available_for_products.setter
    def available_for_products(self, available_for_products):
        """
        Sets the available_for_products of this AvailableAdditionalService.
        The list of products for which this additional service is available.

        :param available_for_products: The available_for_products of this AvailableAdditionalService.
        :type: list[str]
        """
        
        self._available_for_products = available_for_products

    @property
    def default_for_products(self):
        """
        Gets the default_for_products of this AvailableAdditionalService.
        The list of products which have this additional service by default.

        :return: The default_for_products of this AvailableAdditionalService.
        :rtype: list[str]
        """
        return self._default_for_products

    @default_for_products.setter
    def default_for_products(self, default_for_products):
        """
        Sets the default_for_products of this AvailableAdditionalService.
        The list of products which have this additional service by default.

        :param default_for_products: The default_for_products of this AvailableAdditionalService.
        :type: list[str]
        """
        
        self._default_for_products = default_for_products

    @property
    def exclusive_from_products(self):
        """
        Gets the exclusive_from_products of this AvailableAdditionalService.
        The list of additional services which are not compatible with this additional service.

        :return: The exclusive_from_products of this AvailableAdditionalService.
        :rtype: list[str]
        """
        return self._exclusive_from_products

    @exclusive_from_products.setter
    def exclusive_from_products(self, exclusive_from_products):
        """
        Sets the exclusive_from_products of this AvailableAdditionalService.
        The list of additional services which are not compatible with this additional service.

        :param exclusive_from_products: The exclusive_from_products of this AvailableAdditionalService.
        :type: list[str]
        """
        
        self._exclusive_from_products = exclusive_from_products

    @property
    def rate(self):
        """
        Gets the rate of this AvailableAdditionalService.
        The rate of this additional service.

        :return: The rate of this AvailableAdditionalService.
        :rtype: Rate
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """
        Sets the rate of this AvailableAdditionalService.
        The rate of this additional service.

        :param rate: The rate of this AvailableAdditionalService.
        :type: Rate
        """
        
        self._rate = rate

    @property
    def self_uri(self):
        """
        Gets the self_uri of this AvailableAdditionalService.
        The URI for this object

        :return: The self_uri of this AvailableAdditionalService.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this AvailableAdditionalService.
        The URI for this object

        :param self_uri: The self_uri of this AvailableAdditionalService.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

