# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class BasicTransform(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BasicTransform - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'replaces': 'list[TransformLens]',
            'entity_path': 'list[str]'
        }

        self.attribute_map = {
            'replaces': 'replaces',
            'entity_path': 'entityPath'
        }

        self._replaces = None
        self._entity_path = None

    @property
    def replaces(self):
        """
        Gets the replaces of this BasicTransform.


        :return: The replaces of this BasicTransform.
        :rtype: list[TransformLens]
        """
        return self._replaces

    @replaces.setter
    def replaces(self, replaces):
        """
        Sets the replaces of this BasicTransform.


        :param replaces: The replaces of this BasicTransform.
        :type: list[TransformLens]
        """
        
        self._replaces = replaces

    @property
    def entity_path(self):
        """
        Gets the entity_path of this BasicTransform.


        :return: The entity_path of this BasicTransform.
        :rtype: list[str]
        """
        return self._entity_path

    @entity_path.setter
    def entity_path(self, entity_path):
        """
        Sets the entity_path of this BasicTransform.


        :param entity_path: The entity_path of this BasicTransform.
        :type: list[str]
        """
        
        self._entity_path = entity_path

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

