# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class BillingAddress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BillingAddress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'street': 'str',
            'city': 'str',
            'country_name': 'str',
            'state_name': 'str',
            'postal_code': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'street': 'street',
            'city': 'city',
            'country_name': 'countryName',
            'state_name': 'stateName',
            'postal_code': 'postalCode',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._street = None
        self._city = None
        self._country_name = None
        self._state_name = None
        self._postal_code = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this BillingAddress.
        The globally unique identifier for the object.

        :return: The id of this BillingAddress.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BillingAddress.
        The globally unique identifier for the object.

        :param id: The id of this BillingAddress.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this BillingAddress.


        :return: The name of this BillingAddress.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BillingAddress.


        :param name: The name of this BillingAddress.
        :type: str
        """
        
        self._name = name

    @property
    def street(self):
        """
        Gets the street of this BillingAddress.


        :return: The street of this BillingAddress.
        :rtype: str
        """
        return self._street

    @street.setter
    def street(self, street):
        """
        Sets the street of this BillingAddress.


        :param street: The street of this BillingAddress.
        :type: str
        """
        
        self._street = street

    @property
    def city(self):
        """
        Gets the city of this BillingAddress.


        :return: The city of this BillingAddress.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """
        Sets the city of this BillingAddress.


        :param city: The city of this BillingAddress.
        :type: str
        """
        
        self._city = city

    @property
    def country_name(self):
        """
        Gets the country_name of this BillingAddress.


        :return: The country_name of this BillingAddress.
        :rtype: str
        """
        return self._country_name

    @country_name.setter
    def country_name(self, country_name):
        """
        Sets the country_name of this BillingAddress.


        :param country_name: The country_name of this BillingAddress.
        :type: str
        """
        
        self._country_name = country_name

    @property
    def state_name(self):
        """
        Gets the state_name of this BillingAddress.


        :return: The state_name of this BillingAddress.
        :rtype: str
        """
        return self._state_name

    @state_name.setter
    def state_name(self, state_name):
        """
        Sets the state_name of this BillingAddress.


        :param state_name: The state_name of this BillingAddress.
        :type: str
        """
        
        self._state_name = state_name

    @property
    def postal_code(self):
        """
        Gets the postal_code of this BillingAddress.


        :return: The postal_code of this BillingAddress.
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code):
        """
        Sets the postal_code of this BillingAddress.


        :param postal_code: The postal_code of this BillingAddress.
        :type: str
        """
        
        self._postal_code = postal_code

    @property
    def self_uri(self):
        """
        Gets the self_uri of this BillingAddress.
        The URI for this object

        :return: The self_uri of this BillingAddress.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this BillingAddress.
        The URI for this object

        :param self_uri: The self_uri of this BillingAddress.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

