# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class BillingTaskResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BillingTaskResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'task_type': 'str',
            'status': 'str',
            'result_id': 'str',
            'result_uri': 'str',
            'result_download_url': 'str',
            'error_code': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'task_type': 'taskType',
            'status': 'status',
            'result_id': 'resultId',
            'result_uri': 'resultUri',
            'result_download_url': 'resultDownloadUrl',
            'error_code': 'errorCode',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._task_type = None
        self._status = None
        self._result_id = None
        self._result_uri = None
        self._result_download_url = None
        self._error_code = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this BillingTaskResult.
        The globally unique identifier for the object.

        :return: The id of this BillingTaskResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BillingTaskResult.
        The globally unique identifier for the object.

        :param id: The id of this BillingTaskResult.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this BillingTaskResult.


        :return: The name of this BillingTaskResult.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BillingTaskResult.


        :param name: The name of this BillingTaskResult.
        :type: str
        """
        
        self._name = name

    @property
    def task_type(self):
        """
        Gets the task_type of this BillingTaskResult.


        :return: The task_type of this BillingTaskResult.
        :rtype: str
        """
        return self._task_type

    @task_type.setter
    def task_type(self, task_type):
        """
        Sets the task_type of this BillingTaskResult.


        :param task_type: The task_type of this BillingTaskResult.
        :type: str
        """
        allowed_values = ["GENERATE_PCV_USAGE_REPORT", "GENERATE_BILLABLE_USAGE_REPORT", "GENERATE_CONCURRENT_USAGE_REPORT", "CREATE_QUOTE", "CREATE_SALESFORCE_ACCOUNT", "SUBMIT_QUOTE", "GENERATE_CONTRACT", "OTHER"]
        if task_type not in allowed_values:
            raise ValueError(
                "Invalid value for `task_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._task_type = task_type

    @property
    def status(self):
        """
        Gets the status of this BillingTaskResult.


        :return: The status of this BillingTaskResult.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this BillingTaskResult.


        :param status: The status of this BillingTaskResult.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "SUCCEEDED", "FAILED"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )

        self._status = status

    @property
    def result_id(self):
        """
        Gets the result_id of this BillingTaskResult.


        :return: The result_id of this BillingTaskResult.
        :rtype: str
        """
        return self._result_id

    @result_id.setter
    def result_id(self, result_id):
        """
        Sets the result_id of this BillingTaskResult.


        :param result_id: The result_id of this BillingTaskResult.
        :type: str
        """
        
        self._result_id = result_id

    @property
    def result_uri(self):
        """
        Gets the result_uri of this BillingTaskResult.


        :return: The result_uri of this BillingTaskResult.
        :rtype: str
        """
        return self._result_uri

    @result_uri.setter
    def result_uri(self, result_uri):
        """
        Sets the result_uri of this BillingTaskResult.


        :param result_uri: The result_uri of this BillingTaskResult.
        :type: str
        """
        
        self._result_uri = result_uri

    @property
    def result_download_url(self):
        """
        Gets the result_download_url of this BillingTaskResult.


        :return: The result_download_url of this BillingTaskResult.
        :rtype: str
        """
        return self._result_download_url

    @result_download_url.setter
    def result_download_url(self, result_download_url):
        """
        Sets the result_download_url of this BillingTaskResult.


        :param result_download_url: The result_download_url of this BillingTaskResult.
        :type: str
        """
        
        self._result_download_url = result_download_url

    @property
    def error_code(self):
        """
        Gets the error_code of this BillingTaskResult.


        :return: The error_code of this BillingTaskResult.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this BillingTaskResult.


        :param error_code: The error_code of this BillingTaskResult.
        :type: str
        """
        
        self._error_code = error_code

    @property
    def self_uri(self):
        """
        Gets the self_uri of this BillingTaskResult.
        The URI for this object

        :return: The self_uri of this BillingTaskResult.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this BillingTaskResult.
        The URI for this object

        :param self_uri: The self_uri of this BillingTaskResult.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

