# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Carrier(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Carrier - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'account_manager': 'AccountManager',
            'support': 'Support',
            'noc_support': 'NocSupport',
            'services': 'list[Service]',
            'self_uri': 'str',
            'address': 'CarrierAddress'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'account_manager': 'accountManager',
            'support': 'support',
            'noc_support': 'nocSupport',
            'services': 'services',
            'self_uri': 'selfUri',
            'address': 'address'
        }

        self._id = None
        self._name = None
        self._account_manager = None
        self._support = None
        self._noc_support = None
        self._services = None
        self._self_uri = None
        self._address = None

    @property
    def id(self):
        """
        Gets the id of this Carrier.
        The globally unique identifier for the object.

        :return: The id of this Carrier.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Carrier.
        The globally unique identifier for the object.

        :param id: The id of this Carrier.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Carrier.


        :return: The name of this Carrier.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Carrier.


        :param name: The name of this Carrier.
        :type: str
        """
        
        self._name = name

    @property
    def account_manager(self):
        """
        Gets the account_manager of this Carrier.


        :return: The account_manager of this Carrier.
        :rtype: AccountManager
        """
        return self._account_manager

    @account_manager.setter
    def account_manager(self, account_manager):
        """
        Sets the account_manager of this Carrier.


        :param account_manager: The account_manager of this Carrier.
        :type: AccountManager
        """
        
        self._account_manager = account_manager

    @property
    def support(self):
        """
        Gets the support of this Carrier.


        :return: The support of this Carrier.
        :rtype: Support
        """
        return self._support

    @support.setter
    def support(self, support):
        """
        Sets the support of this Carrier.


        :param support: The support of this Carrier.
        :type: Support
        """
        
        self._support = support

    @property
    def noc_support(self):
        """
        Gets the noc_support of this Carrier.


        :return: The noc_support of this Carrier.
        :rtype: NocSupport
        """
        return self._noc_support

    @noc_support.setter
    def noc_support(self, noc_support):
        """
        Sets the noc_support of this Carrier.


        :param noc_support: The noc_support of this Carrier.
        :type: NocSupport
        """
        
        self._noc_support = noc_support

    @property
    def services(self):
        """
        Gets the services of this Carrier.


        :return: The services of this Carrier.
        :rtype: list[Service]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this Carrier.


        :param services: The services of this Carrier.
        :type: list[Service]
        """
        
        self._services = services

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Carrier.
        The URI for this object

        :return: The self_uri of this Carrier.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Carrier.
        The URI for this object

        :param self_uri: The self_uri of this Carrier.
        :type: str
        """
        
        self._self_uri = self_uri

    @property
    def address(self):
        """
        Gets the address of this Carrier.


        :return: The address of this Carrier.
        :rtype: CarrierAddress
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this Carrier.


        :param address: The address of this Carrier.
        :type: CarrierAddress
        """
        
        self._address = address

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

